#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include "../include/ebtables_u.h"
#include <linux/netfilter_bridge/ebt_mark_t.h>

static int mark_supplied;

#define MARK_TARGET   '1'
#define MARK_SETMARK  '2'
#define MARK_SETRMARK '3'
/*add by pengyao 20101011*/
#define MARK_ORMARK   '4'
#define MARK_ORRMARK  '5'
#define MARK_ANDMARK  '6'
#define MARK_ANDRMARK '7'


static struct option opts[] =
{
	{ "mark-target" , required_argument, 0, MARK_TARGET },
	{ "set-mark"    , required_argument, 0, MARK_SETMARK },
	{ "set-rmark"    , required_argument, 0, MARK_SETRMARK },
    { "or-mark"    , required_argument, 0, MARK_ORMARK },
    { "or-rmark"    , required_argument, 0, MARK_ORRMARK },
    { "and-mark"    , required_argument, 0, MARK_ANDMARK },
    { "and-rmark"    , required_argument, 0, MARK_ANDRMARK },
	{ 0 }
};

static void print_help()
{
	printf(
	"mark target options:\n"
	" --set-mark value     : Set mark value\n"
	" --and-mark value     : nad mark value\n"
	" --or-mark value     : or mark value\n"
	" --set-rmark value     : Set rnfmark value\n"
	" --and-rmark value     : and rnfmark value\n"
	" --or-rmark value     : or rnfmark value\n"
	" --mark-target target : ACCEPT, DROP, RETURN or CONTINUE\n");
}

static void init(struct ebt_entry_target *target)
{
	struct ebt_mark_t_info *markinfo =
	   (struct ebt_mark_t_info *)target->data;

	markinfo->target = EBT_CONTINUE;
	markinfo->setmark = 0;
    markinfo->andmark = 0;
    markinfo->ormark = 0;
	markinfo->setrmark = 0;
    markinfo->andrmark = 0;
    markinfo->orrmark = 0;
	markinfo->flag = 0;
	mark_supplied = 0;
}

#define OPT_MARK_TARGET   (0x01<<0)
#define OPT_MARK_SETMARK  (0x01<<1)
#define OPT_MARK_SETRMARK (0x01<<2)
#define OPT_MARK_ORMARK   (0x01<<3)
#define OPT_MARK_ORRMARK  (0x01<<4)
#define OPT_MARK_ANDMARK  (0x01<<5)
#define OPT_MARK_ANDRMARK (0x01<<6)


static int parse(int c, char **argv, int argc,
   const struct ebt_u_entry *entry, unsigned int *flags,
   struct ebt_entry_target **target)
{
	struct ebt_mark_t_info *markinfo =
	   (struct ebt_mark_t_info *)(*target)->data;
	char *end;

	switch (c) {
	case MARK_TARGET:
		ebt_check_option2(flags, OPT_MARK_TARGET);
		if (FILL_TARGET(optarg, markinfo->target))
			ebt_print_error2("Illegal --mark-target target");
		break;

	case MARK_SETMARK:
		ebt_check_option2(flags, OPT_MARK_SETMARK);
		markinfo->setmark = strtoul(optarg, &end, 0);
		if (*end != '\0' || end == optarg)
			ebt_print_error2("Bad MARK value '%s'", optarg);

		markinfo->flag |= OPT_MARK_SETMARK;
		
		mark_supplied = 1;
		break;

	case MARK_SETRMARK:
		ebt_check_option2(flags, OPT_MARK_SETRMARK);
		markinfo->setrmark = strtoul(optarg, &end, 0);
		if (*end != '\0' || end == optarg)
			ebt_print_error2("Bad RMARK value '%s'", optarg);

		markinfo->flag |= OPT_MARK_SETRMARK;
		mark_supplied = 1;
		break;

    case MARK_ANDMARK:
        ebt_check_option2(flags, OPT_MARK_ANDMARK);
        markinfo->andmark = strtoul(optarg, &end, 0);
        if (*end != '\0' || end == optarg)
            ebt_print_error2("Bad MARK value '%s'", optarg);

        markinfo->flag |= OPT_MARK_ANDMARK;
        mark_supplied = 1;
        break;

    case MARK_ANDRMARK:
        ebt_check_option2(flags, OPT_MARK_ANDRMARK);
        markinfo->andrmark = strtoul(optarg, &end, 0);
        if (*end != '\0' || end == optarg)
            ebt_print_error2("Bad RMARK value '%s'", optarg);

        markinfo->flag |= OPT_MARK_ANDRMARK;
        mark_supplied = 1;
        break;

    case MARK_ORMARK:
        ebt_check_option2(flags, OPT_MARK_ORMARK);
        markinfo->ormark = strtoul(optarg, &end, 0);
        if (*end != '\0' || end == optarg)
            ebt_print_error2("Bad MARK value '%s'", optarg);

        markinfo->flag |= OPT_MARK_ORMARK;
        mark_supplied = 1;
        break;

    case MARK_ORRMARK:
        ebt_check_option2(flags, OPT_MARK_ORRMARK);
        markinfo->orrmark = strtoul(optarg, &end, 0);
        if (*end != '\0' || end == optarg)
            ebt_print_error2("Bad RMARK value '%s'", optarg);

        markinfo->flag |= OPT_MARK_ORRMARK;
        mark_supplied = 1;
        break;
	 default:
		return 0;
	}
	return 1;
}

static void final_check(const struct ebt_u_entry *entry,
   const struct ebt_entry_target *target, const char *name,
   unsigned int hookmask, unsigned int time)
{
	struct ebt_mark_t_info *markinfo =
	   (struct ebt_mark_t_info *)target->data;

	if (time == 0 && mark_supplied == 0)
		ebt_print_error2("No mark value supplied");
#if 0
	if (BASE_CHAIN && markinfo->target == EBT_RETURN)
		print_error("--mark-target RETURN not allowed on base chain");
#endif
}

static void print(const struct ebt_u_entry *entry,
   const struct ebt_entry_target *target)
{
	struct ebt_mark_t_info *markinfo =
	   (struct ebt_mark_t_info *)target->data;

	if (markinfo->flag & OPT_MARK_SETMARK)
		printf(" --set-mark 0x%lx", markinfo->setmark);

	if (markinfo->flag & OPT_MARK_ANDMARK)
		printf(" --and-mark 0x%lx", markinfo->andmark);

	if (markinfo->flag & OPT_MARK_ORMARK)
		printf(" --or-mark 0x%lx", markinfo->ormark);

	if (markinfo->flag & OPT_MARK_SETRMARK)
		printf(" --set-rmark 0x%lx", markinfo->setrmark);

	if (markinfo->flag & OPT_MARK_ANDRMARK)
		printf(" --and-rmark 0x%lx", markinfo->andrmark);

	if (markinfo->flag & OPT_MARK_ORRMARK)
		printf(" --or-rmark 0x%lx", markinfo->orrmark);

	if (markinfo->target == EBT_ACCEPT)
		return;
	printf(" --mark-target %s", TARGET_NAME(markinfo->target));
}

static int compare(const struct ebt_entry_target *t1,
   const struct ebt_entry_target *t2)
{
	struct ebt_mark_t_info *markinfo1 =
	   (struct ebt_mark_t_info *)t1->data;
	struct ebt_mark_t_info *markinfo2 =
	   (struct ebt_mark_t_info *)t2->data;

	return  markinfo1->target == markinfo2->target &&
			markinfo1->setmark == markinfo2->setmark &&
			markinfo1->setrmark == markinfo2->setrmark &&
			markinfo1->andmark == markinfo2->andmark &&
			markinfo1->andrmark == markinfo2->andrmark &&
			markinfo1->ormark == markinfo2->ormark &&
			markinfo1->orrmark == markinfo2->orrmark;
}

static struct ebt_u_target mark_target =
{
	.name		= EBT_MARK_TARGET,
	.size		= sizeof(struct ebt_mark_t_info),
	.help		= print_help,
	.init		= init,
	.parse		= parse,
	.final_check	= final_check,
	.print		= print,
	.compare	= compare,
	.extra_ops	= opts,
};

void _init(void)
{
	ebt_register_target(&mark_target);
	//register_target(&mark_target);
}
