#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>    
#include "../include/ebtables_u.h"
#include <linux/netfilter_bridge/ebt_imq.h>

#define IMQ_TODEV '1'
#define IMQ_MODE '2'

static struct option opts[] =    
{    
	{ "todev"           , required_argument, 0, IMQ_TODEV },    
	{ "mode"           , required_argument, 0, IMQ_MODE},    
	{ 0 }    
};    
    
static void help(void)    
{    
  printf(    
    "IMQ options:\n"    
	" --mode <1|2>: Set imq bridge mode.\n"
    "  --todev <N>         enqueue to imq<N>, defaults to 0\n");    
}    
    
static void init(struct ebt_entry_target *target)    
{    
  struct ebt_imq_info *imqinfo = (struct ebt_imq_info *)target->data;    
    
  imqinfo->todev = 0;    
  imqinfo->target = EBT_ACCEPT;    
}    
    
#define OPT_IMQ_TODEV 0x01
#define OPT_IMQ_MODE  0x02
static int parse(int c, char **argv, int argc, const struct ebt_u_entry *entry,    
   unsigned int *flags, struct ebt_entry_target **target)    
{    
  struct ebt_imq_info *imqinfo = (struct ebt_imq_info *)(*target)->data;    
    
  switch(c) {    
  case IMQ_TODEV:    
	ebt_check_option2(flags, OPT_IMQ_TODEV);
    imqinfo->todev = atoi(optarg);    
	imqinfo->target = (imqinfo->target & EBT_VERDICT_BITS) | MARK_IMQ_TODEV;
	break;
  /* TBS_TAG: add by baiyonghui 2011-9-10 for һimq mode ־λ*/
  case IMQ_MODE: 
    imqinfo->todev = atoi(optarg);
  	if((imqinfo->todev > 2)|| (imqinfo->todev <1))
		ebt_print_error2("--mode <1|2>");
	ebt_check_option2(flags, OPT_IMQ_MODE);
	imqinfo->target = (imqinfo->target & EBT_VERDICT_BITS) | MARK_IMQ_MODE;
  	break;
  }
   // imqinfo->todev = atoi(optarg);    
    
  return 1;    
}    
    
static void final_check(const struct ebt_u_entry *entry,    
   const struct ebt_entry_target *target, const char *name,    
   unsigned int hookmask, unsigned int time)    
{    
}    
    
static void print(const struct ebt_u_entry *entry,    
   const struct ebt_entry_target *target)    
{    
  struct ebt_imq_info *imqinfo = (struct ebt_imq_info *)target->data;    

	int tmp = imqinfo->target & ~EBT_VERDICT_BITS;
	if (tmp == MARK_IMQ_TODEV)
		  printf("--todev %d", imqinfo->todev);    
	else if (tmp == MARK_IMQ_MODE)
		printf("--mode %d", imqinfo->todev);//(imqinfo->target & EBT_VERDICT_BITS) | MARK_IMQ_MODE);
	else
		ebt_print_error("oops, unknown mark action, try a later version of ebtables");
}    
    
static int compare(const struct ebt_entry_target *t1,    
   const struct ebt_entry_target *t2)    
{    
  struct ebt_imq_info *imqinfo1 = (struct ebt_imq_info *)t1->data;    
  struct ebt_imq_info *imqinfo2 = (struct ebt_imq_info *)t2->data;    
  if (imqinfo1->todev != imqinfo2->todev)    
    return 0;   
   
  return 1;   
}   
   
static struct ebt_u_target imq_target =   
{   
	.name		= "imq",   
	.size		= sizeof(struct ebt_imq_info),   
	.help		= help,   
	.init		= init,   
	.parse		= parse,   
	.final_check	= final_check,   
	.print		= print,   
	.compare	= compare,   
	.extra_ops	= opts,   
};

void _init(void)   
{   
	ebt_register_target(&imq_target);   
}

