/**********************************************************************
 Copyright (c), 1991-2009, T&W ELECTRONICS(SHENZHEN) Co., Ltd.
 ļ: new_conf.c
 ļ: ȡdproxyļ
 ޶¼:
        1. : lichuang
           : 2009-3-23
           : ļ
**********************************************************************/

#include "new_conf.h"
#include "dproxy.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define BUFFER_LEN 200

ST_DNS_CONFIG g_stConfig;

static void init_config();

/*************************************************************************
    : ȡļ
    :
  		pConfig ļ·
  ֵ: ɹ0, ʧܷ-1
*************************************************************************/
int load_config(const char* pConfig)
{
	FILE *pFile;
	char szBuffer[BUFFER_LEN];
	char *pLan, *pIp, *pWan;
	ST_LAN_INFO *pLanInfo;
	unsigned char i;

	init_config();

	if (!pConfig || NULL == (pFile = fopen(pConfig, "r")))
	{
		return -1;
	}

	strcpy(g_stConfig.szConfigFile, pConfig);

	while (fgets(szBuffer, BUFFER_LEN, pFile))
	{
		szBuffer[strlen(szBuffer) - 1] = '\0';
		pLan = strtok(szBuffer, " ");
		pIp = strtok(NULL, " ");
		pWan = strtok(NULL, " ");

		if (!pLan || !pIp || !pWan)
		{
			continue;
		}

		for (pLanInfo = g_stConfig.pLanInfo; pLanInfo; pLanInfo = pLanInfo->pNext)
		{
			if (!strcmp(pLanInfo->szName, pLan))
			{
				break;
			}
		}
		if (!pLanInfo)
		{
			pLanInfo = (ST_LAN_INFO*)malloc(sizeof(ST_LAN_INFO));
			if (!pLanInfo)
			{
				return -1;
			}
			memset(pLanInfo, 0, sizeof(ST_LAN_INFO));
			pLanInfo->pNext = g_stConfig.pLanInfo;
			g_stConfig.pLanInfo = pLanInfo;
			strcpy(pLanInfo->szName, pLan);
			strcpy(pLanInfo->szWanIf, pWan);
			snprintf(pLanInfo->szCacheFile, sizeof(pLanInfo->szCacheFile)
					,"/var/cache/%s.cache", pLan);
		}
		if (strcmp(pIp, "0.0.0.0"))
		{
			for (i = 0; i < NUM_OF_DNS; ++i)
			{
				if (!strlen(pLanInfo->szDnsIp[i]))
				{
					strcpy(pLanInfo->szDnsIp[i], pIp);
					break;
				}
			}
		}

	}

	fclose(pFile);
#if 0
	for (pLanInfo = g_stConfig.pLanInfo; pLanInfo; pLanInfo = pLanInfo->pNext)
	{
		debug("%s %s %s %s %s\n"
				, pLanInfo->szName
				, pLanInfo->szDnsIp[0]
				, pLanInfo->szDnsIp[1]
				, pLanInfo->szDnsIp[2]
				, pLanInfo->szCacheFile);
	}
#endif

	return 0;
}

void init_config()
{
    if (g_stConfig.pLanInfo)
    {
        ST_LAN_INFO *pNext;
        for (pNext = g_stConfig.pLanInfo; pNext; pNext = g_stConfig.pLanInfo)
        {
            g_stConfig.pLanInfo = pNext->pNext;
            free(pNext);
        }
    }
	g_stConfig.pLanInfo = NULL;
	g_stConfig.ucDeamon = 0;
	g_stConfig.nPurgeTime = 60 * 60;
	strcpy(g_stConfig.szHostFile, "/etc/hosts");
	strcpy(g_stConfig.szCacheFile, "/var/cache/dproxy.cache");
	strcpy(g_stConfig.szErrCacheFile, "/var/cache/slave.cache");
}


