#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <linux/sockios.h>
#include <linux/if.h>
#include "dns_io.h"
#include "dns_decode.h"
#include "string.h"

#define SO_BINDDEVICE	40
#define SIOCGRECVIF   0x8909
/*****************************************************************************/
int dns_read_packet(int sock, dns_request_t *m, unsigned char ucFlag)
{
    struct sockaddr_in sa;
    socklen_t salen;
	char szRecvDev[64];
	ST_LAN_INFO *pLanInfo;
    /* Read in the actual packet */
    salen = sizeof(sa);

    m->numread = recvfrom(sock, m->original_buf, sizeof(m->original_buf), 0,
            (struct sockaddr *)&sa, &salen);

    if ( m->numread < 0) {
        debug_perror("dns_read_packet: recvfrom\n");
        return -1;
    }

   /* record where it came from */
	debug("recv packet from %s", inet_ntoa (sa.sin_addr) );
	memcpy( (void *)&m->src_addr, (void *)&sa.sin_addr, sizeof(struct in_addr));
    m->src_port = ntohs( sa.sin_port );

	/*
	 * add by lichuang(2009.3.25)
	 */
	debug("flag = %d\n", ucFlag);
  	if (ucFlag)
  	{
	  	ioctl(sock, SIOCGRECVIF, szRecvDev);
	  	debug("--------------%s----------, len = %d\n", szRecvDev, strlen(szRecvDev));
		for (pLanInfo = g_stConfig.pLanInfo; pLanInfo; pLanInfo = pLanInfo->pNext)
		{
			if (!strncmp(pLanInfo->szName, szRecvDev, strlen(pLanInfo->szName)))
			{
				debug("find %s\n", szRecvDev);
				break;
			}
		}
		if (!pLanInfo)
		{
	  		debug("can not find %s\n", szRecvDev);
			return -2;
		}
		m->pNode = pLanInfo;
		m->ucIndex = 0;
  	}

    /* TODO: check source addr against list of allowed hosts */

    /* check that the message is long enough */
    if( m->numread < sizeof (m->message.header) ){
        debug("dns_read_packet: packet from '%s' to short to be dns packet",
                inet_ntoa (sa.sin_addr) );
        return -1;
    }

    /* reset cache flag */
    m->cache=0;

    /* pass on for full decode */
    dns_decode_request( m );

    return 0;
}
/*****************************************************************************/
int dns_write_packet(int sock, struct in_addr in, int port, dns_request_t *m, int request)
{
    struct sockaddr_in sa;
    struct ifreq ifr;
    int retval;

    /* 󶨳豸֤Ĵָwan豸ȥ */
    if (request)
    {
        /* Adding setsockopt to set a mark value for policy route. */
        strcpy(ifr.ifr_name, m->pNode->szWanIf);
        if (setsockopt(sock, SOL_SOCKET, SO_BINDDEVICE, &ifr, sizeof(ifr)) < 0)
        {
            debug("dns_write_packet: Unable to bind device %s\n", ifr.ifr_name);
        }
    }

    /* Zero it out */
    memset((void *)&sa, 0, sizeof(sa));

    /* Fill in the information */
    //inet_aton( "203.12.160.35", &in );
    memcpy( &sa.sin_addr.s_addr, &in, sizeof(in) );
    sa.sin_port = htons(port);
    sa.sin_family = AF_INET;

    retval = sendto(sock, m->original_buf, m->numread, 0,
            (struct sockaddr *)&sa, sizeof(sa));

    if( retval < 0 ){
        debug_perror("dns_write_packet: sendto");
    }

    return retval;
}
