/*
 * Copyright (C) 2006 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * High Level Configuration Options
 */
#define CONFIG_COMCERTO		1
#define CONFIG_ARM1136 		1	/* This is an arm1136j-s CPU core */
#define CONFIG_COMCERTO_100	1	/* It's an  SoC */
#define CONFIG_COMCERTO_50      1  /* It's an SoC and subset of C100 */
#undef  CONFIG_USE_IRQ		/* we don't need IRQ/FIQ stuff  */

#define CONFIG_COMCERTO50_PFLASH  1 /* 128K sector size */

/* Mindspeed version */
#define CONFIG_IDENT_STRING	" Mindspeed $Name: u-boot_3_00_4 $"

/*
 * Linux boot configuration
 */

#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs      */
#define CONFIG_SETUP_MEMORY_TAGS	1
//#define CONFIG_INITRD_TAG		1

#define LINUX_BOOTPARAM_ADDR		(PHYS_SDRAM + MSP_BOTTOM_MEMORY_RESERVED_SIZE + 0x100)

/*
 *	Relocation options
 */
//#define CONFIG_SKIP_RELOCATE_UBOOT
//#define CONFIG_SKIP_LOWLEVEL_INIT

/*
 * RAM configuration
 */

/*
 * Memory Mapping
 */

#define CONFIG_NR_DRAM_BANKS	1
#define PHYS_SDRAM		0x80000000
#define PHYS_SDRAM_SIZE		0x04000000	/* 64 MB */

/*
 * Hardware drivers
 */

/*
 * UART configuration
 */  
/* define one of these to choose the UART0 or UART1 as console */
#define CONFIG_UART0		1
#define CONFIG_BAUDRATE		115200
#define CFG_BAUDRATE_TABLE	{115200, 19200, 38400, 57600, 9600}

/*
 * Emac Settings
 */
#define CONFIG_COMCERTO_GEMAC	1

// GEMAC mode configured by bootstrap pins or SW
#undef CONFIG_COMCERTO_MII_CFG_BOOTSTRAP
//#define CONFIG_COMCERTO_MII_CFG_BOOTSTRAP

#define GEMAC0_PHY_ADDR		0
#define GEMAC0_CONFIG		CONFIG_COMCERTO_USE_RGMII
#define GEMAC0_MODE		(GEMAC_SW_CONF | GEMAC_SW_FULL_DUPLEX | GEMAC_SW_SPEED_1G)
#define GEMAC0_PHY_FLAGS	GEMAC_PHY_AUTONEG
#define GEMAC0_PHYIDX		0

#define GEMAC1_PHY_ADDR		0
#define GEMAC1_CONFIG		CONFIG_COMCERTO_USE_RGMII
#define GEMAC1_MODE		(GEMAC_SW_CONF | GEMAC_SW_FULL_DUPLEX | GEMAC_SW_SPEED_1G)
#define GEMAC1_PHY_FLAGS	GEMAC_NO_PHY
#define GEMAC1_PHYIDX		0

#define CONFIG_NET_MULTI	1

/*
 * Shell configuration
 */
#define CONFIG_COMMANDS		(CFG_CMD_FLASH | CFG_CMD_ENV | CFG_CMD_MEMORY | CFG_CMD_RUN | CFG_CMD_NET |  /*CFG_CMD_NAND |*/ CFG_CMD_JFFS2 | CFG_CMD_PING | CFG_CMD_NFS | CFG_CMD_SPI | CFG_CMD_ELF | CFG_CMD_MII)

#define	CFG_LONGHELP					/* undef to save memory		*/
#define CFG_PROMPT		"Comcerto-50 > "	/* Monitor Command Prompt */
#define CFG_CBSIZE		256			/* Console I/O Buffer Size */
#define CFG_MAXARGS		16			/* max number of command args */
#define CFG_PBSIZE		(CFG_CBSIZE + sizeof(CFG_PROMPT) + 16)	/* Print Buffer Size */

/*
 * User Interface
 */
#define	CONFIG_EXTRA_ENV_SETTINGS				\
	"hostname=comcerto100\0"						\
	"netdev=eth0\0"									\
	"nfsargs=setenv bootargs init=${init_process} root=/dev/nfs rw "		\
		"nfsroot=${serverip}:${rootpath}\0"				\
	"flashargs=setenv bootargs init=${init_process} root=/dev/mtdblock2 rootfstype=${rootfstype} rw\0"	\
	"rootfstype=jffs2\0" \
	"init_process=/etc/preinit\0" \
	"addip=setenv bootargs ${bootargs} "				\
		"ip=${ipaddr}:${serverip}:${gatewayip}:${netmask}"	\
		":${hostname}:${netdev}:off\0" \
	"addeth=setenv bootargs ${bootargs} " \
	"hwaddress=${netdev},${ethaddr}\0" \
	"addtty=setenv bootargs ${bootargs} console=ttyS0,${baudrate}\0" \
	"addmtd=setenv bootargs ${bootargs} ${mtdparts}\0" \
	"flash_self=run flashargs addip addtty;"		\
		"bootm ${kernel_addr}\0"				\
	"boot_nfs=nfs 80600000 ${rootpath}/boot/${kernelfile};run nfsargs addeth addip addtty;"     \
	        "bootm 80600000\0"						\
	"boot_flash=run flashargs addeth addtty addmtd; fsload /boot/uImage; bootm\0" \
	"rootpath=/devel/fs-router\0" \
	"kernelfile=uImage\0" \
	"mtdids=" MTDIDS_DEFAULT "\0" \
	"mtdparts=" MTDPARTS_DEFAULT "\0" \
	"partition=" MTDPARTITION_DEFAULT "\0" \
	"mtddevnum=2\0" \
	"mtddevname=fs\0" \
	"fsfile=root.jffs2-64k\0" \
	"updatefs=" UPDATEFS_PARAMS "\0" \
	"updateboot=" UPDATEBOOT_PARAMS "\0" \
	""

#define CONFIG_ETHADDR		00:aa:bb:cc:dd:ee
#define CONFIG_IPADDR		192.168.0.2
#define CONFIG_SERVERIP		192.168.0.1
#define CONFIG_BOOTDELAY	3

#include <cmd_confdefs.h>

#define CFG_LOAD_ADDR		(PHYS_SDRAM + 0x01000000)	/* default load address */

#define CFG_MEMTEST_START	CFG_LOAD_ADDR	/* memtest works on */
#define CFG_MEMTEST_END		(CFG_MEMTEST_START + 0x800000)

#define BOARD_LATE_INIT
#define MSP_BOTTOM_MEMORY_RESERVED_SIZE	0x800000	/* 8 MiB reserved for MSP */
#define MSP_TOP_MEMORY_RESERVED_SIZE	0x0		/* 0 MiB reserved for MSP */


/*
 * Network Configuration
 */
#define CONFIG_NET_RETRY_COUNT		5

/*
 * Flash Configuration - Using CFI driver 
 */
//#define CFG_FLASH_AM040_DRIVER	1		/* enable AM040 flash driver */
#undef CFG_FLASH_AM040_DRIVER				/* disable AM040 flash driver */

//#define CFG_FLASH_AMLV640U_DRIVER	1		/* enable AMLV640U flash driver */
#undef CFG_FLASH_AMLV640U_DRIVER			/* disable AMLV640U flash driver */
//#define CFG_FLASH_AMLV640U_SIZE	0x400000	/* (Acessible) Size of the AMLV640U flash device */

#define CFG_FLASH_CFI_DRIVER		1	/* enable CFI driver */
//#undef CFG_FLASH_CFI_DRIVER			/* disable CFI driver */

#if defined(CONFIG_COMCERTO50_PFLASH)
#define CFG_MAX_FLASH_SECT		128	/* max # of sectors on one chip */
#else
#define CFG_MAX_FLASH_SECT		256	/* max # of sectors on one chip */
#endif
#undef CFG_FLASH_PROTECTION

#define PHYS_FLASH1			0x20000000	/* Flash Bank #1 */
#if defined(CONFIG_COMCERTO50_PFLASH)
#define PHYS_FLASH1_SECT_SIZE		0x00020000	/* 128 KiB sectors */
#else
#define PHYS_FLASH1_SECT_SIZE		0x00010000	/* 64 KiB sectors */
#endif

#define CFG_MAX_FLASH_BANKS		1       /* max num of flash banks */
#define CFG_FLASH_BANKS_LIST		{ PHYS_FLASH1 }

#define CFG_FLASH_ERASE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT		(2 * CFG_HZ)	/* Timeout for Flash Write */


#define CFG_FLASH_COMPLEX_MAPPINGS

/*
 * CFI driver 
 */
#if defined(CFG_FLASH_CFI_DRIVER)
#define CFG_FLASH_CFI			1	/* flash is CFI conformant      */
#define CFG_FLASH_USE_BUFFER_WRITE	1	/* use buffered writes (20x faster) */
#define CFG_FLASH_QUIET_TEST

/*
 * Monitor configuration
 */
#define CFG_MONITOR_BASE        PHYS_FLASH1
#define CFG_MONITOR_LEN         (2 * PHYS_FLASH1_SECT_SIZE)	/* Reserve 128 KiB for Monitor */
#endif


/*
 * Enviroment in flash
 */
#define CFG_ENV_IS_IN_FLASH	1

#if defined(CFG_ENV_IS_IN_FLASH)
#if defined(CONFIG_COMCERTO50_PFLASH)
#define CFG_ENV_ADDR		(PHYS_FLASH1 + 2 * PHYS_FLASH1_SECT_SIZE)	/* Keep 2 sectors for U-boot image */
#else
#define CFG_ENV_ADDR		(PHYS_FLASH1 + 4 * PHYS_FLASH1_SECT_SIZE)	/* Keep 4 sectors for U-boot image */
#endif
#define CFG_ENV_SECT_SIZE	PHYS_FLASH1_SECT_SIZE
//#define CFG_ENV_ADDR_REDUND	(CFG_ENV_ADDR + CFG_ENV_SECT_SIZE)
#endif

#define CFG_ENV_SIZE		0x4000	/* Total Size of Environment 16KiB */
  
#define CONFIG_ENV_OVERWRITE	1



/*
 * NAND Configuration
 */
#if (CONFIG_COMMANDS & CFG_CMD_NAND)
#define CFG_NAND_BASE			EXP_CSP4_BASEADDR
#define CFG_MAX_NAND_DEVICE		1
#define NAND_MAX_CHIPS			1
#define CONFIG_JFFS2_NAND		1

#endif

/* NAND GPIOs config */
#define CFG_NAND_BR_GPIO	6
#define CFG_NAND_CE_GPIO	29
#define CFG_NAND_CLE_GPIO	31
#define CFG_NAND_ALE_GPIO	30

/*
 * JFFS2 Configuration
 */
/* mtdparts command line support */
#define CONFIG_JFFS2_CMDLINE
#define MTDIDS_DEFAULT		"nor0=comcertoflash.0"
#define MTDPARTS_DEFAULT	"mtdparts=comcertoflash.0:256k(u-boot),128k(env),16000k(fs)"
#define MTDPARTITION_DEFAULT	"nor0,2"

/* jffs & u-boot flashing paramters */
#if defined(CONFIG_COMCERTO50_PFLASH)
#define UPDATEFS_PARAMS "tftp 81000000 ${fsfile};protect off 1:3-127\;erase 1:3-127;cp.b 81000000 20060000 ${filesize}"
#define UPDATEBOOT_PARAMS "tftp 81000000 u-boot.bin;protect off 1:0-1\;erase 1:0-1;cp.b 81000000 20000000 ${filesize}"
#else
#define UPDATEFS_PARAMS "tftp 81000000 ${fsfile};protect off 1:6-255\;erase 1:6-255;cp.b 81000000 20060000 ${filesize}"
#define UPDATEBOOT_PARAMS "tftp 81000000 u-boot.bin;protect off 1:0-3\;erase 1:0-3;cp.b 81000000 20000000 ${filesize}"
#endif


#define CFG_REFCLKFREQ		24000000	/* 24 MHz */

#define CFG_HZ			1000
#define CFG_HZ_CLOCK		125000000	/* 125 MHz */
#define CFG_ARM_CLOCK		150000000	/* 150 MHz, must be multiple of 25MHz */

/*
 * Initial stack configuration
 */
#define CFG_INIT_RAM_ADDR	0x0A000000 /* ARAM_BASEADDR Base address */
#define CFG_INIT_RAM_END	0x00010000 /* 64K */
#define CFG_ARAM_CODE_SIZE	0x00008000 /* 32K */

#define CFG_INIT_SP_OFFSET	CFG_GBL_DATA_OFFSET - CFG_ARAM_CODE_SIZE



/*
 * Malloc/stack configuration
 */
#define CFG_MALLOC_LEN		(CFG_ENV_SIZE + 128 * 1024)
#define CFG_GBL_DATA_SIZE	128	/* size in bytes reserved for initial data */
#define CFG_GBL_DATA_OFFSET	(CFG_INIT_RAM_END - CFG_GBL_DATA_SIZE)

#define CONFIG_STACKSIZE	(32 * 1024)	/* regular stack */

#ifdef CONFIG_USE_IRQ
#error CONFIG_USE_IRQ not supported
#endif

/*
* DDR Training algorithm
*/
#define DDR_TRAINING
//#undef DDR_TRAINING

#endif /* __CONFIG_H */
