#ifndef __COMCERTO_1000_H__
#define __COMCERTO_1000_H__

/* to be moved somewhere else */
#include <asm/arch/bits.h>

#define CLKCORE_ARM_PLL_DEFAULT	650000000
#define CLKCORE_AHB_PLL_DEFAULT	800000000
#define CLKCORE_PHY_PLL_DEFAULT	250000000

/* memcore */
/* device memory base addresses */
// device memory sizes
#define ARAM_SIZE		0x00020000 /* 128K */
#define ARAM_BASEADDR		0x0A000000

/* Hardware Interface Units */
#define APB_BASEADDR		0x10000000
#define APB_SIZE		0x01000000 /* 16M address range */

#define EXP_CS0_BASEADDR	0x20000000
#define EXP_CS1_BASEADDR	0x24000000
#define EXP_CS2_BASEADDR	0x28000000
#define EXP_CS3_BASEADDR	0x2C000000
#define EXP_CS4_BASEADDR	0x30000000

#define DDR_BASEADDR		0x80000000

#define TDM_BASEADDR		(APB_BASEADDR + 0x000000)
#define TDMA_BASEADDR		(APB_BASEADDR + 0x020000)
#define AHB_BASEADDR		(APB_BASEADDR + 0x040000)
#define TIMER_BASEADDR		(APB_BASEADDR + 0x050000)
#define PCIE_PHY_BASEADDR	(APB_BASEADDR + 0x060000)
#define GPIO_BASEADDR		(APB_BASEADDR + 0x070000)
#define UART0_BASEADDR		(APB_BASEADDR + 0x090000)
#define UART1_BASEADDR		(APB_BASEADDR + 0x094000)
#define SPI_BASEADDR		(APB_BASEADDR + 0x098000)
#define I2C_BASEADDR		(APB_BASEADDR + 0x09C000)
#define INTC_BASEADDR		(APB_BASEADDR + 0x0A0000)
#define CLKCORE_BASEADDR	(APB_BASEADDR + 0x0B0000)
#define GEMAC_BASEADDR		(APB_BASEADDR + 0x0D0000)
#define MEMCORE_BASEADDR	(APB_BASEADDR + 0x0F0000)
#define GEMAC1_BASEADDR		(APB_BASEADDR + 0x190000)
#define EBUS_BASEADDR		(APB_BASEADDR + 0x1A0000)
#define MDMA_BASEADDR		(APB_BASEADDR + 0x1E0000)


////////////////////////////////////////////////////////////
// 	SPI block												    //
////////////////////////////////////////////////////////////

#define SPI_CTRLR0_REG		(SPI_BASEADDR+0x00)
#define SPI_CTRLR1_REG		(SPI_BASEADDR+0x04)
#define SPI_SSIENR_REG		(SPI_BASEADDR+0x08)
#define SPI_MWCR_REG		(SPI_BASEADDR+0x0c)
#define SPI_SER_REG		(SPI_BASEADDR+0x10)
#define SPI_BAUDR_REG		(SPI_BASEADDR+0x14)
#define SPI_TXFTLR_REG		(SPI_BASEADDR+0x18)
#define SPI_RXFTLR_REG		(SPI_BASEADDR+0x1c)
#define SPI_TXFLR_REG		(SPI_BASEADDR+0x20)
#define SPI_RXFLR_REG		(SPI_BASEADDR+0x24)
#define SPI_SR_REG		(SPI_BASEADDR+0x28)
#define SPI_IMR_REG		(SPI_BASEADDR+0x2c)
#define SPI_ISR_REG		(SPI_BASEADDR+0x30)
#define SPI_RISR_REG		(SPI_BASEADDR+0x34)
#define SPI_TXOICR_REG		(SPI_BASEADDR+0x38)
#define SPI_RXOICR_REG		(SPI_BASEADDR+0x3c)
#define SPI_RXUICR_REG		(SPI_BASEADDR+0x40)
#define SPI_MSTICR_REG		(SPI_BASEADDR+0x44)
#define SPI_ICR_REG		(SPI_BASEADDR+0x48)
#define SPI_IDR_REG		(SPI_BASEADDR+0x58)
#define SPI_DR_REG		(SPI_BASEADDR+0x60)

////////////////////////////////////////////////////////////
//	AHB block											    //
////////////////////////////////////////////////////////////
#define AHB_LOWMEM_REMAP_CTRL		(AHB_BASEADDR + 0x00)
#define AHB_HIGHMEM_ADDR_TRANSLATION	(AHB_BASEADDR + 0x04)
#define AHB_STAGE2_ARBITER_CFG		(AHB_BASEADDR + 0x08)

////////////////////////////////////////////////////////////
// INTC block											    //
////////////////////////////////////////////////////////////

#define INTC_ARM1_CONTROL_REG	(INTC_BASEADDR + 0x18)



////////////////////////////////////////////////////////////
// TIMER block											    //
////////////////////////////////////////////////////////////

#define TIMER0_CNTR_REG		(TIMER_BASEADDR + 0x00)
#define TIMER0_CURR_COUNT	(TIMER_BASEADDR + 0x04)
#define TIMER1_CNTR_REG		(TIMER_BASEADDR + 0x08)
#define TIMER1_CURR_COUNT	(TIMER_BASEADDR + 0x0C)

#define TIMER2_CNTR_REG		(TIMER_BASEADDR + 0x18)
#define TIMER2_LBOUND_REG	(TIMER_BASEADDR + 0x10)
#define TIMER2_HBOUND_REG	(TIMER_BASEADDR + 0x14)
#define TIMER2_CURR_COUNT	(TIMER_BASEADDR + 0x1C)

#define TIMER3_LOBND            (TIMER_BASEADDR + 0x20)
#define TIMER3_HIBND            (TIMER_BASEADDR + 0x24)
#define TIMER3_CTRL             (TIMER_BASEADDR + 0x28)
#define TIMER3_CURR_COUNT       (TIMER_BASEADDR + 0x2C)

#define TIMER_MASK              (TIMER_BASEADDR + 0x40)
#define TIMER_STATUS            (TIMER_BASEADDR + 0x50)
#define TIMER_ACK               (TIMER_BASEADDR + 0x50)
#define TIMER_WDT_HIGH_BOUND	(TIMER_BASEADDR + 0xD0)
#define TIMER_WDT_CONTROL	(TIMER_BASEADDR + 0xD4)


////////////////////////////////////////////////////////////
//  EBUS block											    //
////////////////////////////////////////////////////////////

#define EX_SWRST_REG		(EBUS_BASEADDR + 0x00)
#define EX_CSEN_REG		(EBUS_BASEADDR + 0x04)
#define EX_CS0_SEG_REG		(EBUS_BASEADDR + 0x08)
#define EX_CS1_SEG_REG		(EBUS_BASEADDR + 0x0C)
#define EX_CS2_SEG_REG		(EBUS_BASEADDR + 0x10)
#define EX_CS3_SEG_REG		(EBUS_BASEADDR + 0x14)
#define EX_CS4_SEG_REG		(EBUS_BASEADDR + 0x18)
#define EX_CS0_CFG_REG		(EBUS_BASEADDR + 0x1C)
#define EX_CS1_CFG_REG		(EBUS_BASEADDR + 0x20)
#define EX_CS2_CFG_REG		(EBUS_BASEADDR + 0x24)
#define EX_CS3_CFG_REG		(EBUS_BASEADDR + 0x28)
#define EX_CS4_CFG_REG		(EBUS_BASEADDR + 0x2C)
#define EX_CS0_TMG1_REG		(EBUS_BASEADDR + 0x30)
#define EX_CS1_TMG1_REG		(EBUS_BASEADDR + 0x34)
#define EX_CS2_TMG1_REG		(EBUS_BASEADDR + 0x38)
#define EX_CS3_TMG1_REG		(EBUS_BASEADDR + 0x3C)
#define EX_CS4_TMG1_REG		(EBUS_BASEADDR + 0x40)
#define EX_CS0_TMG2_REG		(EBUS_BASEADDR + 0x44)
#define EX_CS1_TMG2_REG		(EBUS_BASEADDR + 0x48)
#define EX_CS2_TMG2_REG		(EBUS_BASEADDR + 0x4C)
#define EX_CS3_TMG2_REG		(EBUS_BASEADDR + 0x50)
#define EX_CS4_TMG2_REG		(EBUS_BASEADDR + 0x54)
#define EX_CS0_TMG3_REG		(EBUS_BASEADDR + 0x58)
#define EX_CS1_TMG3_REG		(EBUS_BASEADDR + 0x5C)
#define EX_CS2_TMG3_REG		(EBUS_BASEADDR + 0x60)
#define EX_CS3_TMG3_REG		(EBUS_BASEADDR + 0x64)
#define EX_CS4_TMG3_REG		(EBUS_BASEADDR + 0x68)
#define EX_CLOCK_DIV_REG	(EBUS_BASEADDR + 0x6C)
#define EX_MFSM_REG		(EBUS_BASEADDR + 0x100)
#define EX_CSFSM_REG		(EBUS_BASEADDR + 0x104)
#define EX_WRFSM_REG		(EBUS_BASEADDR + 0x108)
#define EX_RDFSM_REG		(EBUS_BASEADDR + 0x10C)

#define EX_CLK_EN		0x00000001
#define EX_CSBOOT_EN		0x00000002
#define EX_CS0_EN		0x00000002
#define EX_CS1_EN		0x00000004
#define EX_CS2_EN		0x00000008
#define EX_CS3_EN		0x00000010
#define EX_CS4_EN		0x00000020

#define EX_MEM_BUS_8		0x00000000
#define EX_MEM_BUS_16		0x00000002
#define EX_MEM_BUS_32		0x00000004
#define EX_CS_HIGH		0x00000008
#define EX_WE_HIGH		0x00000010
#define EX_RE_HIGH		0x00000020
#define EX_ALE_MODE		0x00000040
#define EX_STRB_MODE		0x00000080
#define EX_DM_MODE		0x00000100
#define EX_NAND_MODE		0x00000200
#define EX_RDY_EN		0x00000400
#define EX_RDY_EDGE		0x00000800


////////////////////////////////////////////////////////////
//  GPIO block												     //
////////////////////////////////////////////////////////////

#define GPIO_OUTPUT_REG			(GPIO_BASEADDR + 0x00)	// GPIO outputs register
#define GPIO_OE_REG			(GPIO_BASEADDR + 0x04)	// GPIO Output Enable register
#define GPIO_CONFIG_IRQ_REG		(GPIO_BASEADDR + 0x08)
#define GPIO_UP_ALIGN_ACCESS_LOGIC	(GPIO_BASEADDR + 0x0C)
#define GPIO_INPUT_REG			(GPIO_BASEADDR + 0x10)	// GPIO input register
#define APB_ACCESS_WS_REG		(GPIO_BASEADDR + 0x14)
#define USB_PHY_CONF_REG		(GPIO_BASEADDR + 0x18)
#define SYSCONF_REG			(GPIO_BASEADDR + 0x1C)
#define GPIO_ARM_ID_REG			(GPIO_BASEADDR + 0x30)
#define GPIO_GENERIC_PAD_CONTROL	(GPIO_BASEADDR + 0x34)
#define GPIO_BOOTSTRAP_STATUS_REG	(GPIO_BASEADDR + 0x40)
#define GPIO_BOOTSTRAP_OVERRIDE_REG	(GPIO_BASEADDR + 0x44)
#define GPIO_DEVID_REG			(GPIO_BASEADDR + 0x50)
#define GPIO_ARM_MEMORY_SENSE_REGS	(GPIO_BASEADDR + 0x54)
#define GPIO_PIN_SELECT_REG		(GPIO_BASEADDR + 0x58)


#define GPIO_PIN_SELECT_UART1	((1 << 22) | (1 << 23))

#define GPIO_0			0x01
#define GPIO_1			0x02
#define GPIO_2			0x04
#define GPIO_3			0x08
#define GPIO_4			0x10
#define GPIO_5			0x20
#define GPIO_6			0x40
#define GPIO_7			0x80

#define GPIO_RISING_EDGE	1
#define GPIO_FALLING_EDGE	2
#define GPIO_BOTH_EDGES		3


////////////////////////////////////////////////////////////
// UART													    //
////////////////////////////////////////////////////////////

#define UART_RBR		(UART_BASEADDR + 0x00)
#define UART_THR		(UART_BASEADDR + 0x00)
#define UART_DLL		(UART_BASEADDR + 0x00)
#define UART_IER		(UART_BASEADDR + 0x04)
#define UART_DLH		(UART_BASEADDR + 0x04)
#define UART_IIR		(UART_BASEADDR + 0x08)
#define UART_FCR		(UART_BASEADDR + 0x08)
#define UART_LCR		(UART_BASEADDR + 0x0C)
#define UART_MCR		(UART_BASEADDR + 0x10)
#define UART_LSR		(UART_BASEADDR + 0x14)
#define UART_MSR		(UART_BASEADDR + 0x18)
#define UART_SCR		(UART_BASEADDR + 0x1C)

////////////////////////////////////////////////////////////
// CLK  + RESET block 
////////////////////////////////////////////////////////////

#define CLKCORE_ARM_CLK_CNTRL		(CLKCORE_BASEADDR + 0x00)
#define CLKCORE_ARM_CLK_CNTRL2		(CLKCORE_BASEADDR + 0x04)
#define CLKCORE_AHB_CLK_CNTRL		(CLKCORE_BASEADDR + 0x08)
#define CLKCORE_AHB_CLK_CNTRL2		(CLKCORE_BASEADDR + 0x0C)
#define CLKCORE_PHY_CLK_CNTRL		(CLKCORE_BASEADDR + 0x10)
#define CLKCORE_PHY_CLK_CNTRL2		(CLKCORE_BASEADDR + 0x14)
#define CLKCORE_DDR_PCIE_CLK_CNTRL	(CLKCORE_BASEADDR + 0x18)
#define CLKCORE_TDM_CLK_CNTRL		(CLKCORE_BASEADDR + 0x1C)
#define CLKCORE_TDM_CLK_CNTRL2		(CLKCORE_BASEADDR + 0x20)
#define CLKCORE_FSYNC_CNTRL		(CLKCORE_BASEADDR + 0x24)
/*	reserved 0x28-0x3C	*/
#define CLKCORE_CLK_PWR_DWN		(CLKCORE_BASEADDR + 0x40)
#define CLKCORE_PLL_STATUS		(CLKCORE_BASEADDR + 0x44)
#define CLKCORE_RNG_CNTRL		(CLKCORE_BASEADDR + 0x48)
#define CLKCORE_RNG_STATUS		(CLKCORE_BASEADDR + 0x4C)

//Bit fields
// ARM_CLK_CNTRL register
#define ARM_CLK_CNTRL_ARM_REF_BYPASS	BIT29
#define ARM_CLK_CNTRL_PLL_ENSAT		BIT28
#define ARM_CLK_CNTRL_PLL_FASTEN	BIT27
#define ARM_CLK_CNTRL_PLL_TEST		BIT26
#define ARM_CLK_CNTRL_PLL_PWDN		BIT25
#define ARM_CLK_CNTRL_PLL_BYPASS	BIT24

// ARM_CLK_CNTRL2 register
#define ARM_CLK_CNTRL2_PLL_RESET	BIT31
#define ARM_CLK_CNTRL2_ARM1_AHB_BYPASS	BIT13
#define ARM_CLK_CNTRL2_ARM1_DIV_BYPASS	BIT12
#define ARM_CLK_CNTRL2_ARM0_AHB_BYPASS	BIT5
#define ARM_CLK_CNTRL2_ARM0_DIV_BYPASS	BIT4

// AHB_CLK_CNTRL register
#define AHB_CLK_CNTRL_AHB_REF_BYPASS	BIT31
#define AHB_CLK_CNTRL_SYNC_DIV_BYPASS	BIT30
#define AHB_CLK_CNTRL_SYNC_MODE		BIT29
#define AHB_CLK_CNTRL_PLL_PWDN		BIT25
#define AHB_CLK_CNTRL_PLL_BYPASS	BIT24
#define AHB_CLK_CNTRL_PLL_ENSAT		BIT23
#define AHB_CLK_CNTRL_PLL_FASTEN	BIT22

// AHB_CLK_CNTRL2 register
#define AHB_CLK_CNTRL2_PLL_RESET	BIT31
#define AHB_CLK_CNTRL2_PLL_TEST		BIT14
#define AHB_CLK_CNTRL2_AHB_DIV1_BYPASS	BIT13
#define AHB_CLK_CNTRL2_AHB_DIV0_BYPASS	BIT12

// PHY_CLK_CNTRL register
#define PHY_CLK_CNTRL_PHY_REF_BYPASS	BIT29
#define PHY_CLK_CNTRL_PLL_ENSAT		BIT28
#define PHY_CLK_CNTRL_PLL_FASTEN	BIT27
#define PHY_CLK_CNTRL_PLL_TEST		BIT26
#define PHY_CLK_CNTRL_PLL_PWDN		BIT25
#define PHY_CLK_CNTRL_PLL_BYPASS	BIT24

// PHY_CLK_CNTRL2 register
#define PHY_CLK_CNTRL2_PLL_RESET	BIT31
#define PHY_CLK_CNTRL2_PHY_DIV2_BYPASS	BIT14
#define PHY_CLK_CNTRL2_PHY_DIV1_BYPASS	BIT13
#define PHY_CLK_CNTRL2_PHY_DIV0_BYPASS	BIT12

// DDR_PCIE_CLK_CNTRL
#define DDR_PCIE_CLK_CNTRL_USB_DIV_BYPASS	BIT30
#define DDR_PCIE_CLK_CNTRL_IPsec_DIV1_BYPASS	BIT29
#define DDR_PCIE_CLK_CNTRL_IPsec_DIV0_BYPASS	BIT28
#define DDR_PCIE_CLK_CNTRL_PCIe_DIV_BYPASS	BIT27
#define DDR_PCIE_CLK_CNTRL_DDR_DIV_BYPASS	BIT26
#define DDR_PCIE_CLK_CNTRL_USB_MUX_SEL		BIT3
#define DDR_PCIE_CLK_CNTRL_IPsecMUX_SEL		BIT2
#define DDR_PCIE_CLK_CNTRL_PCIe_MUX_SEL		BIT1
#define DDR_PCIE_CLK_CNTRL_DDR_MUX_SEL		BIT0

// TDMCLK_CNTRL
#define TDMCLK_CNTRL_TDM_CLK_EN		BIT31
#define TDMCLK_CNTRL_TDM_GEN_BYPASS	BIT30

// TDMCLK_CNTRL2
#define TDMCLK_CNTRL2_TDM_DIV_BYPASS	BIT24
#define TDMCLK_CNTRL2_TDM_REF_DIV_RST	BIT0

// FSYNC_CNTRL
#define FSYNC_CNTRL_FSYNC_EN		BIT29
#define FSYNC_CNTRL_FSYN_FALL_EDGE	BIT28

// CLK_PWR_DWN
#define CLK_PWR_DWN_USBREFCLK_PD	BIT24
#define CLK_PWR_DWN_IPSEC2AHBCLK_PD	BIT23
#define CLK_PWR_DWN_TDMCLK_PD		BIT22
#define CLK_PWR_DWN_IPSECAHBCLK_PD	BIT21
#define CLK_PWR_DWN_I2CAHBCLK_PD	BIT20
#define CLK_PWR_DWN_USBAHBCLK_PD	BIT19
#define CLK_PWR_DWN_UARTAHBCLK_PD	BIT18
#define CLK_PWR_DWN_MDMAAHBCLK_PD	BIT17
#define CLK_PWR_DWN_TDMAAHBCLK_PD	BIT16
#define CLK_PWR_DWN_PCIE1AHBCLK_PD	BIT15
#define CLK_PWR_DWN_PCIE0AHBCLK_PD	BIT14
#define CLK_PWR_DWN_DDRCTRLAHBCLK_PD	BIT13
#define CLK_PWR_DWN_GEM1AHBCLK_PD	BIT12
#define CLK_PWR_DWN_GEM0AHBCLK_PD	BIT11
#define CLK_PWR_DWN_ARM1AHBCLK_PD	BIT10
#define CLK_PWR_DWN_ARM0AHBCLK_PD	BIT9
#define CLK_PWR_DWN_IPSECCORECLK_PD	BIT8
#define CLK_PWR_DWN_RSVD		BIT7
#define CLK_PWR_DWN_PCIeREFCLK_NP_PD	BIT6
#define CLK_PWR_DWN_DDRCLK_PD		BIT5
#define CLK_PWR_DWN_PHYREFCLK_PD	BIT4
#define CLK_PWR_DWN_GEM1REFCLK_PD	BIT3
#define CLK_PWR_DWN_GEM0REFCLK_PD	BIT2
#define CLK_PWR_DWN_ARM1FCLK_PD		BIT1
#define CLK_PWR_DWN_ARM0FCLK_PD		BIT0

// PLL_STATUS register
#define PLL_STATUS_PHY_PLL_STATUS_CLEAR	BIT5
#define PLL_STATUS_AHB_PLL_STATUS_CLEAR	BIT4
#define PLL_STATUS_ARM_PLL_STATUS_CLEAR	BIT3
#define PLL_STATUS_PHY_PLL_STATUS	BIT2
#define PLL_STATUS_AHB_PLL_STATUS	BIT1
#define PLL_STATUS_ARM_PLL_STATUS	BIT0

// reset block
#define CLKCORE_BLK_RESET		(CLKCORE_BASEADDR + 0x100)
#define CLKCORE_GLBL_SW_RESET		(CLKCORE_BASEADDR + 0x104)
#define CLKCORE_GLBL_SW_RESET_STATUS	(CLKCORE_BASEADDR + 0x108)

// BLK_RESET register
#define BLK_RESET_USB_REF_RESET_N		BIT20
#define BLK_RESET_NO_BAL_DDR_REF_RESET_N	BIT19
#define BLK_RESET_IPSEC2_AHB_RESET_N		BIT18
#define BLK_RESET_RNG_RESET_N			BIT17
#define BLK_RESET_IPSEC_CORE_N			BIT16
#define BLK_RESET_IPSEC_AHB_RESET_N		BIT15
#define BLK_RESET_USB_AHB_RESET_N		BIT14
#define BLK_RESET_TDM_REF_RESET_N		BIT13
#define BLK_RESET_TDM_AHB_RESET_N		BIT12
#define BLK_RESET_DDR_REF_RESET_N		BIT11
#define BLK_RESET_DDR_AHB_RESET_N		BIT10
#define BLK_RESET_PCIe1_REF_RESET_N		BIT9
#define BLK_RESET_PCIe0_REF_RESET_N		BIT8
#define BLK_RESET_PCIe1_AHB_RESET_N		BIT7
#define BLK_RESET_PCIe0_AHB_RESET_N		BIT6
#define BLK_RESET_GEMAC1_REF_RESET_N		BIT5
#define BLK_RESET_GEMAC0_REF_RESET_N		BIT4
#define BLK_RESET_GEMAC1_AHB_RESET_N		BIT3
#define BLK_RESET_GEMAC0_AHB_RESET_N		BIT2
#define BLK_RESET_ARM1_AHB_RESET_N		BIT1
#define BLK_RESET_ARM0_AHB_RESET_N		BIT0

// GLBL_SW_RESET
#define GLBL_SW_RESET_N		BIT0

// GLBL_SW_RESET_STATUS
#define GLBL_SW_RESET_STATUS 	BIT0

////////////////////////////////////////////////////////////////
//	DDR  CONTROLLER block
////////////////////////////////////////////////////////////////

#define DDR_CONFIG_BASEADDR	0x0D000000
#define DENALI_CTL_00_DATA	(DDR_CONFIG_BASEADDR + 0x00)
#define DENALI_CTL_01_DATA	(DDR_CONFIG_BASEADDR + 0x08)
#define DENALI_CTL_02_DATA	(DDR_CONFIG_BASEADDR + 0x10)
#define DENALI_CTL_03_DATA	(DDR_CONFIG_BASEADDR + 0x18)
#define DENALI_CTL_04_DATA	(DDR_CONFIG_BASEADDR + 0x20)
#define DENALI_CTL_05_DATA	(DDR_CONFIG_BASEADDR + 0x28)
#define DENALI_CTL_06_DATA	(DDR_CONFIG_BASEADDR + 0x30)
#define DENALI_CTL_07_DATA	(DDR_CONFIG_BASEADDR + 0x38)
#define DENALI_CTL_08_DATA	(DDR_CONFIG_BASEADDR + 0x40)
#define DENALI_CTL_09_DATA	(DDR_CONFIG_BASEADDR + 0x48)
#define DENALI_CTL_10_DATA	(DDR_CONFIG_BASEADDR + 0x50)
#define DENALI_CTL_11_DATA	(DDR_CONFIG_BASEADDR + 0x58)
#define DENALI_CTL_12_DATA	(DDR_CONFIG_BASEADDR + 0x60)
#define DENALI_CTL_13_DATA	(DDR_CONFIG_BASEADDR + 0x68)
#define DENALI_CTL_14_DATA	(DDR_CONFIG_BASEADDR + 0x70)
#define DENALI_CTL_15_DATA	(DDR_CONFIG_BASEADDR + 0x78)
#define DENALI_CTL_16_DATA	(DDR_CONFIG_BASEADDR + 0x80)
#define DENALI_CTL_17_DATA	(DDR_CONFIG_BASEADDR + 0x88)
#define DENALI_CTL_18_DATA	(DDR_CONFIG_BASEADDR + 0x90)
#define DENALI_CTL_19_DATA	(DDR_CONFIG_BASEADDR + 0x98)
#define DENALI_CTL_20_DATA	(DDR_CONFIG_BASEADDR + 0xA0)
#define DENALI_CTL_21_DATA	(DDR_CONFIG_BASEADDR + 0xA8)
#define DENALI_CTL_22_DATA	(DDR_CONFIG_BASEADDR + 0xB0)
#define DENALI_CTL_23_DATA	(DDR_CONFIG_BASEADDR + 0xB8)
#define DENALI_CTL_24_DATA	(DDR_CONFIG_BASEADDR + 0xC0)
#define DENALI_CTL_25_DATA	(DDR_CONFIG_BASEADDR + 0xC8)
#define DENALI_CTL_26_DATA	(DDR_CONFIG_BASEADDR + 0xD0)
#define DENALI_CTL_27_DATA	(DDR_CONFIG_BASEADDR + 0xD8)
#define DENALI_CTL_28_DATA	(DDR_CONFIG_BASEADDR + 0xE0)
#define DENALI_CTL_29_DATA	(DDR_CONFIG_BASEADDR + 0xE8)
#define DENALI_CTL_30_DATA	(DDR_CONFIG_BASEADDR + 0xF0)
#define DENALI_CTL_31_DATA	(DDR_CONFIG_BASEADDR + 0xF8)
#define DENALI_CTL_32_DATA	(DDR_CONFIG_BASEADDR + 0x100)
#define DENALI_CTL_33_DATA	(DDR_CONFIG_BASEADDR + 0x108)
#define DENALI_CTL_34_DATA	(DDR_CONFIG_BASEADDR + 0x110)
#define DENALI_CTL_35_DATA	(DDR_CONFIG_BASEADDR + 0x118)
#define DENALI_CTL_36_DATA	(DDR_CONFIG_BASEADDR + 0x120)
#define DENALI_CTL_37_DATA	(DDR_CONFIG_BASEADDR + 0x128)
#define DENALI_CTL_38_DATA	(DDR_CONFIG_BASEADDR + 0x130)
#define DENALI_CTL_39_DATA	(DDR_CONFIG_BASEADDR + 0x138)
#define DENALI_CTL_40_DATA	(DDR_CONFIG_BASEADDR + 0x140)
#define DENALI_CTL_41_DATA	(DDR_CONFIG_BASEADDR + 0x148)
#define DENALI_CTL_42_DATA	(DDR_CONFIG_BASEADDR + 0x150)
#define DENALI_CTL_43_DATA	(DDR_CONFIG_BASEADDR + 0x158)
#define DENALI_CTL_44_DATA	(DDR_CONFIG_BASEADDR + 0x160)
#define DENALI_CTL_45_DATA	(DDR_CONFIG_BASEADDR + 0x168)
#define DENALI_CTL_46_DATA	(DDR_CONFIG_BASEADDR + 0x170)
#define DENALI_CTL_47_DATA	(DDR_CONFIG_BASEADDR + 0x178)
#define DENALI_CTL_48_DATA	(DDR_CONFIG_BASEADDR + 0x180)
#define DENALI_CTL_49_DATA	(DDR_CONFIG_BASEADDR + 0x188)
#define DENALI_CTL_50_DATA	(DDR_CONFIG_BASEADDR + 0x190)
#define DENALI_CTL_51_DATA	(DDR_CONFIG_BASEADDR + 0x198)
#define DENALI_CTL_52_DATA	(DDR_CONFIG_BASEADDR + 0x1a0)
#define DENALI_CTL_53_DATA	(DDR_CONFIG_BASEADDR + 0x1a8)
#define DENALI_CTL_54_DATA	(DDR_CONFIG_BASEADDR + 0x1b0)
#define DENALI_CTL_55_DATA	(DDR_CONFIG_BASEADDR + 0x1b8)
#define DENALI_CTL_56_DATA	(DDR_CONFIG_BASEADDR + 0x1c0)
#define DENALI_CTL_57_DATA	(DDR_CONFIG_BASEADDR + 0x1c8)
#define DENALI_CTL_58_DATA	(DDR_CONFIG_BASEADDR + 0x1d0)
#define DENALI_CTL_59_DATA	(DDR_CONFIG_BASEADDR + 0x1d8)
#define DENALI_CTL_60_DATA	(DDR_CONFIG_BASEADDR + 0x1e0)
#define DENALI_CTL_61_DATA	(DDR_CONFIG_BASEADDR + 0x1e8)
#define DENALI_CTL_62_DATA	(DDR_CONFIG_BASEADDR + 0x1f0)
#define DENALI_CTL_63_DATA	(DDR_CONFIG_BASEADDR + 0x1f8)
#define DENALI_CTL_64_DATA	(DDR_CONFIG_BASEADDR + 0x200)
#define DENALI_CTL_65_DATA	(DDR_CONFIG_BASEADDR + 0x208)
#define DENALI_CTL_66_DATA	(DDR_CONFIG_BASEADDR + 0x210)
#define DENALI_CTL_67_DATA	(DDR_CONFIG_BASEADDR + 0x218)
#define DENALI_CTL_68_DATA	(DDR_CONFIG_BASEADDR + 0x220)
#define DENALI_CTL_69_DATA	(DDR_CONFIG_BASEADDR + 0x228)

#define DENALI_WR_DQS_DELAY0		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x11B))
#define DENALI_WR_DQS_DELAY1		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x11C))
#define DENALI_WR_DQS_DELAY2		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x11D))
#define DENALI_WR_DQS_DELAY3		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x11E))

#define DENALI_SW_LEVELING_START	*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x278))
#define DENALI_SW_LEVELING_MODE		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x279))
#define DENALI_SW_LEVELING_LOAD		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x276))
#define DENALI_DLL_MADJ0		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x148))
#define DENALI_DLL_ADJ1_DS0_L		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x14A))
#define DENALI_DLL_ADJ1_DS1_H		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x14E))
#define DENALI_DLL_ADJ1_DS2_L		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x152))
#define DENALI_DLL_ADJ1_DS3_H		*((volatile u8 *)(DDR_CONFIG_BASEADDR + 0x156))

#endif

/* end of file comcerto_1000.h */
