#include <common.h>

#if defined(CONFIG_MII) && (CONFIG_COMMANDS & CFG_CMD_MII)
extern u16 MDIO_Handle_Read(u16 preamble_sup, u16 phy_addr, u16 reg_addr);
extern u16 MDIO_Handle_Write(u16 preamble_sup, u16 phy_addr, u16 reg_addr, u16 md_data);

int  comcerto_miiphy_read(char *devname, unsigned char addr,
		unsigned char reg, unsigned short * value)
{
	*value = MDIO_Handle_Read(0, 0, reg);
	return 0;
}

int  comcerto_miiphy_write(char *devname, unsigned char addr,
		unsigned char reg, unsigned short value)
{
	MDIO_Handle_Write(0, 0, reg, value);
	return 0;
}

#endif	/* defined(CONFIG_MII) || (CONFIG_COMMANDS & CFG_CMD_MII) */

int comcerto_miiphy_initialize(bd_t *bis)
{
#if defined(CONFIG_MII) && (CONFIG_COMMANDS & CFG_CMD_MII)
	miiphy_register("Comcerto phy", comcerto_miiphy_read, comcerto_miiphy_write);
#endif
	return 0;
}
