/*
 * (C) Copyright 2005 2N TELEKOMUNIKACE, Ladislav Michl
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <config.h>
#include <asm/mach-types.h>
DECLARE_GLOBAL_DATA_PTR;

extern void SoC_PLL_init(void);
extern void SoC_mem_init(void);
//extern void SoC_mem_init(int controller, int base, int length);
extern void SoC_flash_init(void);
extern void SoC_nand_init(void);

void bsp_init(void)
{
	SoC_Check_Device();

	SoC_PLL_init();
	//SoC_mem_init(0, PHYS_SDRAM, /*PHYS_SDRAM_SIZE/0x100000*/128);
	SoC_mem_init();
	SoC_flash_init();
	SoC_nand_init();
	
	icache_enable();
}
int board_init(void)
{
	/* arch number of Mindspeed Comcerto */
	gd->bd->bi_arch_number = MACH_TYPE_M825XX;

	/* adress of boot parameters */
	gd->bd->bi_boot_params = LINUX_BOOTPARAM_ADDR;

	return 0;
}

int dram_init(void)
{
	gd->bd->bi_dram[0].start = PHYS_SDRAM;
	gd->bd->bi_dram[0].size = PHYS_SDRAM_SIZE;

	return 0;
}

extern void partition_flash(void);

int misc_init_r(void)
{
	return 0;
}

#ifdef BOARD_LATE_INIT
int board_late_init(void)
{
  printf("Reserve MSP memory\n");
  gd->bd->bi_dram[0].start += (u32)MSP_MEMORY_RESERVED_SIZE;
  gd->bd->bi_dram[0].size -= (u32)MSP_MEMORY_RESERVED_SIZE;
  return 0;
}
#endif
