/*
 * (C) Copyright Mindspeed Technologies Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#include <common.h>
#include <config.h>
#include <asm/arch/hardware.h>
#include <asm/arch/bits.h>

#define WAN_PHY_BIT	0
#define LAN_PHY_BIT	1
static u8 wanlan_reset=0;

/*
	On the router board, the lan and the wan phy are taken out of reset by the same GPIO pin (17)
*/

void reset_emac0_phy(u32 enable)
{
	if(enable)
	{	//want to take the phy out of reset
		wanlan_reset|=LAN_PHY_BIT;
		*(volatile u32*) (GPIO_OE_REG) |= BIT17;
		*(volatile u32*)(GPIO_OUTPUT_REG) |= BIT17;

	}
	else
	{
		//want to put the phy in reset
		wanlan_reset&=~LAN_PHY_BIT;
		if(wanlan_reset==0)
		{
			*(volatile u32*) (GPIO_OE_REG) |= BIT17;
			*(volatile u32*)(GPIO_OUTPUT_REG) &= ~BIT17;
		}
	}

}

void reset_emac1_phy(u32 enable)
{
	if(enable)
	{	//want to take the phy out of reset
		wanlan_reset|=WAN_PHY_BIT;
		*(volatile u32*) (GPIO_OE_REG) |= BIT17;
		*(volatile u32*)(GPIO_OUTPUT_REG) |= BIT17;

	}
	else
	{
		//want to put the phy in reset
		wanlan_reset&=~WAN_PHY_BIT;
		if(wanlan_reset==0)
		{
			*(volatile u32*) (GPIO_OE_REG) |= BIT17;
			*(volatile u32*)(GPIO_OUTPUT_REG) &= ~BIT17;
		}
	}
}

