/** Copyright (c) 2015 Cvisionhk */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <errno.h>

#include <event.h>
#include <frame.h>
#include <stream.h>
#include <outputs.h>
#include <rtp.h>
#include <rtp_media.h>
#include <conf_parse.h>

static struct session *sess_list = NULL;

struct rtp_media *session_new_rtp_media(
    rtpm_func_get_sdp get_sdp,
    rtpm_func_get_payload get_payload,
    rtpm_func_frame frame,
    rtpm_func_send send, void *private )
    {
    struct rtp_media *psRtpMedia;

    if( ! ( psRtpMedia = (struct rtp_media *)malloc( sizeof( *psRtpMedia ) ) ) )
        return NULL;

    psRtpMedia->get_sdp = get_sdp;
    psRtpMedia->get_payload = get_payload;
    psRtpMedia->frame = frame;
    psRtpMedia->send = send;
    psRtpMedia->private = private;
    return psRtpMedia;
    }

void session_del_session( struct session *psSess )
    {
    if(psSess)
        {
        if( psSess->next ) psSess->next->prev = psSess->prev;
        if( psSess->prev ) psSess->prev->next = psSess->next;
        else sess_list = psSess->next;
        if( psSess->control_close ) psSess->control_close( psSess );
        free( psSess );
        }
    }

struct session *session_new_session(int isLocal)
    {
    struct session *psSess;
    int i;

    psSess = (struct session *)malloc( sizeof( struct session ) );
    psSess->next = sess_list;
    psSess->prev = NULL;
    if( psSess->next ) psSess->next->prev = psSess;
    sess_list = psSess;
    psSess->get_sdp = NULL;
    psSess->setup = NULL;
    psSess->play = NULL;
    psSess->pause = NULL;
    psSess->private = NULL;
    psSess->control_private = NULL;
    psSess->control_close = NULL;
    psSess->isLocal = isLocal;
    gettimeofday( &psSess->open_time, NULL );
    strcpy( psSess->addr, "(unconnected)" );
    for( i = 0; i < RTP_MAX_TRACKS; ++i ) psSess->ep[i] = NULL;
    return psSess;
    }

int session_print_session_list( char *pcBuf, int maxlen )
    {
    struct session *psSess;
    int i = 0;

    for( psSess = sess_list; psSess; psSess = psSess->next )
        i += sprintf( pcBuf + i, "%s %ld\n",
                      psSess->addr, psSess->open_time.tv_sec );
    return i;
    }
