/** Copyright (c) 2015 Cvisionhk */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <getopt.h>
#include <pthread.h>
#include <syscall.h>
#include <signal.h>
#include "service_rtsp.h"
#include "cv_rtsp.h"
#include "mylogger.h"

#define MAX_FRAME_SIZE      (256 * 1024) // 256KB
volatile uint32_t s_uiQuit = 0;         // Flag to quit

static S_RTSP_CONFIG s_sConfig =
    {
    .m_uiFrameSize = 200000,
    .m_uiFrameCnt = 15,
    .m_szH264CamPath[0] = 0,
    .m_uiAuthen = 0,
    .m_szUser[0] = 0,
    .m_szPass[0] = 0,
    .m_uiIsInitialized = 0,
    };

int rtsp_is_config()
    {
    return s_sConfig.m_uiIsInitialized;
    }

void*
rtsp_loop(void* args)
    {
    mylog_info("RTSP_LOOP START");
    mylog_info("LWP id is %d\n", syscall(SYS_gettid));
    rtsp_origin_run();
    pthread_detach(pthread_self()); // Free memory before exit
    return NULL;
    }

int
rtsp_stream_init(int frameSize, int frameCount, char* fullStream, char* audioStream, char* user, char* pass, int port)
    {
    if(fullStream == NULL || audioStream == NULL)
        return -1;

    if(s_sConfig.m_uiIsInitialized == 1)
    {
        mylog_info("initialized config"); // VinhPQ: Fix memory leak
        return 0;
    }

    s_sConfig.m_uiFrameSize = frameSize;
    s_sConfig.m_uiFrameCnt = frameCount;
    s_sConfig.m_uiAuthen = 0;

    memset(s_sConfig.m_szH264CamPath, 0, sizeof(s_sConfig.m_szH264CamPath));
    memset(s_sConfig.m_szUser, 0, sizeof(s_sConfig.m_szUser));
    memset(s_sConfig.m_szPass, 0, sizeof(s_sConfig.m_szPass));

    snprintf(s_sConfig.m_szH264CamPath, sizeof(s_sConfig.m_szH264CamPath) - 1, "/%s", fullStream);
    snprintf(s_sConfig.m_szAudioOnlyPath, sizeof(s_sConfig.m_szAudioOnlyPath) - 1, "/%s", audioStream);
    if(user)
        {
        s_sConfig.m_uiAuthen++;
        strncpy(s_sConfig.m_szUser, user, sizeof(s_sConfig.m_szUser) - 1);
        }

    if(pass)
        {
        strncpy(s_sConfig.m_szPass, pass, sizeof(s_sConfig.m_szPass) - 1);
        s_sConfig.m_uiAuthen++;
        }
    s_sConfig.m_uiAuthen = s_sConfig.m_uiAuthen >> 1;

    if(port > 0 && port < 0xFFFF)
        s_sConfig.m_uiPort = port;

    if(rtsp_origin_init() < 0)
        {
        mylog_info("ERROR: rtsp server init failed\n");
        return -1;
        }

    if(rtsp_origin_config((S_RTSP_CONFIG *)&s_sConfig) < 0)
        {
        mylog_error("ERROR: rtsp server config failed\n");
        return -2;
        }
    s_sConfig.m_uiIsInitialized = 1;
    return 0;
    }

int rtsp_stream_run(int stackSize)
    {
    int iRetCode = -1;
    pthread_t taskID;
    size_t          stkSize = 32*1024;
    pthread_attr_t  tattr;

    if(stackSize)
        stkSize = stackSize;

    if(pthread_attr_init(&tattr) != 0)
        return -1;
    if(pthread_attr_setstacksize(&tattr, stkSize) != 0)
        return -2;

    iRetCode = pthread_create(&taskID, &tattr, rtsp_loop, NULL);
    if(iRetCode != 0)
        return -iRetCode;
    iRetCode = *(int *)(&taskID);
    iRetCode = iRetCode & 0x7FFFFFFF;
    pthread_attr_destroy(&tattr);
    return iRetCode;
    }

int rtsp_stream_stop(void)
    {
    rtsp_origin_stop();
    return 0;
    }

