/** Copyright (c) 2015 Cvisionhk */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <errno.h>

#include <event.h>
#include <frame.h>
#include <stream.h>
#include <outputs.h>
#include <rtp.h>
#include <rtp_media.h>
#include <conf_parse.h>

struct rtp_rawaudio
    {
    unsigned char *rawaudio_data;
    int rawaudio_len;
    int format;
    int sampsize;
    int channels;
    int rate;
    int ts_incr;
    unsigned int timestamp;
    };

static int rawaudio_get_sdp( char *pcDest, int i32Len, int i32Payload,
                             int i32Port, void *d )
    {
    struct rtp_rawaudio *psRawOut = (struct rtp_rawaudio *)d;

    switch( psRawOut->format )
        {
        case RTSP_FORMAT_PCM:
            if( psRawOut->rate == 44100 && psRawOut->channels == 2 )
                return snprintf( pcDest, i32Len,
                                 "m=audio %d RTP/AVP 10\r\n", i32Port );
            else if( psRawOut->rate == 44100 && psRawOut->channels == 1 )
                return snprintf( pcDest, i32Len,
                                 "m=audio %d RTP/AVP 11\r\n", i32Port );
            else
                return snprintf( pcDest, i32Len, "m=audio %d RTP/AVP %d\r\na=rtpmap:%d L16/%d/%d\r\n", i32Port, i32Payload, i32Payload, psRawOut->rate, psRawOut->channels );
            break;

        case RTSP_FORMAT_G722:
            if( psRawOut->rate == 8000 && psRawOut->channels == 1 )
                return snprintf( pcDest, i32Len,
                                 "m=audio %d RTP/AVP 8\r\n", i32Port );
            else
                return snprintf( pcDest, i32Len, "m=audio %d RTP/AVP %d\r\na=rtpmap:%d PCMA/%d/%d\r\n", i32Port, i32Payload, i32Payload, psRawOut->rate, psRawOut->channels );
            break;

        case RTSP_FORMAT_ALAW:
            if( psRawOut->rate == 8000 && psRawOut->channels == 1 )
                return snprintf( pcDest, i32Len,
                                 "m=audio %d RTP/AVP 8\r\n", i32Port );
            else
                return snprintf( pcDest, i32Len, "m=audio %d RTP/AVP %d\r\na=rtpmap:%d PCMA/%d/%d\r\n", i32Port, i32Payload, i32Payload, psRawOut->rate, psRawOut->channels );
            break;

        case RTSP_FORMAT_ULAW:
            if( psRawOut->rate == 8000 && psRawOut->channels == 1 )
                return snprintf( pcDest, i32Len,
                                 "m=audio %d RTP/AVP 0\r\n", i32Port );
            else
                return snprintf( pcDest, i32Len, "m=audio %d RTP/AVP %d\r\na=rtpmap:%d PCMU/%d/%d\r\n", i32Port, i32Payload, i32Payload, psRawOut->rate, psRawOut->channels );
            break;
        }
    return -1;
    }

static int rawaudio_get_payload( int i32Payload, void *d )
    {
    struct rtp_rawaudio *psRawOut = (struct rtp_rawaudio *)d;

    switch( psRawOut->format )
        {
        case RTSP_FORMAT_PCM:
            if( psRawOut->rate == 44100 && psRawOut->channels == 2 )
                return 10;
            else if( psRawOut->rate == 44100 && psRawOut->channels == 1 )
                return 11;
            else return i32Payload;
            break;
        case RTSP_FORMAT_ALAW:
            if( psRawOut->rate == 8000 && psRawOut->channels == 1 )
                return 8;
            else return i32Payload;
            break;
        case RTSP_FORMAT_G722:
            if( psRawOut->rate == 8000 && psRawOut->channels == 1 )
                return 8;
            else return i32Payload;
            break;
        case RTSP_FORMAT_ULAW:
            if( psRawOut->rate == 8000 && psRawOut->channels == 1 )
                return 0;
            else return i32Payload;
            break;
        }
    return -1;
    }

static int rawaudio_process_frame( struct frame *psFrame, void *d )
    {
    struct rtp_rawaudio *psRawOut = (struct rtp_rawaudio *)d;
    if(psFrame->pts == 0)
        psRawOut->timestamp += psRawOut->rawaudio_len / psRawOut->channels / psRawOut->sampsize;
    else
        {
        if(psRawOut->timestamp == psFrame->pts)
            psRawOut->timestamp += 1;
        else
            psRawOut->timestamp = psFrame->pts;
        }
    psRawOut->rawaudio_data = psFrame->d;
    psRawOut->rawaudio_len = psFrame->length;
    return 1; /* always ready! */
    }

static int rawaudio_send( struct rtp_endpoint *psEndpoint, void *d )
    {
    struct rtp_rawaudio *psRawOut = (struct rtp_rawaudio *)d;
    int i = 0, plen = 0;
    struct iovec sIOVec[2];

    for( i = 0; i < psRawOut->rawaudio_len; i += plen )
        {
        plen = psRawOut->rawaudio_len - i;
        if( plen > psEndpoint->max_data_size )
            {
            plen = psEndpoint->max_data_size;
            plen -= plen % ( psRawOut->channels * psRawOut->sampsize );
            }
        sIOVec[1].iov_base = psRawOut->rawaudio_data + i;
        sIOVec[1].iov_len = plen;

        if( rtp_send_rtp_packet( psEndpoint, sIOVec, 2,
                                 psRawOut->timestamp + i / psRawOut->channels / psRawOut->sampsize,
                                 0 ) < 0 )
            return -1;
        }
    return 0;
    }

struct rtp_media *new_rtp_media_rawaudio_stream( struct stream *psStream )
    {
    struct rtp_rawaudio *psRawOut;

    psRawOut = (struct rtp_rawaudio *)malloc( sizeof( struct rtp_rawaudio ) );
    psRawOut->rawaudio_len = 0;
    psStream->get_framerate( psStream, &psRawOut->channels, &psRawOut->rate );
    psRawOut->rate /= psRawOut->channels;
    psRawOut->format = psStream->format;
    psRawOut->sampsize = (psRawOut->format == RTSP_FORMAT_PCM) ? 2 : 1;
    psRawOut->ts_incr = 0;
    psRawOut->timestamp = 0;

    return session_new_rtp_media( rawaudio_get_sdp, rawaudio_get_payload,
                                  rawaudio_process_frame, rawaudio_send, psRawOut );
    }
