/** Copyright (c) 2015 Cvisionhk */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>
#include <errno.h>
#include <pthread.h>

#include <event.h>
#include <frame.h>
#include "mylogger.h"

static struct frame_slot *g_psFrameHeapTake = NULL, *g_psFrameHeapPut = NULL;
static pthread_mutex_t g_psFrameHeapMutex;
static int g_i32MaxFrameSize = 0;

void frame_init_frame_heap( int i32Size, int i32Count, char cNull)
    {
    struct frame_slot *psFrame = NULL, *psFramePrev = NULL;

    g_i32MaxFrameSize = i32Size;
    pthread_mutex_init( &g_psFrameHeapMutex, NULL );
    while( i32Count-- > 0 )
        {
        psFrame = (struct frame_slot *)
                  malloc( sizeof( struct frame_slot ) );
        psFrame->f = (struct frame *)malloc( sizeof( struct frame ) + i32Size );
        psFrame->f->size = i32Size;
        pthread_mutex_init( &psFrame->f->mutex, NULL );
        psFrame->prev = psFramePrev;
        if( psFramePrev ) psFramePrev->next = psFrame;
        else g_psFrameHeapTake = psFrame;
        psFramePrev = psFrame;
        }
    g_psFrameHeapTake->prev = psFrame;
    psFrame->next = g_psFrameHeapTake;
    g_psFrameHeapPut = g_psFrameHeapTake;
    }

int frame_get_max_frame_size(char cCvision)
    {
    return g_i32MaxFrameSize;
    }

struct frame *frame_new(char cCvision)
    {
    struct frame *psFrame;

    pthread_mutex_lock( &g_psFrameHeapMutex );

    if( g_psFrameHeapTake->f )
        {
        psFrame = g_psFrameHeapTake->f;
        g_psFrameHeapTake->f = NULL;
        g_psFrameHeapTake = g_psFrameHeapTake->next;
        psFrame->ref_count = 1;
        psFrame->destructor = NULL;
        psFrame->destructor_data = NULL;
        psFrame->d = (unsigned char *)psFrame + sizeof( struct frame );
        psFrame->format = RTSP_FORMAT_EMPTY;
        psFrame->width = 0;
        psFrame->height = 0;
        psFrame->length = 0;
        psFrame->key = 0;
        psFrame->pts = 0;
        }
    else
        {
        mylog_error("Ack!  Out of frame buffers!" );
        psFrame = NULL;
        }

    pthread_mutex_unlock( &g_psFrameHeapMutex );

    return psFrame;
    }

void frame_ref_frame( struct frame *psFrame, void *pv )
    {
    pthread_mutex_lock( &psFrame->mutex );
    ++psFrame->ref_count;
    pthread_mutex_unlock( &psFrame->mutex );
    }

void frame_unref_frame( struct frame *psFrame, void *pv)
    {
    int i32RefCnt;

    pthread_mutex_lock( &psFrame->mutex );
    i32RefCnt = --psFrame->ref_count;
    pthread_mutex_unlock( &psFrame->mutex );
    if( i32RefCnt > 0 ) return;

    if( psFrame->destructor )
        {
        psFrame->ref_count = 1;
        if( psFrame->destructor( psFrame, psFrame->destructor_data ) ) return;
        }

    pthread_mutex_lock( &g_psFrameHeapMutex );
    if( g_psFrameHeapPut->f )
        {
        mylog_info("Ack!  There is a frame at g_psFrameHeapPut!" );
        return;
        }
    g_psFrameHeapPut->f = psFrame;
    g_psFrameHeapPut = g_psFrameHeapPut->next;
    pthread_mutex_unlock( &g_psFrameHeapMutex );
    }

static void frame_exchanger_read( struct event_info *psEvInfo, void *d)
    {
    struct frame_exchanger *psFrameEx = (struct frame_exchanger *)d;
    unsigned char c;
    int i32Ret;
    struct frame *mFrame;
    for(;;)
        {
        i32Ret = read( psFrameEx->master_fd, &c, 1 );
        if( i32Ret <= 0 )
            {
            if( i32Ret < 0 && errno == EAGAIN )
                {
                return;
                }
            mylog_error("We lost an exchanger fd!" );
            exit( 1 );
            }
        pthread_mutex_lock( &psFrameEx->mutex );
        mFrame = psFrameEx->master_read->f;
        if(mFrame == NULL)
            {
            mylog_error("We lost a frame!" );
            psFrameEx->master_read->f = NULL;
            psFrameEx->master_read = psFrameEx->slave_cur;
            pthread_mutex_unlock( &psFrameEx->mutex );
            }
        else
            {
            psFrameEx->master_read->f = NULL;
            psFrameEx->master_read = psFrameEx->master_read->next;
            pthread_mutex_unlock( &psFrameEx->mutex );
            psFrameEx->f( mFrame, psFrameEx->d );
            }
        }
    }

struct frame_exchanger *frame_new_exchanger( int i32Slot,
        frame_deliver_func frameDeliverFunc, void *d, void *pv )
    {
    struct frame_slot *psFrameSlot  = NULL, *psFrameSlotPrev = NULL;
    struct frame_exchanger *psFrameEx;
    int i32Fds[2];

    psFrameEx = (struct frame_exchanger *)
                malloc( sizeof( struct frame_exchanger ) );


    while( i32Slot-- > 0 )
        {
        psFrameSlot = (struct frame_slot *)
                      malloc( sizeof( struct frame_slot ) );

        psFrameSlot->f = NULL;
        psFrameSlot->pending = 0;
        psFrameSlot->prev = psFrameSlotPrev;
        if( psFrameSlotPrev ) psFrameSlotPrev->next = psFrameSlot;
        else psFrameEx->slave_cur = psFrameSlot;
        psFrameSlotPrev = psFrameSlot;
        }
    psFrameEx->slave_cur->prev = psFrameSlot;
    psFrameSlot->next = psFrameEx->slave_cur;
    psFrameEx->master_read = psFrameEx->master_write = psFrameEx->slave_cur;

    pipe( i32Fds );
    psFrameEx->master_fd = i32Fds[0];
    psFrameEx->slave_fd = i32Fds[1];

    fcntl( psFrameEx->master_fd, F_SETFL, O_NONBLOCK );

    psFrameEx->master_event = event_add_fd( psFrameEx->master_fd, 0, 0,
                                            frame_exchanger_read, psFrameEx, NULL);

    pthread_mutex_init( &psFrameEx->mutex, NULL );
    pthread_cond_init( &psFrameEx->slave_wait, NULL );

    psFrameEx->f = frameDeliverFunc;
    psFrameEx->d = d;

    return psFrameEx;
    }

void frame_deliver_frame( struct frame_exchanger *psFrameEx, struct frame *psFrame, void *pv)
    {
    unsigned char ucVal = 0;
    int           sentSize = 0;

    pthread_mutex_lock( &psFrameEx->mutex );
    if(psFrameEx->slave_cur->next == psFrameEx->master_read)
        {
        pthread_mutex_unlock( &psFrameEx->mutex );
        frame_unref_frame(psFrame, NULL);
        return;
        }

    psFrameEx->slave_cur->f = psFrame;
    psFrameEx->slave_cur->pending = 0;
    sentSize = write( psFrameEx->slave_fd, &ucVal, 1 );
    if(sentSize <= 0)
        exit(0);
    psFrameEx->slave_cur = psFrameEx->slave_cur->next;
    pthread_mutex_unlock( &psFrameEx->mutex );
    }
