/** Copyright (c) 2015 Cvisionhk */

#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <unistd.h>
#include <inttypes.h>

#include "event.h"

static struct event *psEventTimeList = NULL;
static struct event *psEventFdList = NULL;
static struct event *psEventAlwaysList = NULL;
static volatile int i32EndLoopFlg = 0;

int event_time_diff( event_time_ref *psEventTimeStart, event_time_ref *psEventTimeEnd, void *pv)
    {
    return ( ( psEventTimeEnd->tv_sec - psEventTimeStart->tv_sec ) * 1000000
             + psEventTimeEnd->tv_usec - psEventTimeStart->tv_usec + 500 ) / 1000;
    }

int event_time_ago( event_time_ref *psEventTime, void *pv)
    {
    struct timeval timeNow;
    gettimeofday( &timeNow, NULL );
    return event_time_diff( psEventTime, &timeNow, NULL);
    }

void event_time_now( event_time_ref *psEventTime, void *pv)
    {
    gettimeofday( (struct timeval *)psEventTime, NULL );
    }

void event_time_add( event_time_ref *psEventTime, int i32Milisecond, void *pv)
    {
    psEventTime->tv_sec += i32Milisecond / 1000;
    psEventTime->tv_usec += ( i32Milisecond % 1000 ) * 1000;
    if( psEventTime->tv_usec >= 1000000 )
        {
        psEventTime->tv_usec -= 1000000;
        ++psEventTime->tv_sec;
        }
    }

void event_time_future( event_time_ref *psEventTime, int i32Milisecond, void *pv)
    {
    gettimeofday( psEventTime, NULL );
    event_time_add( psEventTime, i32Milisecond, NULL);
    }

static struct event *new_event( callback funcCB, void *arg, void *pv)
    {
    struct event *psEvent;

    psEvent = (struct event *)malloc( sizeof( struct event ) );
    psEvent->next = NULL;
    psEvent->prev = NULL;
    psEvent->type = 0;
    psEvent->flags = 0;
    psEvent->func = funcCB;
    psEvent->data = arg;
    return psEvent;
    }

static void strip_events( struct event **ppsEvList, void
                          *pv)
    {
    struct event *psEv, *psNext;

    for( psEv = *ppsEvList; psEv; psEv = psNext )
        {
        psNext = psEv->next;
        if( psEv->flags & RTSP_EVENT_F_REMOVE )
            {
            if( psEv->next ) psEv->next->prev = psEv->prev;
            if( psEv->prev ) psEv->prev->next = psEv->next;
            else *ppsEvList = psEv->next;

            // FIX rtspserver MEM LEAK
            if (psEv)
                {
                free(psEv);
                psEv = NULL;
                }
            }
        }
    }

struct event *event_add_timer( int msec, unsigned int flags, callback funcCB, void *arg, void *pv)
    {
    struct event *psEv;
    psEv = new_event( funcCB, arg, NULL);
    psEv->type = RTSP_EVENT_TIME;
    psEv->flags = flags;
    psEv->ev.time.ival = msec;
    psEv->next = psEventTimeList;
    if( psEv->next ) psEv->next->prev = psEv;
    psEventTimeList = psEv;
    event_time_now( &psEv->ev.time.fire, NULL);
    event_resched( psEv, NULL, NULL);
    return psEv;
    }

void event_resched( struct event *psEv, event_time_ref *psEvTimeRef, void *pv)
    {
    if( psEvTimeRef )
        {
        psEv->ev.time.fire = *psEvTimeRef;
        }
    else if( psEv->flags & RTSP_EVENT_F_ENABLED )
        {
        event_time_add( &psEv->ev.time.fire, psEv->ev.time.ival, NULL);
        }
    else
        {
        event_time_future( &psEv->ev.time.fire, psEv->ev.time.ival, NULL);
        }

    psEv->flags &= ~RTSP_EVENT_F_REMOVE;
    psEv->flags |= RTSP_EVENT_F_ENABLED;
    }

struct event *event_add_fd( int i32Fd, int i32Write, unsigned int flags,
                            callback funcCB, void *arg, void *pv)
    {
    struct event *psEv;
    psEv = new_event( funcCB, arg, NULL);
    psEv->type = RTSP_EVENT_FD;
    psEv->flags = flags | RTSP_EVENT_F_ENABLED;
    psEv->ev.fd.fd = i32Fd;
    psEv->ev.fd.write = i32Write;
    psEv->next = psEventFdList;
    if( psEv->next ) psEv->next->prev = psEv;
    psEventFdList = psEv;
    return psEv;
    }

void event_remove( struct event *psEvent, void *pv)
    {
    psEvent->flags |= RTSP_EVENT_F_REMOVE;
    psEvent->flags &= ~( RTSP_EVENT_F_RUNNING | RTSP_EVENT_F_ENABLED );
    }

void event_set_event_enabled( struct event *psEvent, int enabled, void *pv)
    {
    psEvent->flags &= ~RTSP_EVENT_F_ENABLED;
    if( enabled ) psEvent->flags |= RTSP_EVENT_F_ENABLED;
    }

void event_exit_event_loop(void)
    {
    i32EndLoopFlg = 1;
    }

void event_loop(int i32Single, void *pv)
    {
    struct timeval sTimeVal, test, *psTime;
    struct event *psEvent;
    struct event_info sEvInfo;
    int i32Diff, i32NextTime = 0, i32HighFd, ret;
    fd_set rfds, wfds;

    rtsp_set_closing(0);
    i32EndLoopFlg = 0;
    do
        {
        psTime = NULL;
        /* check how long the timeout should be */
        for(psEvent = psEventTimeList; psEvent; psEvent = psEvent->next)
            if(psEvent->flags & RTSP_EVENT_F_ENABLED)
                {
                i32Diff = -event_time_ago(&psEvent->ev.time.fire, NULL);
                if(i32Diff < 5)
                    i32Diff = 0;
                if(!psTime || i32Diff < i32NextTime)
                    i32NextTime = i32Diff;
                psTime = &sTimeVal;
                psEvent->flags |= RTSP_EVENT_F_RUNNING;
                }
            else
                psEvent->flags &= ~RTSP_EVENT_F_RUNNING;
        for(psEvent = psEventAlwaysList; psEvent; psEvent = psEvent->next)
            if(psEvent->flags & RTSP_EVENT_F_ENABLED)
                {
                psTime = &sTimeVal;
                i32NextTime = 0;
                psEvent->flags |= RTSP_EVENT_F_RUNNING;
                }
            else
                psEvent->flags &= ~RTSP_EVENT_F_RUNNING;

        if(psTime)
            {
            psTime->tv_sec = i32NextTime / 1000;
            psTime->tv_usec = (i32NextTime % 1000) * 1000;
            }
        else
            {
            psTime = &test;
            psTime->tv_sec = 1;
            psTime->tv_usec = 100000;
            }
        FD_ZERO(&rfds);
        FD_ZERO(&wfds);
        i32HighFd = -1;
        /* This is all so ugly...  It should use poll() eventually. */
        for(psEvent = psEventFdList; psEvent; psEvent = psEvent->next)
            {
            if(psEvent->flags & RTSP_EVENT_F_ENABLED)
                {
                FD_SET(psEvent->ev.fd.fd, psEvent->ev.fd.write ? &wfds : &rfds);
                if(psEvent->ev.fd.fd > i32HighFd)
                    i32HighFd = psEvent->ev.fd.fd;
                psEvent->flags |= RTSP_EVENT_F_RUNNING;
                }
            else
                psEvent->flags &= ~RTSP_EVENT_F_RUNNING;
            }
        ret = select(i32HighFd + 1, &rfds, &wfds, NULL, psTime);
        if(psTime->tv_sec == 1 && psTime->tv_usec == 100000)
            psTime = NULL;

        for(psEvent = psEventTimeList; psEvent; psEvent = psEvent->next)
            {
            if((i32EndLoopFlg) && (rtsp_nb_ext_clients() <= 0))
                break;
            if(!(psEvent->flags & RTSP_EVENT_F_RUNNING))
                continue;
            i32Diff = -event_time_ago(&psEvent->ev.time.fire, NULL);
            if(i32Diff < 5)
                {
                if(!(psEvent->flags & RTSP_EVENT_F_ONESHOT))
                    event_resched(psEvent, NULL, NULL);
                else
                    psEvent->flags |= RTSP_EVENT_F_REMOVE;
                sEvInfo.e = psEvent;
                sEvInfo.type = RTSP_EVENT_TIME;
                sEvInfo.data = NULL;
                (*psEvent->func)(&sEvInfo, psEvent->data);
                }
            }
        for(psEvent = psEventAlwaysList; psEvent; psEvent = psEvent->next)
            {
            if((i32EndLoopFlg) && (rtsp_nb_ext_clients() <= 0))
                break;
            if(!(psEvent->flags & RTSP_EVENT_F_RUNNING))
                continue;
            if(psEvent->flags & RTSP_EVENT_F_ONESHOT)
                psEvent->flags |= RTSP_EVENT_F_REMOVE;
            sEvInfo.e = psEvent;
            sEvInfo.type = RTSP_EVENT_ALWAYS;
            sEvInfo.data = NULL;
            (*psEvent->func)(&sEvInfo, psEvent->data);
            }
        if(ret  > 0)
            {
            for(psEvent = psEventFdList; psEvent; psEvent = psEvent->next)
                {
                if((i32EndLoopFlg) && (rtsp_nb_ext_clients() <= 0))
                    break;
                if(!(psEvent->flags & RTSP_EVENT_F_RUNNING))
                    continue;
                if(FD_ISSET(psEvent->ev.fd.fd, psEvent->ev.fd.write ? &wfds : &rfds))
                    {
                    if(psEvent->flags & RTSP_EVENT_F_ONESHOT)
                    {
                        psEvent->flags |= RTSP_EVENT_F_REMOVE;
                    }
                    sEvInfo.e = psEvent;
                    sEvInfo.type = RTSP_EVENT_FD;
                    sEvInfo.data = NULL;
                    (*psEvent->func)(&sEvInfo, psEvent->data);
                    }
                }
            }
        strip_events(&psEventTimeList, NULL);
        strip_events(&psEventFdList, NULL);
        strip_events(&psEventAlwaysList, NULL);
        }while((!i32EndLoopFlg) || (rtsp_nb_ext_clients() > 0));
    }
