/** Copyright (c) 2015 Cvisionhk */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include <event.h>
#include <frame.h>
#include <stream.h>
#include <conf_parse.h>
#include <global_config.h> /* Don't include this in other files */
#include "mylogger.h"

struct event_config
    {
    struct event_config *next;
    char type[256];
    char name[256];
    void *(*start_block)( void );
    int (*end_block)( void *d );
    struct statement *statements;

    };

/* Create a global config context pointing to the global_statements array
 * defined in global_config.h */
static struct event_config global_event =
    {
    NULL, {}, {}, NULL, NULL, global_statements
    };

void register_config_context( char *pCType, char *pCName,
                              void *(*start_block)( void ),
                              int (*end_block)( void *d ),
                              struct statement *pStatement )
    {
    struct event_config *psEventCfg;

    for( psEventCfg = &global_event; psEventCfg->next; psEventCfg = psEventCfg->next );
    psEventCfg->next = (struct event_config *)
                       malloc( sizeof( struct event_config ) );
    psEventCfg = psEventCfg->next;
    psEventCfg->next = NULL;

    strcpy( psEventCfg->type, pCType );
    strcpy( psEventCfg->name, pCName );

    psEventCfg->start_block = start_block;
    psEventCfg->end_block = end_block;
    psEventCfg->statements = pStatement;
    }

static int process_event( struct event_config *psEventCfg, void *pEventData,
                          struct token *psToken, int num_tokens, int line )
    {
    struct statement *pStatement;
    char *pCDirective = psToken[0].v.str;
    int num_args = num_tokens - 1;
    int i = 0;
    int i32Flag = 0;
    struct token *args = psToken + 1;

    if( psToken[0].type != TOKEN_STR )
        {
        mylog_error("line %d: malformed configuration directive (unexpected numeral?)", __LINE__);
        return -1;
        }

    for( pStatement = psEventCfg->statements; pStatement->directive; ++pStatement )
        {
        if( ! strcasecmp( pStatement->directive, pCDirective ) )
            {
            i32Flag = 1;
            if( num_args < pStatement->min_args || num_args > pStatement->max_args )
                {
                continue;
                }
            for( i = 0; i < num_args; ++i )
                {
                if( pStatement->types[i] != args[i].type )
                    {
                    break;
                    }
                }
            if( i < num_args )
                {
                continue;
                }
            pStatement->process( num_tokens, psToken, pEventData );

            return 0;
            }
        }

    if( i32Flag )
        {
        mylog_info("line %d: wrong number/type of arguments for directive \"%s\"", line, pCDirective );
        }
    else
        {
        mylog_info("line %d: unknown configuration directive \"%s\"", line, pCDirective );
        }
    return -1;
    }

void *
find_context(
    char *szType,
    char *szName
)
    {
    struct event_config *cc = &global_event;

    while(cc != NULL)
        {
        if((strcasecmp(cc->type, szType) == 0) && (strcasecmp(cc->name, szName) == 0))
            break;
        cc = cc->next;
        }
    return cc;
    }

void *
run_context_start_block(
    void *pvCtx
)
    {
    struct event_config *cc = (struct event_config *)pvCtx;

    if(pvCtx == NULL)
        return NULL;

    if(cc->start_block)
        {
        return cc->start_block();
        }
    return NULL;
    }

int
run_context_end_block(
    void *pvCtx,
    void *pvCtxData
)
    {
    struct event_config *cc = (struct event_config *)pvCtx;

    if((pvCtx == NULL) || (pvCtxData == NULL))
        return -1;

    if(cc->end_block)
        {
        return cc->end_block(pvCtxData);
        }
    return -1;
    }


int
run_context_statement(
    void *pvCtx,
    void *pvCtxData,
    struct token *t,
    int num_tokens
)
    {
    if((pvCtx == NULL) || (pvCtxData == NULL))
        return -1;

    return process_event( pvCtx, pvCtxData, t, num_tokens, 265);
    }
