/** Copyright (c) 2015 Cvisionhk */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <event.h>
#include <frame.h>
#include <stream.h>
#include <rtp.h>
#include <conf_parse.h>

static int i32LogFile = -1;

void rtsp_write_log(struct sockaddr *addr, int i32Id, char *pCharReq,
                    int i32Len, char *pCharRef, char *pCharUser )
    {
    char arrChar[128];
    time_t sTimeNow;
    int i;	// index for req length

    if( i32LogFile < 0 )
        {
        return;
        }

    for( i = 0; pCharReq[i] && pCharReq[i] != '\r' &&
            pCharReq[i] != '\n'; ++i );
    if( ! pCharRef || ! pCharRef[0] ) pCharRef = "-";
    if( ! pCharUser || ! pCharUser[0] ) pCharUser = "-";

    time( &sTimeNow );
    strcpy( arrChar, inet_ntoa( ((struct sockaddr_in *)addr)->sin_addr ) );
    write( i32LogFile, arrChar, strlen( arrChar ) );
    write( i32LogFile, arrChar,
           strftime( arrChar, sizeof( arrChar ), " - - [%d/%b/%Y:%T %z] \"",
                     localtime( &sTimeNow ) ) );
    write( i32LogFile, pCharReq, i );
    write( i32LogFile, arrChar, sprintf( arrChar, "\" %d %d \"", i32Id, i32Len));
    write( i32LogFile, pCharRef, strlen( pCharRef ) );
    write( i32LogFile, "\" \"", 3 );
    write( i32LogFile, pCharUser, strlen( pCharUser ) );
    write( i32LogFile, "\"\n", 2 );
    }

