/** Copyright (c) 2015 Cvisionhk */

/*
 * streammode.h
 *
 *  Created on: Oct 15, 2013
 *      Author: leon
 */

#ifndef STREAM_H_
#define STREAM_H_

struct stream
    {
        struct stream *next;
        struct stream *prev;
        char name[256];
        int format;
        struct stream_destination *dest_list;
#ifdef SUPPORT_RMC_P2P
        struct stream_destination *p2p_dest_list;
#endif
        void (*get_framerate)( struct stream *s, int *fincr, int *fbase );
        void (*set_running)( struct stream *s, int running );
        void *private;
    };

struct stream_destination
    {
    struct stream_destination *next;
    struct stream_destination *prev;
    struct stream *stream;
    int waiting;
    frame_deliver_func process_frame;
    void *d;
    };

struct stream *stream_new_stream( char *pcName, int i32Format, void *d );
void stream_deliver_frame_to_stream( struct frame *psFrame, void *d );
#ifdef SUPPORT_RMC_P2P
void deliver_frame_to_p2p_stream( struct frame *f, void *d );
struct stream_destination *connect_to_p2p_stream( char *name,
        frame_deliver_func process_frame, void *data, int * formats, int format_count );
#endif
struct stream_destination *connect_to_stream( char *name,
        frame_deliver_func process_frame, void *d,
        int *formats, int format_count );
void stream_del_stream( struct stream *psStream );
void stream_set_waiting( struct stream_destination *dest, int waiting );

#endif
