/*
* Copyright (C) 2014 CVision
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/* FILE   : plugin_rtsp.h
 * AUTHOR : leon
 * DATE   : Feb 24, 2015
 * DESC   : Public API for RTSP part
 */

#include <stdint.h>

#ifndef _STREAMMGR_PLUGIN_RTSP_H_
#define _STREAMMGR_PLUGIN_RTSP_H_

#define CVISION_CAMERA_MAX_FRAME_SIZE   (100*1024)

typedef struct rtsp_config_t
    {
    uint32_t    m_uiFrameSize;      //frame size of memory heap
    uint32_t    m_uiFrameCnt;       //frame count of memory heap. Total memory heap size = m_uiFrameSize * m_uiFrameCnt
    char        m_szUser[16];
    char        m_szPass[16];
    char        m_szH264CamPath[32];
    uint8_t     m_uiAuthen;
    uint8_t     m_uiIsInitialized;
    unsigned short m_uiPort;
    char        m_szAudioOnlyPath[32];
    } S_RTSP_CONFIG;


int rtsp_origin_init(void);
int rtsp_origin_config(S_RTSP_CONFIG *psConfig);
void rtsp_origin_run(void);
void rtsp_origin_stop(void);

#endif /* _STREAMMGR_PLUGIN_RTSP_H_ */
