/** Copyright (c) 2015 Cvisionhk */

typedef int (*rtpm_func_get_sdp)( char *dest, int len, int payload, int port, void *d );
typedef int (*rtpm_func_get_payload)( int payload, void *d );
typedef int (*rtpm_func_frame)( struct frame *f, void *d );
typedef int (*rtpm_func_send)( struct rtp_endpoint *ep, void *d );

struct rtp_media
    {
        rtpm_func_get_sdp get_sdp;
        rtpm_func_get_payload get_payload;
        rtpm_func_frame frame;
        rtpm_func_send send;
        void *private;
    };
struct rtp_media *new_rtp_media_h264_stream( struct stream *stream );
struct rtp_media *new_rtp_media_adpcm_stream( struct stream *stream );
struct rtp_media *session_new_rtp_media(
    rtpm_func_get_sdp get_sdp,
    rtpm_func_get_payload get_payload,
    rtpm_func_frame frame,
    rtpm_func_send send, void *private );
struct rtp_media *new_rtp_media_rawaudio_stream( struct stream *psStream );

struct rtp_media *new_rtp_media_aac_stream( struct stream *stream );
