/** Copyright (c) 2015 Cvisionhk */

/* These should probably be an enum */
#define	RTP_TRANSACTION_UDP	1
#define RTP_TRANSACTION_INTER	2

#define RTP_MAX_INTERLEAVE_CHANNELS	8

#define RTP_CONN_PROTO_START	0
#define RTP_CONN_PROTO_RTSP		1
#define RTP_CONN_PROTO_HTTP		2
#define RTP_CONN_PROTO_SIP		3

/* There's probably a better place to put these... */
#define RTP_PUT_16(pBuf,v) ((pBuf)[0]=((v)>>8)&0xff,(pBuf)[1]=(v)&0xff)
#define RTP_PUT_32(pBuf,v) ((pBuf)[0]=((v)>>24)&0xff,(pBuf)[1]=((v)>>16)&0xff,(pBuf)[2]=((v)>>8)&0xff,(pBuf)[3]=(v)&0xff)
#define RTP_GET_16(pBuf) (((pBuf)[0]<<8)|(pBuf)[1])
#define RTP_GET_32(pBuf) (((pBuf)[0]<<24)|((pBuf)[1]<<16)|((pBuf)[2]<<8)|(pBuf)[3])

struct rtp_endpoint;
struct rtp_conn;
struct session;

typedef int (*rtp_get_sdp_func)( struct session *s, char *dest, int *len, char *path );
typedef int (*rtp_setup_func)( struct session *s, int track );
typedef void (*rtp_play_func)( struct session *s, double *start );
typedef void (*rtp_pause_func)( struct session *s );
typedef void (*rtp_teardown_func)( struct session *s, struct rtp_endpoint *ep );
typedef void (*rtp_session_close_func)( struct session *sess );

struct rtp_endpoint
    {
    struct session *session;
    void* rtpPacketBuffer;
    int payload;
    int max_data_size;
    int isLocal;
    unsigned int ssrc;
    unsigned int start_timestamp;
    unsigned int last_timestamp;
    int seqnum;
    int packet_count;
    int octet_count;
    struct event *rtcp_send_event;
    int force_rtcp;
    struct timespec last_rtcp_recv;
    int trans_type;
    union
        {
        struct
            {
            char sdp_addr[48];
            int sdp_port;
            int rtp_fd;
            struct event *rtp_event;
            int rtcp_fd;
            struct event *rtcp_event;
            } udp;
        struct
            {
            struct rtp_conn *conn;
            int rtp_chan;
            int rtcp_chan;
            } inter;
        } trans;
    };

#define	RTP_MAX_TRACKS	2
struct session
    {
        struct session *next;
        struct session *prev;
        rtp_get_sdp_func get_sdp;
        rtp_setup_func setup;
        rtp_play_func play;
        rtp_pause_func pause;
        rtp_teardown_func teardown;
        void *private;
        int isLocal;
        rtp_session_close_func control_close;
        void *control_private;
        struct timeval open_time;
        char addr[64];
        struct rtp_endpoint *ep[RTP_MAX_TRACKS];
    };

struct rtp_loc_node
    {
    struct rtp_loc_node *next;
    struct rtp_loc_node *prev;
    char path[256];
    };

typedef struct session *(*open_func)( char *path, void *d );

struct req
    {
    struct rtp_conn *conn;
    struct pmsg *req;
    struct pmsg *resp;
    };

struct rtp_conn
    {
    struct rtp_conn *next;
    struct rtp_conn *prev;
    int fd;
    int second_fd; /* QuickTime uses two TCP connections for tunneling */
    struct sockaddr_in client_addr;
    struct event *read_event;
    struct event *second_read_event; /* for second_fd */
    struct event *write_event;
    int proto;
    char http_tunnel_cookie[128]; /* used to identify QuickTime tunnels */
    int base64_count; /* QuickTime uses base64 when tunneling over HTTP */
    unsigned char req_buf[4*1024];
    int req_len;
    struct req *req_list;
    unsigned char send_buf[300*1024];
    int send_buf_r;
    int send_buf_w;
    int drop_after;
    void *proto_state;
    };

void rtsp_origin_random_bytes( unsigned char *dest, int len );
void rtsp_origin_random_id( unsigned char *dest, int len );

/* Protype of RTP */
struct rtp_endpoint *rtp_new_endpoint( int i32Payload, int isLocal);
int rtp_connect_udp_endpoint( struct rtp_endpoint *psEndpoint,
                              struct in_addr dest_ip, int dest_port, int *piOurPort );
void rtp_interleave_recv_rtcp( struct rtp_endpoint *psEndpoint, unsigned char *d, int len );
void rtp_del_rtp_endpoint( struct rtp_endpoint *psEndpoint );
void rtp_update_rtp_timestamp( struct rtp_endpoint *psEndpoint, int time_increment );
void rtp_connect_interleaved_endpoint( struct rtp_endpoint *psEndpoint,
                                       struct rtp_conn *conn, int rtp_chan, int rtcp_chan );
int rtp_send_rtp_packet( struct rtp_endpoint *psEndpoint, struct iovec *v, int i32Cnt,
                         unsigned int timestamp, int marker );

/* Protype of TCP */
int tcp_avail_send_buf( struct rtp_conn *psRtpConn );
int tcp_send_data( struct rtp_conn *psRtpConn, unsigned char *pucData, int i32Len );
int tcp_send_pmsg( struct rtp_conn *psRtpConn, struct pmsg *psMsg, int i32Len );

/* Protype of HTTP */
void http_conn_disconnect( struct rtp_conn *c );
int http_handle_msg( struct req *req );

/* Protype of RTSP */
void rtsp_conn_disconnect( struct rtp_conn *psRtpConn );
void rtsp_interleave_disconnect( struct rtp_conn *psRtpConn, int i32Chan );
int rtsp_interleave_recv( struct rtp_conn *psRtpConn, int i32Chan, unsigned char *d, int i32Len );
int rtsp_interleave_send( struct rtp_conn *psRtpConn, int i32Chan, struct iovec *v, int i32Cnt, int isAudio);
int rtsp_handle_msg( struct req *psReq );
void rtsp_new_location( char *path, char *realm, char *username, char *password,
                        open_func open, void *private );

/* Protype of Session */
struct session *session_new_session(int isLocal);
void session_del_session( struct session *psSess );
int session_print_session_list( char *pcBuf, int maxlen );

