struct hdrf
    {
    char *name;
    char *value;
    };

#define PMSG_MAX_FIELDS	32

struct pmsg
    {
    unsigned char *msg;
    int max_len;
    int msg_len;
    struct hdrf fields[PMSG_MAX_FIELDS];
    int header_count;
    enum { PMSG_REQ, PMSG_RESP } type;
    char *proto_id;
    union
        {
        struct
            {
            char *method;
            char *uri;
            } req;
        struct
            {
            int code;
            char *reason;
            } stat;
        } sl;
    };

char *pmsg_add_pmsg_string( struct pmsg *psMsg, char *pcs );
int pmsg_parse_pmsg( struct pmsg *psMsg );
char *pmsg_get_header( struct pmsg *psMsg, char *pcName );
int pmsg_add_header( struct pmsg *psMsg, char *pcName, char *pcValue );
int pmsg_add_header_printf( struct pmsg *psMsg, char *pcName, char *pcFormat, ... );
int pmsg_replace_header( struct pmsg *psMsg, char *pcName, char *pcValue );
int pmsg_copy_headers( struct pmsg *psMsgDest, struct pmsg *psMsgSrc, char *pcName );
int pmsg_get_param( char *pcValue, char *pcTag, char *pcDest, int i32Size );
struct pmsg *pmsg_new_pmsg( int i32Size );
void pmsg_free_pmsg( struct pmsg *psMsg );

/* http-auth.c */
int httpauth_check_digest_response( struct pmsg *msg, char *realm,
                                    char *username, char *password );
int add_digest_challenge( struct pmsg *msg, char *realm, int stale );
