/** Copyright (c) 2015 Cvisionhk */

#ifndef __CVISION_RTSP_FRAME_H__
#define __CVISION_RTSP_FRAME_H__

#define RTSP_FORMAT_EMPTY		0
#define RTSP_FORMAT_RAW_RGB24	1
#define RTSP_FORMAT_RAW_UYVY		2
#define RTSP_FORMAT_RAW_BGR24	3
#define RTSP_FORMAT_RAW_YUYV		4		//Added by chchen59@nuvoton.com 
#define RTSP_FORMAT_PCM		64

#define RTSP_FORMAT_MPEG4		100
#define RTSP_FORMAT_JPEG		101
#define RTSP_FORMAT_MPV			102
#define RTSP_FORMAT_H263		103
#define RTSP_FORMAT_H264		104

#define RTSP_FORMAT_MPA			200
#define RTSP_FORMAT_ALAW		201
#define RTSP_FORMAT_ADPCM		202
#define RTSP_FORMAT_ULAW		203
#define RTSP_FORMAT_AAC			204
#define RTSP_FORMAT_G722     	205

struct frame;

typedef int (*frame_destructor)( struct frame *f, void *d );

struct frame
    {
    int ref_count;
    int size;
    pthread_mutex_t mutex; /* only used to lock the ref_count */
    frame_destructor destructor;
    void *destructor_data;
    int format;
    int width;
    int height;
    int length;
    int key;
    int step;
    unsigned char *d;
    unsigned int pts;
    };

struct frame_slot
    {
    struct frame_slot *next;
    struct frame_slot *prev;
    int pending;
    struct frame *f;
    };

typedef void (*frame_deliver_func)( struct frame *f, void *d );

struct frame_exchanger
    {
    int master_fd;
    int slave_fd;
    pthread_mutex_t mutex;
    pthread_cond_t slave_wait;
    struct event *master_event;
    frame_deliver_func f;
    void *d;
    struct frame_slot *slave_cur;
    struct frame_slot *master_read;
    struct frame_slot *master_write;
    };


struct frame_meter
    {
    int i32Started;
    int i32DownStream;
    event_time_ref sEvTimeRefLastCheck;
    int i32Rate;
    int i32Tick;
    double dSlip;
    double dAvgSlip;
    int i32PreComp;
    int i32CorrectionRate;
    int i32Corrected;
    };

void frame_init_frame_heap( int i32Size, int i32Count, char cNull);
int frame_get_max_frame_size(char cCvision);
struct frame *frame_new(char cCvision);
//struct frame *frame_clone( struct frame *psFrameOrigin, void *pv );
void frame_ref_frame( struct frame *psFrame, void *pv );
void frame_unref_frame( struct frame *psFrame, void *pv);
struct frame_exchanger *frame_new_exchanger( int i32Slot,
        frame_deliver_func frameDeliverFunc, void *d, void *pv );

/* master functions */
//int frame_exchange_frame( struct frame_exchanger *psFrameEx, struct frame *psFrame );

/* slave functions */
//struct frame *frame_get_next_frame( struct frame_exchanger *psFrameEx, int i32Wait );
void frame_deliver_frame( struct frame_exchanger *psFrameEx, struct frame *psFrame, void *pv);

#if 0
/* sample rate metering functions */
void frame_meter_init( struct frame_meter *psMeter, int i32FBase, int i32DownStream );
int frame_meter_count( struct frame_meter *psMeter, int i32Tick, int *psRate );
int frame_meter_get_adjustment( struct frame_meter *psMeter );
void frame_meter_report_correction( struct frame_meter *psMeter, int i32Tick );
#endif

#endif /* __CVISION_RTSP_FRAME_H__ */
