/** Copyright (c) 2015 Cvisionhk */

#include <sys/types.h>
#include <sys/time.h>

#ifndef _EVENT_H
#define _EVENT_H

#define RTSP_EVENT_TIME		1
#define RTSP_EVENT_FD		2
#define RTSP_EVENT_ALWAYS		3
#define RTSP_EVENT_SOFT_QUEUE	4

#define RTSP_EVENT_F_ENABLED		1
#define RTSP_EVENT_F_REMOVE		2
#define RTSP_EVENT_F_ONESHOT		4
#define RTSP_EVENT_F_RUNNING		8

struct event_info;

typedef struct timeval event_time_ref;
typedef void (*callback)( struct event_info *e, void *d );

struct time_event
    {
    event_time_ref fire;
    int ival;
    };

struct fd_event
    {
    int fd;
    int write; // 0 = read, 1 = write
    };

struct soft_event
    {
    struct soft_event *next;
    struct soft_event *prev;
    void *event_data;
    };

struct event_soft_queue
    {
    pthread_mutex_t mutex;
    pthread_cond_t wait;
    struct soft_event *empty_se_list;
    struct soft_event *se_list;
    struct event *ev_list;
    int fds[2];
    struct event *fd_event;
    };

struct event
    {
    struct event *prev;
    struct event *next;
    callback func;
    void *data;
    int type;
    int flags;
    union
        {
        struct time_event time;
        struct fd_event fd;
        struct event_soft_queue *sq;
        } ev;
    };

struct event_info
    {
    struct event *e;
    int type;
    void *data;
    };

int event_time_diff( event_time_ref *psEventTimeStart, event_time_ref *psEventTimeEnd, void *pv);
int event_time_ago( event_time_ref *psEventTime, void *pv);
void event_time_now( event_time_ref *psEventTime, void *pv);
void event_time_add( event_time_ref *psEventTime, int i32Milisecond, void *pv);
void event_time_future( event_time_ref *psEventTime, int i32Milisecond, void *pv);

//struct event_soft_queue *new_soft_queue( int length, void *pv);
//void *event_get_next( struct event_soft_queue *psEvSoftQueue );
//int event_soft_queue_add( struct event_soft_queue *psEvSoftQueue, void *arg );
struct event *event_add_timer( int msec, unsigned int flags, callback funcCB, void *arg, void *pv);
//struct event *event_add_alarm( event_time_ref *t, unsigned int flags, callback funcCB, void *arg );
void event_resched( struct event *psEv, event_time_ref *psEvTimeRef, void *pv);
struct event *event_add_fd( int i32Fd, int i32Write, unsigned int flags,
                            callback funcCB, void *arg, void *pv);
//struct event *event_add_always( unsigned int flags, callback funcCB, void *arg, void *pv);
//struct event *event_add_softqueue( struct event_soft_queue *psEvSoftQueue, unsigned int flags,
//		callback funcCB, void *arg );
void event_remove( struct event *psEvent, void *pv);
//void event_set_event_interval( struct event *psEvent, int msec );
void event_set_event_enabled( struct event *psEvent, int enabled, void *pv);
int event_get_event_enabled( struct event *psEvent );
void event_exit_event_loop(void);
void event_loop(int i32Single, void *pv);

#endif /* EVENT_H */
