/*
* Copyright (C) 2014 CVision
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/* FILE   : plugin_rtsp.h
 * AUTHOR : leon
 * DATE   : Feb 24, 2015
 * DESC   : Public API for RTSP part
 */

#ifndef _CV_STREAMMGR_PLUGIN_RTSP_H_
#define _CV_STREAMMGR_PLUGIN_RTSP_H_

int
rtsp_stream_init(int frameSize, int frameCount, char* fullStream, char* audioStream, char* user, char* pass, int port);

int
rtsp_stream_run(int stackSize);

int
rtsp_stream_stop(void);

int
rtsp_is_config();

/* User need to call those below functions each time get data */
void rtsp_deliver_video_frame(void* data, int size, int isKeyFrame, int pts);
void rtsp_deliver_audio_frame(void* data, int size, int isKeyFrame, int pts);


#endif /* _CV_STREAMMGR_PLUGIN_RTSP_H_ */
