#ifndef __MQTT_PLATFORM_FEATURE_H__
#define __MQTT_PLATFORM_FEATURE_H__

#include "zlog.h"
#include "common.h"
#include "nuvotonwrapper.h"

#define CAMSDK_BUILT 0
#define SUPPORT_MQTT_ANALYTICS_LOG 1
#define NUVOTON_PLATFORM_SUPPORT
#define FIRMWARE_CONFIG_PATH   "/"
#define CONFIG_RW_PATH         FIRMWARE_CONFIG_PATH"mnt/cache"
#define CVISION_LOG_CONFIG_PATH "/mnt/skyeye/etc/dev.conf"//Path to zlog config file
#define CAMERA_IP       "127.0.0.1" // Default IP if running MQTT on camera
#define DEFAULT_IMAGE_PATH    "/mnt/skyeye/mlswwwn/hubble_image.jpg"
#define TEMPORARY_IMAGE_PATH  "/mnt/cache/temp_image"

// Path to store 3 certs and publish/subscribe topic.
#define CA_FILE             CONFIG_RW_PATH"/ca.crt"
#define CLIENT_CERT_FILE    CONFIG_RW_PATH"/client.crt"
#define CLIENT_KEY_FILE     CONFIG_RW_PATH"/client.key"
#define CLIENT_PUB_TOPIC     CONFIG_RW_PATH"/pub_topic.txt"
#define CLIENT_SUB_TOPIC     CONFIG_RW_PATH"/sub_topic.txt"
#define JSON_TOKEN_SUB_TOPIC    "subscribe_topic"
#define JSON_TOKEN_PUB_TOPIC    "publish_topic"

#define CERT_MD5SUM_FILE "/mnt/skyeye/etc/Certs.MD5Sum"
#define STORED_CA_FILE "/mnt/skyeye/etc/ca.crt"
#define STORED_CLIENT_CERT_FILE "/mnt/skyeye/etc/client.crt"
#define STORED_CLIENT_KEY_FILE "/mnt/skyeye/etc/client.key"
#define STORED_CERTS_PATH "/mnt/skyeye"

#define ENABLE_NETWORK_CHECKING						1

#define __FILENAME__ (strrchr(__FILE__, '/') ? strrchr(__FILE__, '/') + 1 : __FILE__)

//Define hlog for nuvoton platform
#define hlog_open(fmt)   		 dzlog_init(FW_DEV_CONF_PATH, fmt)
#define hlog_open_central(fmt)   dzlog_init(CVISION_LOG_CONFIG_PATH, fmt)
#define hlog_closed()    		 dzlog_fini()

#define hlog_info(...)    dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_INFO, __VA_ARGS__)
#define hlog_error(...)   dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__,	ZLOG_LEVEL_ERROR, __VA_ARGS__)
#define hlog_warn(...)    dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_WARN, __VA_ARGS__)
#define hlog_notice(...)  dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_NOTICE, __VA_ARGS__)
#define hlog_debug(...)   dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_DEBUG, __VA_ARGS__)
#define hlog_fatal(...)   dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__,	ZLOG_LEVEL_FATAL, __VA_ARGS__)

#endif
