#ifndef __MQTT_PLATFORM_FEATURE_H__
#define __MQTT_PLATFORM_FEATURE_H__
#include "zlog.h"
#include "fwpath.h"
#include "nvconf.h"
#include "cvappname.h"


#define HTTPS_CLIENT_REQUEST_FIVE_PARA
#define CAMERA_IP   "127.0.0.1"
#define CERT_MD5SUM_FILE "/usr/local/etc/Certs.MD5Sum"
#define STORED_CA_FILE "/usr/local/etc/ca.crt"
#define STORED_CLIENT_CERT_FILE "/usr/local/etc/client.crt"
#define STORED_CLIENT_KEY_FILE "/usr/local/etc/client.key"
#define STORED_CERTS_PATH "/usr/local"
#define CAMSDK_BUILT 1

//Define hlog for nuvoton platform
#define hlog_open(fmt)   		 dzlog_init(CVISION_LOG_CONFIG_PATH, fmt)
#define hlog_closed()    		 dzlog_fini()

#define hlog_info(...)    dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_INFO, __VA_ARGS__)
#define hlog_error(...)   dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__,	ZLOG_LEVEL_ERROR, __VA_ARGS__)
#define hlog_warn(...)    dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_WARN, __VA_ARGS__)
#define hlog_notice(...)  dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_NOTICE, __VA_ARGS__)
#define hlog_debug(...)   dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__, ZLOG_LEVEL_DEBUG, __VA_ARGS__)
#define hlog_fatal(...)   dzlog(__FILE__, sizeof(__FILE__)-1, __func__, sizeof(__func__)-1, __LINE__,	ZLOG_LEVEL_FATAL, __VA_ARGS__)

#endif//#define __MQTT_PLATFORM_FEATURE_H__
