#ifndef _PC_WRAPPER_H
#define _PC_WRAPPER_H

#define NVCONF_MODEL            "model"
#define NVCONF_FW_VERSION       "version"
#define NVCONF_MASTER_KEY       "key"
#define NVCONF_MAC              "mac"
#define NVCONF_UDID             "udid"
#define NVCONF_MQTT_SERVER      "mqtt.server"
#define NVCONF_MQTT_PUB_TOPIC           "authen.pubTopic"
#define NVCONF_MQTT_SUB_TOPIC           "authen.subTopic"
#define NVCONF_MQTT_SERVER_URI          "authen.serverURI"



// function to get back the mac address of the device
int nxcNetworkGetMacAddr(char* mac);

int nxcNetworkGetUDID (char* udid);

// fake version to simulate the config reading of the device
int nvram_param_read(const char* key, char* value);

int nvram_param_write1(const char* key, char* value);

int nxcHubbleGetServerName(char* serverName);

int nxcHubbleGetServerPort (char* serverPort);

void getUserAgent(char* userAgent);

int RunSystemCmd(char* cmd);

#endif
