/*
* Copyright (C) 2014 NxComm Pte. Ltd.
*
* This unpublished material is proprietary to NxComm.
* All rights reserved. The methods and
* techniques described herein are considered trade secrets
* and/or confidential. Reproduction or distribution, in whole
* or in part, is forbidden except by express written permission
* of NxComm.
* Author : Vinh Nguyen
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>
#include <assert.h>
#include "hubble_log.h"
#include "curl/curl.h"
#include "hubble_config.h"
#include "http_bridge.h"
#include "pcwrapper.h"

#define LENGHT_RESPONSE     128
#define TRUE            1
#if 0
    strcpy(camInfo.masterkey, "UAE6gC7lvQlB5wzG");
    strcpy(camInfo.mac, "000C43750887");
    strcpy(camInfo.model, "0073");
    strcpy(camInfo.version, "03.10.10");
    strcpy(camInfo.udid, "010073000C43750887PITDGEQU");
    strcpy(camInfo.serverURL, "cs.hubble.in");
    camInfo.serverPort = 443;

#endif
struct MemoryStruct1
{
char* buffer;
size_t size;
};

char g_mac[16] = {0};
char g_model[32] = {0};
char g_version[32] = {0};
char g_udid[32] = {0};
char g_server[128] = {0};
char g_port[8] = {0};
#if 0
static size_t WriteMemoryCallback1(void *contents, size_t size, size_t nmemb, void *userp)
{
    size_t realsize = size * nmemb;
    struct MemoryStruct1 *mem = (struct MemoryStruct1 *)userp;
    if(realsize < 8000)
    {
        assert(mem);
        if(mem->buffer == NULL)
        {
            assert(mem->buffer);
            hlog_error("Memory NULL");
            return 0;
        }
        memcpy(mem->buffer, contents, realsize);
        mem->size = realsize;
        mem->buffer[mem->size] = 0;
    }
    else
    {
        hlog_error("REPLY SIZE %d CAN NOT BE BIGGER THAN 8 KBs", realsize);
        return -1;
    }
    return realsize;
}


// sret = string return. The mem needs to be avail at least 256 bytes
int CvCmdMgrBridge1(CURL* curl_handle_command, char* cmddata, char* sret)
{
    CURLcode res;
//    CURL* curl_handle_command;

    char cmd[256];
    int  exit_status = 0;
    //int  port = strtoul(((char*)HTTP_PORT), NULL, 10);
    int port = HTTP_PORT;
//    char *pTmpStr = NULL;
    struct MemoryStruct1 chunk;

//    curl_handle_command = curl_easy_init();
    if(curl_handle_command == NULL)
    {
        hlog_error("Error Creating Curl_handleCommand\n");
        return 1;
    }

    sprintf(cmd, "http://%s:%d/?%s", CAMERA_IP, port, cmddata);
    //hlog_info("Send command to Camera's HTTP Server: '%s'\n",cmd);
    /* specify URL to get */
    curl_easy_setopt(curl_handle_command, CURLOPT_URL, cmd);

    /* send all data to this function  */
    curl_easy_setopt(curl_handle_command, CURLOPT_WRITEFUNCTION, WriteMemoryCallback1);

    /* we pass our 'chunk' struct to the callback function */
    chunk.buffer = sret;
    curl_easy_setopt(curl_handle_command, CURLOPT_WRITEDATA, (void * )&chunk);
    curl_easy_setopt(curl_handle_command, CURLOPT_CONNECTTIMEOUT, 1);
    curl_easy_setopt(curl_handle_command, CURLOPT_TIMEOUT, 10);
    curl_easy_setopt(curl_handle_command, CURLOPT_NOSIGNAL, 1);
    curl_easy_setopt(curl_handle_command, CURLOPT_FAILONERROR, TRUE);

    /* some servers don't like requests that are made without a user-agent
     field, so we provide one */
    curl_easy_setopt(curl_handle_command, CURLOPT_USERAGENT, "libcurl-agent/1.0");
    /* get it! */
    res = curl_easy_perform(curl_handle_command);
    if(res != CURLE_OK)
    {
        hlog_error("curl_easy_perform return error %d %s\n", res, curl_easy_strerror(res));
        exit_status = -1;
    }
    return exit_status;
}
#endif
int nxcNetworkGetUDID (char* udid)
{
    int ret = 0;
    char temp[32] ={0};
    char response[LENGHT_RESPONSE] = {0};

    if(strcmp(g_udid, "") !=0)
    {
        strcpy(udid, g_udid);
        hlog_info("g_udid=%s", g_udid);
        return ret;
    }

    ret = send_command_to_http_module(HTTP_GET_UDID, response, LENGHT_RESPONSE);
    if( 0 == ret)
    {
        strcpy(temp, response+10);
        if(strlen(temp) > 25)   //length udid is 27 byte
        {
            strcpy(udid, temp);
            strcpy(g_udid, udid);
            hlog_info("get udid success");
        }
        else
        {
            ret  = -1;
        }
        hlog_info("udid=%s,  response=%s", udid, response);
    }
    return ret;
}

// function to get back the mac address of the device
int nxcNetworkGetMacAddr(char* mac)
{

    int ret = 0;
    int len = 0;
    char *pointer = NULL;
    char response[LENGHT_RESPONSE] = {0};

    if(strcmp(g_mac, "") !=0)
    {
        strcpy(mac, g_mac);
        hlog_info("g_mac=%s", g_mac);
        return ret;
    }

    ret = send_command_to_http_module(HTTP_GET_MAC, response, LENGHT_RESPONSE);
    if( 0 == ret)
    {
        len = strlen(response);
        pointer = strstr(response, "get_mac_address");
        if(len > 28 && (NULL != pointer))//lenght mac address is 12 byte
        {
            strcpy(mac, response+17);
            strcpy(g_mac, mac);
            hlog_info("mac=%s,  response=%s", mac, response);
        }
        else
        {
            hlog_error("Wrong response");
            ret = -1;
        }
    }
    return ret;
}

// function to get back the mac address of the device
int nxcHubbleGetServerName(char* serverName)
{
    int ret = 0;
    int len = 0;
    char *pointer = NULL;
    char response[LENGHT_RESPONSE] = {0};

    if(strcmp(g_server, "") !=0)
    {
        strcpy(serverName, g_server);
        hlog_info("g_server=%s", g_server);
        return ret;
    }

    ret = send_command_to_http_module(HTTP_GET_SERVER_URL, response, LENGHT_RESPONSE);
    if( 0 == ret)
    {
        len = strlen(response);
        pointer = strstr(response, "get_cs_url");
        if(len > 15 && (NULL != pointer))
        {
            strcpy(serverName, response+12);
            strcpy(g_server, serverName);
            hlog_info("serverName=%s,  response=%s", serverName, response);
        }
        else
        {
            hlog_error("Wrong response");
            ret = -1;
        }
    }
    return ret;
}

int nxcHubbleGetServerPort(char* serverPort)
{
    strcpy(serverPort,"443");
    hlog_info("serverPort=%s", serverPort);
    return 0;
}

int nxcHubbleGetModel(char* model)
{
    int ret = 0;
    int len = 0;
    char *pointer = NULL;
    char response[LENGHT_RESPONSE] = {0};

    if(strcmp(g_model, "") !=0)
    {
        strcpy(model, g_model);
        hlog_info("g_model=%s", g_model);
        return ret;
    }
    ret = send_command_to_http_module(HTTP_GET_MODEL, response, LENGHT_RESPONSE);
    if( 0 == ret)
    {
        len = strlen(response);
        pointer = strstr(response, "get_model");
        if(len > 14 && (NULL != pointer))
        {
            strcpy(model, response+11);
            strcpy(g_model, model);
            hlog_info("model=%s,  response=%s", model, response);//lenght model is 4
        }
        else
        {
            hlog_error("Wrong response");
            ret = -1;
        }
    }
    return ret;
}

int nxcHubbleFWVersion(char* version)
{
    int ret = 0;
    int len = 0;
    char *pointer = NULL;
    char response[LENGHT_RESPONSE] = {0};


    if(strcmp(g_version, "") !=0)
    {
        strcpy(version, g_version);
        hlog_info("g_version=%s", g_version);
        return ret;
    }

    ret = send_command_to_http_module(HTTP_GET_VERSION, response, LENGHT_RESPONSE);
    if( 0 == ret)
    {
        len = strlen(response);
        pointer = strstr(response, "get_version");
        if(len > 20 && (NULL != pointer))
        {
            strcpy(version, response+13);
            strcpy(g_version, version);
            hlog_info("version=%s,  response=%s", version, response);//lenght version is 8
        }
        else
        {
            hlog_error("Wrong response");
            ret = -1;
        }
    }
    return ret;
}

int nxcHubbleMasterKey(char* masterkey)
{
    int ret = 0;
    int len = 0;
    char *pointer = NULL;
    char response[LENGHT_RESPONSE] = {0};

    CURL* curl_handle_command;
    ret = send_command_to_http_module(HTTP_GET_AUTHEN_KEY, response, LENGHT_RESPONSE);
    if( 0 == ret)
    {
        len = strlen(response);
        pointer = strstr(response, "get_masterkey");
        if(len > 30 && (NULL != pointer))
        {
            strcpy(masterkey, response+15);
            //hlog_info("masterkey=%s,  response=%s", masterkey, response);//lenght masterkey is 16
        }
        else
        {
            hlog_error("Wrong response");
            ret = -1;
        }
    }
    return ret;
}
// fake version to simulate the config reading of the device
int nvram_param_read(const char* key, char* value)
{

    if (strcmp(key,NVCONF_MODEL)==0)
    {
        nxcHubbleGetModel(value);
        return 0;
    } else if (strcmp(key,NVCONF_MAC)==0)
    {
        return nxcNetworkGetMacAddr(value);
    } else if (strcmp(key,NVCONF_FW_VERSION)==0)
    {
        return nxcHubbleFWVersion(value);
    } else if (strcmp(key,NVCONF_MASTER_KEY)==0)
    {
        return nxcHubbleMasterKey(value);
    }else if (strcmp(key,NVCONF_UDID)==0)
    {
        return nxcNetworkGetUDID(value);

    } else
    {
        hlog_error("ERROR USE WRONG KEY NOT SUPPORT '%s'\n",key);
        return -1;
    }
    return 0;
}

int nvram_param_write1(const char* key, char* value)
{
    return 0;
}
// Get User Agent
void getUserAgent(char* userAgent)
{

    char   cModel[8] = {0};
    char   cVersion[16] = {0};
    nvram_param_read(NVCONF_MODEL, cModel);
    nvram_param_read(NVCONF_FW_VERSION, cVersion);
    sprintf(userAgent,"%s/%s",cModel, cVersion);
}

/*
 * PURPOSE : Run system command in blocking way
 * INPUT   : [cmd]  - System command
 * OUTPUT  : None
 * RETURN  : Return code of system command
 * DESCRIPT: None
 */
int RunSystemCmd(char* cmd)
{
    int iRetCode = -1;
    int processStat = -1;
    if(cmd != NULL)
    {
        iRetCode = system(cmd);
        if(iRetCode != 0)
         {
            hlog_error("\"%s\" return %d", cmd, iRetCode);
            return iRetCode;
        }
        wait(&processStat);
        iRetCode = WIFEXITED(processStat);
        if(iRetCode)
            iRetCode = WEXITSTATUS(processStat);
        hlog_error("\"%s\" return %d", cmd, iRetCode);
    }
    return iRetCode;
}