/*
 * Copyright (c) 2007-2015, Cameron Rich
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * * Neither the name of the axTLS project nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file os_port.h
 *
 * Some stuff to minimise the differences between windows and linux/unix
 */

#ifndef HEADER_OS_PORT_H
#define HEADER_OS_PORT_H

#ifdef __cplusplus
extern "C" {
#endif

//#include "os_int.h"
//#include "config.h"
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include "mqtts.h"
#include "hubble_log.h"
#if 0
#define SOCKET_READ(A,B,C)      rtl_tcp_read(A,B,C)
#define SOCKET_WRITE(A,B,C)     rtl_tcp_write(A,B,C)
#define SOCKET_CLOSE(A)         if (A >= 0) rtl_tcp_close(A)
#endif
#define TTY_FLUSH()


/* debug configuration */

#define DEBUG_CRYPTO    0

/* some functions to mutate the way these work */

int ax_open(const char *pathname, int flags);
#define realloc(A,B)    porting_realloc(A,B)
#define calloc(A,B)     porting_calloc(A,B)
void *  porting_realloc(void *y, size_t s);
void *  porting_calloc(size_t n, size_t s);
void * porting_free(void *n);
void porting_msleep(int ms);

#define mqtt_logger hlog_info

/* Mutexing definitions */
#if defined(CONFIG_SSL_CTX_MUTEXING)
#else   /* no mutexing */
#define SSL_CTX_MUTEX_INIT(A)
#define SSL_CTX_MUTEX_DESTROY(A)
#define SSL_CTX_LOCK(A)
#define SSL_CTX_UNLOCK(A)
#endif

#ifdef __cplusplus
    }
#endif

#endif
