#ifndef _NUVOTON_WRAPPER_H
#define _NUVOTON_WRAPPER_H

#define NVCONF_MODEL            "model"
#define NVCONF_FW_VERSION       "version"
#define NVCONF_MASTER_KEY       "key"
#define NVCONF_MAC              "mac"
#define NVCONF_UDID             "udid"
#define NVCONF_MQTT_PUB_TOPIC                      "publish_topic"
#define NVCONF_MQTT_SUB_TOPIC                      "subscribe_topic"
#define NVCONF_MQTT_SERVER_URI                     "mqtt_server_uri"

#include "common.h"
#include "configure.h"
#include "nxcNetwork.h"
#include "httpsclient.h"


// fake version to simulate the config reading of the device
int nvram_param_read(const char* key, char* value);

int nxcNetworkGetUDID (char* udid);

int nxcHubbleGetServerName(char* serverName);

void getUserAgent(char* userAgent);

int RunSystemCmd(char* cmd);

#endif
