/*
* Copyright (C) 2014 NxComm Pte. Ltd.
*
* This unpublished material is proprietary to NxComm.
* All rights reserved. The methods and
* techniques described herein are considered trade secrets
* and/or confidential. Reproduction or distribution, in whole
* or in part, is forbidden except by express written permission
* of NxComm.
* Author : Vinh Nguyen
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "nuvotonwrapper.h"

#define DEFAULT_SERVER              "cs.hubble.in"
typedef struct CONFIG
{
    char model[8];
    char mac[14];
    char version[16];
    char key[256];
    char udid[32];
    char sub_topic[64];
}config_t;

static config_t config;

//WRAP FUNCTION FOR SDK COMPATIBILITY
int nvram_param_read(const char* key, char* value)
{
    int ret = -1;

    if(!key || !value)
    {
        printf("Getting cam_config error, input value is NULL POINTER");
        return -1;
    }

	if (strcmp(key,NVCONF_MODEL)==0)
	{
        ret = cmd_get_model(config.model);
        if (ret != 0)
        {
            //printf("CRASH CRASH CRASH MUST HAVE MODEL STRING HERE %d\n",ret);
            //HARDCODE
            strcpy(config.model,MODEL_MACHINE_NAME);
        }
    
		strcpy(value,config.model);
	}
	else if (strcmp(key,NVCONF_FW_VERSION)==0)
	{
        int major,minor,revision;
        ret = get_version(&major, &minor, &revision);
        if (ret != 0)
        {
            //printf("CRASH CRASH CRASH MUST HAVE FW STRING %d\n",ret);
            return -2;
        }

        sprintf(config.version,"%02d.%02d.%02d",major,minor,revision);
		strcpy(value,config.version);
	}
    else if (strcmp(key,NVCONF_MASTER_KEY)==0)
	{
        char masterkey[256]={0};
        ret = cmd_get_master_key(masterkey);
        if (ret != 0)
        {
            //printf("CRASH CRASH CRASH MUST HAVE MASTERKEY STRING \n");
            return -3;
        }
        else if(strlen(masterkey) == 0 || strcmp(masterkey,DEFAULT_MASTER_KEY) == 0)
        {
            //printf("CRASH CRASH CRASH MASTER_KEY_WRONG !!!\n");
            return -4;
        }
        else if(strcmp(masterkey,config.key) != 0)
        {
            //printf("CRASH CRASH CRASH MASTER_KEY_HAS_UPDATE. Do reloading!!! !!!\n");
            memset(config.key,0,sizeof(config.key));
            strcpy(config.key,masterkey);
        }
		strcpy(value,config.key);
	}
    else if (strcmp(key,NVCONF_UDID)==0)
    {
        if(strlen(config.udid) == 0)
        {
            char strUDID[27] = {0};
            cmd_get_udid(strUDID,sizeof(strUDID));
            strcpy(value,strUDID);

            memset(config.udid,0,sizeof(config.udid));
            strcpy(config.udid,strUDID);
        }
        else
            strcpy(value,config.udid);
    }
    else if (strcmp(key,NVCONF_MQTT_SUB_TOPIC)==0)
    {
		char str_sub_topic[64] = {0};
		cmd_get_authen_info(NVCONF_MQTT_SUB_TOPIC,str_sub_topic);
		strcpy(value, str_sub_topic);
    }
    else if (strcmp(key,NVCONF_MQTT_PUB_TOPIC)==0)
    {
		char str_pub_topic[64] = {0};
		cmd_get_authen_info(NVCONF_MQTT_PUB_TOPIC,str_pub_topic);
		strcpy(value, str_pub_topic);
    }
    else if (strcmp(key,NVCONF_MQTT_SERVER_URI)==0)
    {
		char str_s_uri[64] = {0};
		cmd_get_authen_info(NVCONF_MQTT_SERVER_URI,str_s_uri);
		strcpy(value, str_s_uri);
    }
    else
	{
		//printf("ERROR USE WRONG KEY NOT SUPPORT '%s'\n",key);
		return -5;
	}
    
    return 0;
}

int nvram_param_write1(const char* key, char* value)
{
    int ret = -1;

    if(!key || !value)
    {
        printf("Getting cam_config error, input value is NULL POINTER");
        return -1;
    }
	if (strcmp(key,NVCONF_MQTT_SUB_TOPIC) == 0)
	{
		ret = cmd_set_authen_info(NVCONF_MQTT_SUB_TOPIC,value);
		if(ret != 0)
		{
			printf("Can not set config:%s, ret:%d", NVCONF_MQTT_SUB_TOPIC, ret);
		}
	}
	else if (strcmp(key,NVCONF_MQTT_PUB_TOPIC) == 0)
	{
		ret = cmd_set_authen_info(NVCONF_MQTT_PUB_TOPIC,value);
		if(ret != 0)
		{
			printf("Can not set config:%s, ret:%d", NVCONF_MQTT_PUB_TOPIC, ret);
		}
	}
	else if (strcmp(key,NVCONF_MQTT_SERVER_URI) == 0)
	{
		ret = cmd_set_authen_info(NVCONF_MQTT_SERVER_URI,value);
		if(ret != 0)
		{
			printf("Can not set config:%s, ret:%d", NVCONF_MQTT_SERVER_URI, ret);
		}
	}
    else
	{
		printf("ERROR USE WRONG KEY NOT SUPPORT '%s'\n",key);
		return -5;
	}
	return ret;
}

// Get User Agent
void getUserAgent(char* userAgent)
{
    char   cModel[8] = {0};
    char   cVersion[16] = {0};
    
    if(!userAgent)
        return;

    if(nvram_param_read(NVCONF_MODEL, cModel) != 0)
        return;

    if(nvram_param_read(NVCONF_FW_VERSION, cVersion) != 0)
        return;

    sprintf(userAgent,"%s/%s",cModel, cVersion);
}

//Optimized MQTT response with local function
//Instead of HTTP request
int get_mac_address(char *mac, int mac_len)
{
    if (!mac)
        return -1;

    if (mac_len < 12)
        return -2;

    char udid[27] = {0};
    if(!nvram_param_read(NVCONF_UDID,udid))
    {
        strncpy(mac,(char*)(udid+6),12);
    }
    else
    {
        if(nxcNetworkGetMacAddr(mac)==NULL)
            return -3;
    }

    return 0;
}

int nxcHubbleGetServerName(char* serverName)
{
	return cmd_get_server_string("SnapshotServerName",serverName, DEFAULT_SERVER, 128);
}
/*
 * PURPOSE : Run system command in blocking way
 * INPUT   : [cmd]  - System command
 * OUTPUT  : None
 * RETURN  : Return code of system command
 * DESCRIPT: None
 */
int RunSystemCmd(char* cmd)
{
    int iRetCode = -1;
    int processStat = -1;
    if(cmd != NULL)
    {
        iRetCode = system(cmd);
        if(iRetCode != 0)
         {
            printf("\"%s\" return %d", cmd, iRetCode);
            return iRetCode;
        }
        wait(&processStat);
        iRetCode = WIFEXITED(processStat);
        if(iRetCode)
            iRetCode = WEXITSTATUS(processStat);
        printf("\"%s\" return %d", cmd, iRetCode);
    }
    return iRetCode;
}

