/*******************************************************************************
 * Copyright (c) 2014 Cvisionhk.
 *******************************************************************************/

#ifndef _MQTT_TRANSPORT_SSL_H_
#define _MQTT_TRANSPORT_SSL_H_

#include <stdio.h>
#include <string.h>
#include "MQTTMidleware.h"
#include "mbedtls/config.h"
#include "mbedtls/net.h"
#include "mbedtls/ssl.h"
#include "mbedtls/entropy.h"
#include "mbedtls/ctr_drbg.h"
#include "mbedtls/certs.h"
#include "mbedtls/x509.h"
#include "mbedtls/error.h"
#include "mbedtls/debug.h"
#include "mbedtls/timing.h"
#include "os_port.h"
#if defined(MBEDTLS_PLATFORM_C)
#include "mbedtls/platform.h"
#else
#include <stdbool.h>
#include <stdio.h>
#define fflush
#endif

int mqtt_read(Network* n, unsigned char* buffer, int len, int timeout_ms);
int  mqtt_write(Network* n, unsigned char* buffer, int len, int timeout_ms);
void mqtt_disconnect(Network* n);
int NewNetwork(Network* n);
int ConnectNetwork(Network* n, char* url, int port);
void mqtt_set_non_block();
int get_skip_download_cert_flag();
void set_skip_download_cert_flag(int flag);

#endif /* _MQTT_TRANSPORT_SSL_H_ */
