/*******************************************************************************
 * Copyright (c) 2014 Cvisionhk.
 *******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>

#include "MQTTMidleware.h"
#include "mbedtls/config.h"

#include "mbedtls/net.h"
#include "mbedtls/ssl.h"
#include "mbedtls/entropy.h"
#include "mbedtls/ctr_drbg.h"
#include "mbedtls/certs.h"
#include "mbedtls/x509.h"
#include "mbedtls/error.h"
#include "mbedtls/debug.h"
#include "mbedtls/timing.h"
#include "os_port.h"
#include "hubble_config.h"
//#include "nvconf.h"
#if defined(MBEDTLS_PLATFORM_C)
#include "mbedtls/platform.h"
#else
#include <stdbool.h>
#include <stdio.h>
#define fflush
#endif
extern unsigned char aws_private_key[];
extern unsigned char aws_certificate[];
extern unsigned char aws_rootCA[];

#ifndef MQTTS_SOCKET_TIMEOUT_SEC
#define MQTTS_SOCKET_TIMEOUT_SEC 60
#endif // MQTTS_SOCKET_TIMEOUT_SEC

#ifndef MQTTS_SOCKET_TIMEOUT_MICROSECOND
#define MQTTS_SOCKET_TIMEOUT_MICROSECOND 0
#endif // MQTTS_SOCKET_TIMEOUT_MICROSECOND

#define MBEDTLS_CIPHERSUITES "TLS-RSA-WITH-AES-128-CBC-SHA256"

//extern MQTT_LOGGER mqtt_logger;
#define DEBUG_LEVEL 1
#define CONNACK_ERROR "-0x7880" // MQTTConnect failed because it's unable to receive CONNACK
static int ret = 0;
static int skip_download_certs = 0;
static char mbedtls_errorbuf[256];
static mbedtls_entropy_context entropy;
static mbedtls_ctr_drbg_context ctr_drbg;
static mbedtls_ssl_context ssl;
static mbedtls_ssl_config conf;
static uint32_t flags;
static mbedtls_x509_crt cacert;
static mbedtls_x509_crt clicert;
static mbedtls_pk_context pkey;
static mbedtls_net_context server_fd;
static void my_debug(void *ctx, int level,
        const char *file, int line,
        const char *str)
{
    hlog_info("%s:%d: %s", file, line, str);
    // In case server return error code -0x7880, skip re-download certs.
    char* errorCodeBuf = strrchr(str,'-');
    if (errorCodeBuf != NULL)
    {
        char errorCode[16];
        strncpy(errorCode,errorCodeBuf,sizeof(CONNACK_ERROR)-1);
        if (strcmp(errorCode,CONNACK_ERROR)==0)
            skip_download_certs = 1;
    }
}
int get_skip_download_cert_flag()
{
    return skip_download_certs;
}
void set_skip_download_cert_flag(int flag)
{
    skip_download_certs = flag;
}
static int myCertVerify(void *data, mbedtls_x509_crt *crt, int depth, uint32_t *flags)
{
    char buf[512];

    mbedtls_x509_crt_info(buf, sizeof(buf) - 1, "", crt);

    if(flags != NULL)
    {
        if((*flags) == 0)
        {
            hlog_info("  This certificate has no flags");
        }
        else
        {
            hlog_debug("certt info %s", buf);
        }
    }
    else
    {
        hlog_error("passed NULL pointer");
        return -1;
    }

    return (0);
}

static int getCertFromFile(unsigned char* ca, unsigned char* client, unsigned char* key)
{
    //    int ret = 0;
    char ca_path[256];
    char client_path[256];
    char key_path[256];
    FILE *fca = NULL;
    FILE *fcert = NULL;
    FILE *fkey = NULL;

    memset(ca_path, 0x00, sizeof(ca_path));
    memset(client_path, 0x00, sizeof(client_path));
    memset(key_path, 0x00, sizeof(key_path));

    //Read path to certificates and private-key files from nvconf
    //    ret = nvram_param_read(NVCONF_MQTT_ROOTCA, ca_path);
    //    if(ret < 0)
    //    {
    //        return ret;
    //    }
    //
    //    ret = nvram_param_read(NVCONF_MQTT_CLIENTCERT, client_path);
    //    if(ret < 0)
    //    {
    //        return ret;
    //    }
    //
    //    ret = nvram_param_read(NVCONF_MQTT_PRIVATEKEY, key_path);
    //    if(ret < 0)
    //    {
    //        return ret;
    //    }
    strcpy(ca_path,CA_FILE);
    strcpy(client_path,CLIENT_CERT_FILE);
    strcpy(key_path,CLIENT_KEY_FILE);

    //Read ca.crt from file
    fca = fopen(ca_path, "r");
    if(fca == NULL)
    {
        hlog_info("Can not open file %s",ca_path);
        return -1;
    }

    fread(ca, 1, 3076, fca);

    fclose(fca);
    //Read client.crt from file
    fcert = fopen(client_path, "r");
    if(fcert == NULL)
    {
        hlog_info("Can not open file %s.",client_path);
        return -1;
    }

    fread(client, 1, 3076, fcert);

    fclose(fcert);
    //Read client.key from file
    fkey = fopen(key_path, "r");
    if(fkey == NULL)
    {
        hlog_info("Can not open file %s\n",key_path);
        return -1;
    }

    fread(key, 1, 3076, fkey);

    fclose(fkey);

    return 0;
}

#define TIMEOUT 3
int mqtt_read(Network* n, unsigned char* buffer, int len, int timeout_ms)
{
    int rxLen = 0;
    bool isErrorFlag = 0;
    bool isCompleteFlag = 0;
    int counter_timout = TIMEOUT - 1;

    //  mbedtls_ssl_conf_read_timeout(&conf, timeout_ms);
    do
    {
        ret = mbedtls_ssl_read(&ssl, buffer, len);
        if (ret > 0)
        {
            rxLen += ret;
        }
        else if(ret != MBEDTLS_ERR_SSL_WANT_READ)
        {
            mbedtls_strerror(ret,mbedtls_errorbuf,256);
            hlog_error("mbedtls_ssl_read error :%s", mbedtls_errorbuf);
            isErrorFlag = 1;
            mqtts_control(MQTTS_CMD_RESTART);
            porting_msleep(100);
            ret = 0;
            break;
        }
        if(rxLen >= len)
        {
            isCompleteFlag = 1;
            break;
        }
        porting_msleep(100);
        if(counter_timout-- <=0)
        {
            ret = 0;
            counter_timout = TIMEOUT;
            break;
        }
    }
    while(!isErrorFlag && !isCompleteFlag);

    return ret;
}

int mqtt_write(Network* n, unsigned char* buffer, int len, int timeout_ms)
{
    char strerr[64] = {0};

    int ret = mbedtls_ssl_write(&ssl, buffer, len);
    if(ret <= 0)
    {
        mbedtls_strerror(ret, strerr, sizeof(strerr));
        hlog_error("mqtt_write error code %d - %s", ret, strerr);
#if (SUPPORT_MQTT_IDLE ==1)
        if(check_network_connection(__FILE__,__FUNCTION__,__LINE__) == 0)
        {
            hlog_fatal(MBEDTLS_ANALYTICS_SPECIFIER"mqtt_write error %s", ANALYTICS_MQTT, MQTT_Running_publish,
                    ret,ANALYTICS_LOGSTATUS_ERROR,strerr);
        }
#endif
        mqtts_control(MQTTS_CMD_RESTART);
    }

    return ret;
}

void mqtt_disconnect(Network* n)
{
    ret = mbedtls_ssl_close_notify(&ssl);

    mbedtls_net_free(&server_fd);
    mbedtls_x509_crt_free(&clicert);
    mbedtls_x509_crt_free(&cacert);
    mbedtls_pk_free(&pkey);
    mbedtls_ssl_free(&ssl);
    mbedtls_ssl_config_free(&conf);
    mbedtls_ctr_drbg_free(&ctr_drbg);
    mbedtls_entropy_free(&entropy);
}

int NewNetwork(Network* network)
{
    int ret_val = 0;
    const char *pers = "cvisionhk";
#if defined(MBEDTLS_DEBUG_C)
    mbedtls_debug_set_threshold( DEBUG_LEVEL );
#endif
    // John: use standard malloc and free no need to use our own calloc free
    //    mbedtls_platform_set_calloc_free(porting_calloc, porting_free);

    /*
     * 0. Initialize the RNG and the session data
     */
    mbedtls_net_init(&server_fd);
    mbedtls_ssl_init(&ssl);
    mbedtls_ssl_config_init(&conf);
    mbedtls_x509_crt_init(&cacert);
    mbedtls_x509_crt_init(&clicert);
    mbedtls_pk_init(&pkey);
    mbedtls_ctr_drbg_init(&ctr_drbg);

    mbedtls_entropy_init(&entropy);
    if((ret_val = mbedtls_ctr_drbg_seed(&ctr_drbg, mbedtls_entropy_func, &entropy,
                    (const unsigned char *)pers,
                    strlen(pers))) != 0)
    {
        hlog_error("mbedtls_ctr_drbg_seed error %d", ret_val);
        return ret_val;
    }

    network->my_socket = 0;
    network->mqttread = mqtt_read;
    network->mqttwrite = mqtt_write;
    network->disconnect = mqtt_disconnect;

    return ret_val;
}

int ConnectNetwork(Network* network, char* url, int port)
{
    unsigned int ca_cert_len = 0;
    unsigned int client_crt_len = 0;
    unsigned int client_key_len = 0;
    struct timeval start_handshake , stop_handshake;
    char port_str[10] = {0};
    unsigned char ca_cert[3076];
    unsigned char client_cert[3076];
    unsigned char client_key[3076];
    int cipherSuitesID = 0;
    int nwk_retries = 0;
    //    int retry = 5;
    struct timeval timeout;
    timeout.tv_sec = MQTTS_SOCKET_TIMEOUT_SEC;
    timeout.tv_usec = MQTTS_SOCKET_TIMEOUT_MICROSECOND;

    memset(ca_cert, 0x00, sizeof(ca_cert));
    memset(client_cert, 0x00, sizeof(client_cert));
    memset(client_key, 0x00, sizeof(client_key));

    //Read certificates and private key from file
    if(getCertFromFile(ca_cert, client_cert, client_key) < 0)
    {
        // In case unable to read cert from file
        hlog_error("Unable to load certs; Use default certificates and private-key");
        memset(ca_cert, 0x00, sizeof(ca_cert));
        memset(client_cert, 0x00, sizeof(client_cert));
        memset(client_key, 0x00, sizeof(client_key));

        strcpy((char*)ca_cert, (char*)aws_rootCA);
        strcpy((char*)client_cert, (char*)aws_certificate);
        strcpy((char*)client_key, (char*)aws_private_key);
        return -1;
    }

    //Get length of certificates and private-key strings
    ca_cert_len = strlen((char*)ca_cert) + 1;
    client_crt_len = strlen((char*)client_cert) + 1;
    client_key_len = strlen((char*)client_key) + 1;

    sprintf(port_str, "%d", port);
    /*
     * 0. Initialize certificates
     */
    hlog_info("Loading the CA root certificate ...");
    hlog_debug("Root CA buffer (%d):\r\n%s\n", ca_cert_len, ca_cert);
    ret = mbedtls_x509_crt_parse(&cacert, (const unsigned char *)ca_cert, ca_cert_len);
    if(ret < 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("MBEDTLS error : '%s'",mbedtls_errorbuf);
        hlog_error("mqtt_init,connecting_to_server,failed,MBEDTLS error : %s", mbedtls_errorbuf);
        goto exit;
    }

    hlog_info("Loading the client cert. and key ...");
    hlog_debug("Client Cert buffer (%d):\r\n%s\n", client_crt_len, client_cert);
    ret = mbedtls_x509_crt_parse(&clicert, (const unsigned char *)client_cert, client_crt_len);
    if(ret < 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("mbedtls_x509_crt_parse error :%s", mbedtls_errorbuf);
        goto exit;
    }
    hlog_debug("Client Key buffer (%d):\r\n%s\n", client_key_len, client_key);
    ret = mbedtls_pk_parse_key(&pkey, (const unsigned char *)client_key, client_key_len, NULL, 0);
    if(ret < 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("mbedtls_pk_parse_key error :%s", mbedtls_errorbuf);
        goto exit;
    }
    hlog_info("Load certs and parse successfully");

    /*
     * 1. Start the connection
     */
    hlog_info("Connecting to tcp/%s/%s...",url, port_str);

    while((ret = mbedtls_net_connect(&server_fd, url,
                    port_str, MBEDTLS_NET_PROTO_TCP)) != 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("MBEDTLS error : '%s'",mbedtls_errorbuf);
#if (SUPPORT_MQTT_IDLE == 1)
        if(check_network_connection(__FILE__,__FUNCTION__,__LINE__) == 0)
        {
            hlog_error(ANALYTICS_SPECIFIER"mbedtls_net_connect: %s",ANALYTICS_MQTT,MQTT_initConnection_connectServer,
                    ret,ANALYTICS_LOGSTATUS_ERROR,mbedtls_errorbuf);
        }
#endif
        goto exit;
        //        retry = retry -1;
        //        if(retry <= 0)
        //            {
        //        	    return ret;
        //            }
        //        sleep(2);
    }
    if ((ret = setsockopt (server_fd.fd, SOL_SOCKET, SO_RCVTIMEO, (char *)&timeout, sizeof(timeout))) < 0)
    {
        hlog_error("setsockopt SO_RCVTIMEO error %d", ret);
    }
    if ((ret = setsockopt (server_fd.fd, SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout))) < 0)
    {
        hlog_error("setsockopt SO_RCVTIMEO error %d", ret);
    }

    /*
     * 2. Setup stuff
     */
    hlog_info("Setting up the SSL/TLS structure...");
    if((ret = mbedtls_ssl_config_defaults(&conf,
                    MBEDTLS_SSL_IS_CLIENT,
                    MBEDTLS_SSL_TRANSPORT_STREAM,
                    MBEDTLS_SSL_PRESET_DEFAULT)) != 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("mbedtls_ssl_config_defaults error : %s", mbedtls_errorbuf);
        goto exit;
    }

    //Add CipherSuites set up
    cipherSuitesID = mbedtls_ssl_get_ciphersuite_id(MBEDTLS_CIPHERSUITES);

    mbedtls_ssl_conf_ciphersuites(&conf, &cipherSuitesID);


    // VinhPQ: Set configuration minor to tls 1.2 (default tls 1.0)
    // mbedtls_ssl_conf_min_version (mbedtls_ssl_config *conf, int major, int minor)
    // Major: ssl3
    // Minor: 3: tls 1.2
    mbedtls_ssl_conf_min_version (&conf, 3, 3);

    // John move the Conf Read Timeout to 10s and right after the Net Connect and reset all config back to Normal
    mbedtls_ssl_conf_read_timeout(&conf, 10000);
    mbedtls_ssl_conf_verify(&conf, myCertVerify, NULL);

    /* OPTIONAL is not optimal for security,
     * but makes interop easier in this simplified example */
    mbedtls_ssl_conf_authmode(&conf, MBEDTLS_SSL_VERIFY_REQUIRED);
    mbedtls_ssl_conf_ca_chain(&conf, &cacert, NULL);
    mbedtls_ssl_conf_rng(&conf, mbedtls_ctr_drbg_random, &ctr_drbg);
    if((ret = mbedtls_ssl_conf_own_cert(&conf, &clicert, &pkey)) != 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("mbedtls_ssl_conf_own_cert error : %s", mbedtls_errorbuf);
        goto exit;
    }

    mbedtls_ssl_conf_dbg(&conf, my_debug, NULL);

    if((ret = mbedtls_ssl_setup(&ssl, &conf)) != 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("mbedtls_ssl_setup error : %s", mbedtls_errorbuf);
        goto exit;
    }
    if((ret = mbedtls_ssl_set_hostname(&ssl, url)) != 0)
    {
        mbedtls_strerror(ret,mbedtls_errorbuf,256);
        hlog_error("mbedtls_ssl_set_hostname error : %s", mbedtls_errorbuf);
        goto exit;
    }

    mbedtls_ssl_set_bio(&ssl, &server_fd, mbedtls_net_send, mbedtls_net_recv, NULL);
    /*
     * 4. Handshake
     */
    hlog_info("Performing the SSL/TLS handshake...");
    gettimeofday(&start_handshake, NULL);
    while((ret = mbedtls_ssl_handshake(&ssl)) != 0)
    {
#if (DEF_SERVER_CERT_VERIFICATION)                                              
        if( ret == MBEDTLS_ERR_X509_CERT_VERIFY_FAILED )                        
        {                                                                   
            hlog_error("Unable to verify the server's certificate. Abort Connection!!!!");          
            return -1;                                                          
        }                                                                   
#endif 
        if(ret != MBEDTLS_ERR_SSL_WANT_READ && ret != MBEDTLS_ERR_SSL_WANT_WRITE)
        {
            mbedtls_strerror(ret,mbedtls_errorbuf,256);
            hlog_error("mbedtls_ssl_handshake error : %s", mbedtls_errorbuf);
#if (SUPPORT_MQTT_IDLE == 1)
            if(check_network_connection(__FILE__,__FUNCTION__,__LINE__) == 0)
            {
                hlog_error("mbedtls_ssl_handshake error : %s", mbedtls_errorbuf);
            }
#endif
            hlog_error("mbedtls_ssl_handshake error : %s", mbedtls_errorbuf);
            goto exit;
        }
        hlog_info(" Handshaking ...");
        usleep(500000); // John add sleep to make sure the system not hang because of the loop
    }

    gettimeofday(&stop_handshake, NULL);

    /*
     * 5. Verify the server certificate
     */
    hlog_info("handshake time %lu us",(stop_handshake.tv_sec - start_handshake.tv_sec)*1000000L + stop_handshake.tv_usec - start_handshake.tv_usec);
    /* In real life, we probably want to bail out when ret != 0 */
    if((flags = mbedtls_ssl_get_verify_result(&ssl)) != 0)
    {
        char vrfy_buf[512] = {0};
        mbedtls_strerror(flags, mbedtls_errorbuf, 256);
        hlog_error("mbedtls_ssl_get_verify_result error %s", mbedtls_errorbuf);
        mbedtls_x509_crt_verify_info(vrfy_buf, sizeof(vrfy_buf), "  ! ", flags);
        hlog_error("mbedtls_x509_crt_verify_info: %s", vrfy_buf);
    }

    hlog_info("Ciphersuite: '%s'", mbedtls_ssl_get_ciphersuite(&ssl));

exit:
    if(ret != 0)
    {
        mbedtls_net_free(&server_fd);
        mbedtls_x509_crt_free(&cacert);
        mbedtls_x509_crt_free(&clicert);
        mbedtls_pk_free(&pkey);
        mbedtls_ssl_free(&ssl);
        mbedtls_ssl_config_free(&conf);
        mbedtls_ctr_drbg_free(&ctr_drbg);
        mbedtls_entropy_free(&entropy);
    }
    return ret;
}

void mqtt_set_non_block()
{
    mbedtls_net_set_nonblock(&server_fd);
}
