/*******************************************************************************
 * Copyright (c) 2014 Cvisionhk.
 *******************************************************************************/
#include "timer.h"
#include "time.h"
#include "hubble_log.h"
#include <time.h>
#ifdef PLATFORM_FREERTOS
#include "FreeRTOS.h"
#include "task.h"
#include "platform_autoconf.h"

#define TICKS_TO_MILLIS(ticks) ((ticks) * portTICK_RATE_MS)
#define MILLIS_TO_TICKS(millis) ((millis) / portTICK_RATE_MS)
#else
uint32_t timer_cnt;
#endif
static uint32_t get_current_ms();

char expired(Timer* timer)
    {
	char status = 0;
    uint32_t current_ms;
    current_ms = get_current_ms();

    if (timer->interval_end_ms >= timer->start_point_ms)
        {
        status= (current_ms > timer->interval_end_ms
                || current_ms < timer->start_point_ms)?1:0;
        }
    else
        {
        status = (current_ms < timer->interval_end_ms
                && current_ms > timer->start_point_ms)?1:0;
        }

//    if (status == 1)
//    {
//        hlog_info("current_ms: %d\n", current_ms);
//        hlog_info("timer->start_point_ms: %d\n", timer->start_point_ms);
//        hlog_info("timer->interval_end_ms: %d\n", timer->interval_end_ms);
//
//        hlog_info("Ofset1: %d\n", timer->interval_end_ms -timer->start_point_ms);
//
//        hlog_info("Ofset2: %d\n", current_ms -timer->start_point_ms);
//
//    }
    return status;
    }
void countdown_ms(Timer* timer, unsigned int timeout)
    {
    uint32_t current_ms;
    current_ms = get_current_ms();
    timer->start_point_ms = current_ms;
    timer->interval_end_ms = current_ms + timeout;
    }
void countdown(Timer* timer, unsigned int timeout)
    {
#ifdef PLATFORM_FREERTOS
    countdown_ms(timer, timeout*1000);
#else
    // should be countdown_ms(timer, timeout*1000);
    // This is just a workaround solution for cause incorrect timer
    countdown_ms(timer, timeout*1000);
#endif

    }
int left_ms(Timer* timer)
    {
    uint32_t current_ms;
    current_ms = get_current_ms();
    return (int32_t)(timer->interval_end_ms - current_ms);
    }
void InitTimer(Timer* timer)
    {
    timer->start_point_ms = 0;
    timer->interval_end_ms = 0;
    }
static uint32_t get_current_ms()
    {
#ifdef PLATFORM_FREERTOS
    return TICKS_TO_MILLIS(xTaskGetTickCount());
#else
    struct timespec tpstart;
    clock_gettime(CLOCK_MONOTONIC, &tpstart);
    timer_cnt = (tpstart.tv_sec * 1000) + (tpstart.tv_nsec / 1000000);
    return ++timer_cnt;
#endif
    }
