/*******************************************************************************
 * Copyright (c) 2012, 2013 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial contribution
 *    Ian Craggs - change delimiter option from char to string
 *    Al Stockdill-Mander - Version using the embedded C client
 *******************************************************************************/
#include <stdlib.h>
#ifdef WIN32
#include <windows.h> //for Sleep() command
#endif
#ifdef NRF51
#include "nrf_delay.h"
#include "boards.h"
#include "bsp.h"
#include "uart.h"
#include "gpio.h"
#include "gsm_utils.h"
#include "IR.h"
#include "IR1.h"
#endif
#include <stdio.h>
#include "MQTTClient.h"
#include "string.h"
#include "os_port.h"


#define TOPIC_PATTERN "dev/%s/%s"
#define MQTT_THREAD_SLEEPTIME 100 //ms
#define PUBLISH_TIMER 3
#define SUBSCRIBE_TIMER 1
#define KEEPALIVE_TIMER 10*(1000/MQTT_THREAD_SLEEPTIME) //30s

#define USE_PWM (1)
int stop_proccess = 0;
static int push_flag = 0;
static int push_code;

static int mqtt_enable = 1;
static int mqtt_continue = 1;



void client_id_generator(char *client_id)
    {
    sprintf(client_id, "linux-client-testtrg-subscribe");
    }
void device_topic_generator(char *topic)
    {
    if(topic)
        {
        sprintf(topic, "abc123");
        }
    }


int counter = 0;
void messageArrived(MessageData* md)
    {
    int led_state;
    int retry = 10;
    MQTTMessage* message = md->message;
    char *msg = (char *)message->payload;
    msg[message->payloadlen] = '\0';
    printf("messageArrived %d: '%s'\n", counter++, msg);
    }

void mqtt_control(int id)
    {
    switch(id)
        {
        case 0://off
            mqtt_enable = 0;
            mqtt_continue = 0;
            break;
        case 1://on
            mqtt_enable = 1;
            mqtt_continue = 1;
            break;
        case 2://restart
            mqtt_enable = 1;
            mqtt_continue = 0;
            break;
        }
    }
#define DEBUG
#undef MQTT_SERVER
#undef MQTT_PORT
//#define MQTT_SERVER "data.iot.us-east-1.amazonaws.com"
#define MQTT_SERVER "mqtt-dev-iot.hubble.in"
#define MQTT_PORT 8883
//#define MQTT_PORT 1888
#define SUBSCRIBE_SUPPORT
#define KAL_SUPPORT
//#define PUBLISH_SUPPORT
void main()
    {
    int rc = 0;
    int i = 0;
    unsigned char buf[530];
    unsigned char readbuf[530];
    char topicname_pub[32] = {0};
    char topicname_sub[32] = {0};
    int retries;
    int counter_publish = 0;
    int counter_keepalive = 0;
    int counter_subscribe  = 0;

    struct Network n;
    Client c;

    char client_id[120] = {0};
    char topic_id[120]  = {0};

    client_id_generator(client_id);
    device_topic_generator(topic_id);
    printf("client id: %s\n", client_id);
    while(1)
        {
        if(mqtt_enable)
            {
            printf("MQTT START\n");
            mqtt_continue = 1;
            NewNetwork(&n);
            while(ConnectNetwork(&n, MQTT_SERVER, MQTT_PORT)<0)
                {
                printf("Fail to connect to tcp/%s/%d\n\r", MQTT_SERVER, MQTT_PORT);
                //while(1);
                }

            MQTTClient(&c, &n, 1000, buf, 100, readbuf, 100);

            MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
            data.willFlag = 0;

            data.clientID.cstring = client_id;
            data.username.cstring = NULL;
            data.password.cstring = NULL;

            data.keepAliveInterval = 60;
            data.cleansession = 1;
#ifdef DEBUG
            printf("\nConnecting to %s %d\n", MQTT_SERVER, MQTT_PORT);
#endif
            data.MQTTVersion = 3;
            rc = MQTTConnect(&c, &data);
#ifdef DEBUG
            printf("Connected %d\n", rc);
#endif
#if 0
            sprintf(topicname_pub, TOPIC_PATTERN, topic_id, "pub");
            sprintf(topicname_sub, TOPIC_PATTERN, topic_id, "sub");
#endif
            sprintf(topicname_pub, "trung/pub");
            sprintf(topicname_sub, "trung/sub");
            printf("Subcribe topic: %s\n", topicname_sub);
            printf("Publish topic: %s\n", topicname_pub);
#ifdef SUBSCRIBE_SUPPORT
            rc = MQTTSubscribe(&c, topicname_sub, QOS1, messageArrived);
#endif
            printf("Init done\n");
            mqtt_set_non_block();
            while(mqtt_continue)
                {
#ifdef SUBSCRIBE_SUPPORT
                if(counter_subscribe++ >= SUBSCRIBE_TIMER)
                    {
                    //printf("subscribe\n");
                    retries = 1;
                    MQTTYield(&c, 1000);
                    counter_subscribe = 1;
                    }
#endif
#ifdef KAL_SUPPORT
                if(counter_keepalive++ >= KEEPALIVE_TIMER)
                    {
                    printf("KAL\n");
                    keepalive(&c);
                    counter_keepalive = 1;
                    }
#endif
#ifdef PUBLISH_SUPPORT
                if(counter_publish++ >= PUBLISH_TIMER)
                    {
                    int rc;
                    MQTTMessage message;
                    char msg_payload[100] = "hello hoangphuc";
                    message.qos = QOS1;
                    message.id = counter_publish;
                    message.payloadlen = strlen(msg_payload);
                    message.payload = (void *)&msg_payload;
                    rc = MQTTPublish(&c, topicname_pub, &message);
                    counter_publish = 1;
                    printf("Publish  %d\n", rc);
                    }
#endif

                porting_msleep(MQTT_THREAD_SLEEPTIME);

                }// end while stop_process
            printf("Stopping\n");
            printf("MQTT STOP\n");
            MQTTDisconnect(&c);
            n.disconnect(&n);
            }
        else // end if motion_enable
            {
            porting_msleep(1000);
            }
        }// end while(1)


    }


