#ifndef __MQTTS_H_
#define __MQTTS_H_

#define MQTT_BUF_SIZE 2048
#define MQTT_READBUF_SIZE 2048
#define MQTT_CLIENTID_LENGTH 65

#define MQTT_TOPIC_LENGTH 65
#define MAX_SUB_TOPIC_SUPPORT 8

#define DEBUG
//#define MQTTS_SERVER "mqtt-dev-iot.hubble.in"
#define MQTTS_SERVER "mqtt-iot.hubble.in"
//#define MQTTS_PORT 1883
#define MQTTS_PORT 8883

enum
    {
    MQTTS_CMD_START = 0,
    MQTTS_CMD_STOP,
    MQTTS_CMD_RESTART
    };

typedef int (*CALLBACKHANDLER)(char *topic, char *msg, int len);
typedef void *(*MQTT_MALLOC)(size_t len);
typedef void (*MQTT_FREE)(void *in);
typedef void (*MQTT_LOGGER)(const char *format, ...);

// need to call all fucntion bellow to fill enough infomation before call main_mqtts()
int mqtts_set_clientid(char *clientid);

int mqtts_set_callbackhandler(CALLBACKHANDLER handler_func);
int mqtts_set_malloc(MQTT_MALLOC malloc_func);
int mqtts_set_free(MQTT_FREE free_func);
int mqtts_set_logger(MQTT_LOGGER logger_func);
/////////////////////////////////////////////////////////

// main mqtts loop
//int mqtts_init(char *host, int port, char *username, char *password);
int mqtts_init_new(char *host, int port);
int mqtts_subscribe(char *topic);
int mqtts_unsubscribe(char *topic);
void mqtts_control(int id);// 0: off, 1: on, 2: restart. Default is on

void mqtts_main();
int mqtts_publish(char *topic, char *msg);
void messageHandle();
void *mqtts_handle_thread ();
void *mqtts_handle_multi_cmd_thread();

int getStatusHandleUSR1();
void setStatusHandleUSR1(int status);
int mqtts_publish_1(char *topic, uint8_t *msg,int len);
#endif
