#ifndef _MD5_H
#define _MD5_H

/* Any 32-bit or wider unsigned integer data type will do */
typedef unsigned int MD5_u32plus;

typedef struct
    {
    MD5_u32plus lo, hi;
    MD5_u32plus a, b, c, d;
    unsigned char buffer[64];
    MD5_u32plus block[16];
    } MD5_CTX;
/*
 * PURPOSE : Do MD5 a file
 * INPUT   : [fileName]   - File name
 *           [bufferSize] - Output buffer size
 * OUTPUT  : [buffer]     - Buffer store result hex string
 * RETURN  : 0 if success
 * DESCRIPT: The check sum will be printed as hex string
 */
int
MD5FileCheckSum(char* fileName, void* buffer, int bufferSize);

/*
 * PURPOSE : Do MD5 a buffer
 * INPUT   : [inBuf]   - Input buffer
 *           [inSize]  - Input buffer size
 *           [outSize] - Output buffer size
 * OUTPUT  : [outBuf]  - Buffer store result hex string
 * RETURN  : 0 if success
 * DESCRIPT: The check sum will be printed as hex string
 */
int
MD5BufferCheckSum(void* inBuf, int inSize, void* outBuf, int outSize);

#endif
