#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <signal.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <getopt.h>
#include <pthread.h>
#include <dlfcn.h>
#include <fcntl.h>
#include "hubble_log.h"
#include <stdarg.h>
#include <net/if.h>
#include <dirent.h>
#include "curl/curl.h"
#include <sys/wait.h>
#include "hubble_log.h"
#include "md5.h"
#include "time.h"
#include <stdio.h>
#include "mqtts.h"
#include "mbedtls/aes.h"
#include <stdint.h>
#include "json_api.h"
#include "jsmn.h"
#include "mbedtls/md5.h"
#include <sys/sysinfo.h>


//#if (CAMSDK_BUILT == 0)
#include "hubble_config.h"
#include "pcwrapper.h"
//#endif

#define CVISION_MQTTS_APP_NAME "mqtts_client"

//#if (CAMSDK_BUILT == 1)
//#include "fwpath.h"
//#include "nvconf.h"
//#include "cvappname.h"
//#endif

#define MAX_TOKEN               64
#define URL_BUFFER_SIZE         2048
#define CA_BUFFER_SIZE          2048 * 3
#define NUMBER_OF_FILE          3
#define MAX_WAIT_MSECS 30*1000 /* Wait max. 30 seconds */
#define JSON_TOKEN_STATUS       "status"
#define JSON_TOKEN_DATA         "data"
#define JSON_TOKEN_MQTT_CERT    "mqtt_certificates"
#define JSON_TOKEN_CA_CRT       "ca_crt"
#define JSON_TOKEN_CLIENT_CRT   "client_crt"
#define JSON_TOKEN_CLIENT_KEY   "client_key"
static char *cert_list[NUMBER_OF_FILE] = {
    JSON_TOKEN_CA_CRT,
    JSON_TOKEN_CLIENT_CRT,
    JSON_TOKEN_CLIENT_KEY
};
# define MD5_DIGEST_LENGTH 16
#define MD5_SUM_LENGTH 32
#define CA_FILE_ID              0
#define CLIENT_CERT_FILE_ID     1
#define CLIENT_KEY_FILE_ID      2
#define SUB_TOPIC_FILE_ID       3
#define PUB_TOPIC_FILE_ID       4
static int ID_list[NUMBER_OF_FILE] = {
    CA_FILE_ID,
    CLIENT_CERT_FILE_ID,
    CLIENT_KEY_FILE_ID
};
#if 0
#define GET_QUERY_DC                "v1/devices/config_details.json?device_token=%s"
#define GET_REQUEST_BODY            "GET /%s HTTP/1.1\r\n"\
    "HOST: %s\r\n"\
    "Accept: application/json\r\n"\
    "Accept-encoding: gzip, deflate\r\n"\
    "Accept-Language: en-US,en;q=0.8\r\n"\
    "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\r\n\r\n"
#define GET_REQUEST_BODY1           "GET /%s HTTP/1.1\r\n"\
    "HOST: %s\r\n"\
    "Connection: keep-alive\r\n" \
    "Content-Length: %d\r\n" \
    "Cache-Control: max-age=0\r\n" \
    "Origin: null\r\n" \
    "User-Agent: %s/%s\r\n" \
    "Content-Type: application/json\r\n" \
    "\r\n"
#else
#define GET_DC_REQUEST_QUERY        "GET /v1/devices/config_details.json?device_token=%s HTTP/1.1\r\n"\
    "HOST: %s\r\n"\
    "Connection: keep-alive\r\n" \
    "Content-Length: %d\r\n" \
    "Cache-Control: max-age=0\r\n" \
    "Origin: null\r\n" \
    "User-Agent: %s/%s\r\n" \
    "Content-Type: application/json\r\n" \
    "\r\n"
#endif

#define APP_TOPIC_KEY           "app_topic_sub"
#define TIME_KEY                "time"
#define MQTT_RESPONSE_FORMAT    "3id: %s&time: %s&%s"


#include "pb_encode.h"
#include "pb_decode.h"
#include "iot_packet.pb.h"
#define DEFAULT_SERVER              "cs.hubble.in"
//#include "nxcHubbleAPI.h"

#define JSON_TOKEN_SUB_TOPIC    "subscribe_topic"
#define JSON_TOKEN_PUB_TOPIC    "publish_topic"

#define FIRMWARE_CONFIG_PATH   "/"
#define STD_GET_QUERY_MQTT          "GET /v5/devices/mqtt_server_info.json?%s HTTP/1.1\r\n" \
    "Host: %s\r\n"
#define STD_GET_HEADER              "Connection: keep-alive\r\n" \
    "User-Agent: Camera\r\n" \
    "Content-Length: %d\r\n" \
    "Content-Type: text/plain\r\n" \
    "\r\n"
#define STD_HEADER2                 "Connection: keep-alive\r\n" \
    "Content-Length: %d\r\n" \
    "Cache-Control: max-age=0\r\n" \
    "Origin: null\r\n" \
    "User-Agent: %s/%s\r\n" \
    "Content-Type: application/json\r\n" \
    "\r\n"
#define ERROR_OK                0
#define ERROR_UNKNOWN           -1
#define ERROR_NOT_FOUND         -2

#define SKIP_DOWNLOAD_CERT      -3
#define MQTTS_VER_STRING        "v2.0"

#define CA_CERT_NAME "ca_cert_md5 = "
#define CLIENT_CERT_NAME "client_cert_md5 = "
#define CLIENT_KEY_NAME "client_key_md5 = "


char remountReadWriteCmd[128] = {0};
char remountReadOnlyCmd[128] = {0};

static char topic_sub[65] = {0};
static char topic_pub[65] = {0};
static pthread_t mqttsSetCmdHandler;
static pthread_t mqttsGetCmdHandler;
static char checksumSV[32] = {0} ;
static char pub_topic_url[65] = {0};
static char sub_topic_url[65] = {0};
FILE *fp;
char* checksum ;
#define _DEBUG_NOTICE

static char downloadcertfile_header_md5sum[3][33];
char certs_error_buffer[3][512];
static char certURLList[3][2048];
static char certPathList[3][256];
FILE *CACert = NULL;
FILE *clientCert = NULL;
FILE *clientKey = NULL;

#define MQTT_PUB_TOPIC                      "publish_topic"
#define MQTT_SUB_TOPIC                      "subscribe_topic"
#define MQTT_SERVER_URI                     "mqtt_server_uri"

int mqtt_process_command(char *topic, char *msg, int len)
{
    int return_code = 0;
    hlog_info("mqtts_publish_1 topic: %s, len: %d",topic_pub,len);
    return_code = mqtts_publish_1(topic_pub,msg,len);
    if(return_code != 0)
    {
        hlog_error("Failed to publish packet %d",return_code);
    }
    return return_code;
}

void client_id_generator(char *client_id)
{
    if(client_id)
    {
        nxcNetworkGetMacAddr(client_id);
    }
}
#if 0
int device_topic_generator_sub(char *topic)
{
    FILE *sub;
    if(topic)
    {
        sub = fopen(CLIENT_SUB_TOPIC, "r");
        if(sub == NULL)
        {
            return -1;
        }
        fread(topic, 1, 65, sub);
        fclose(sub);
    }
    return 0;
}
int device_topic_generator_pub(char *topic)
{
    FILE * pub;
    if(topic)
    {
        pub = fopen(CLIENT_PUB_TOPIC, "r");
        if(pub == NULL)
        {
            return -1;
        }
        fread(topic, 1, 65, pub);
        fclose(pub);
    }
    return 0;
}
#endif
static int getUDID(char *UDID)
{
    int iRetries = 10;
    if(nvram_param_read(NVCONF_UDID, UDID) < 0)
    {
        while((nxcNetworkGetUDID(UDID) != 0) && (iRetries >= 0))
        {
            iRetries--;
            sleep(3);
            hlog_error("Generated UDID as internal function failure %d",iRetries);
        }
    }
    if(iRetries < 0)
        return -1;
    return 0;
}
int device_topic_generator_sub(char *topic)
{
    // Self-generate sub_topic
    int ret = 0;
    char UDID[32];
    if(nvram_param_read(NVCONF_MQTT_SUB_TOPIC,topic) == 0)
    {
        hlog_info("Got subscribe topic '%s' from NVCONF",topic);
        return 0;
    }
    else if(getUDID(UDID) == 0)
    {
        sprintf(topic,"%s%s","/v1/devices/",UDID);
        nvram_param_write1(NVCONF_MQTT_SUB_TOPIC,topic);
        return 0;
    }
    return -1;
}
int device_topic_generator_pub(char *topic)
{
    // Self-generate pub_topic
    int ret = 0;
    char UDID[32];
    if(nvram_param_read(NVCONF_MQTT_PUB_TOPIC,topic) == 0)
    {
        hlog_info("Got publish topic '%s' from NVCONF",topic);
        return 0;
    }
    else if(getUDID(UDID) == 0)
    {
        sprintf(topic,"%s%s","/v1/server/devices/",UDID);
        nvram_param_write1(NVCONF_MQTT_PUB_TOPIC,topic);
        return 0;
    }
    return -1;
}
static char header_analytics[256];
static void init_header_analytics_log()
{
    char cModel[8] = {0};
    char firmware_version[16]  = {0};
    char strUDID[27] = {0};
    //NUVOTON compatible
    nxcNetworkGetUDID(strUDID);
    nvram_param_read(NVCONF_MODEL, cModel);
    nvram_param_read(NVCONF_FW_VERSION, firmware_version);
    sprintf(header_analytics, "mqtt1,model=%s,udid=%s,version=%s",cModel,strUDID,firmware_version);
}

typedef enum eMQTTSStatus
{
    eMQTTSCheckCert = 0,
    eMQTTSTakeCert,
    eMQTTSTakeLinkServer,
    eMQTTSInitMQTTS,
    eMQTTSRunMQTTS,
}eMQTTSStatus;
eMQTTSStatus   MQTTSStatus = eMQTTSCheckCert;

    static int
parse_mqtt_server_url(char *sURL, char *sMQTTSServer, int *iMQTTSPort)
{
    char *pStrOne = NULL;
    char *pStrTwo = NULL;
    char *pURLHead = "ssl://";
    char sMQTTSPort[8] = {0};

    //Parse the server
    pStrOne = strstr(sURL, pURLHead);
    if(pStrOne == NULL)
        return -1;

    pStrOne += strlen(pURLHead);

    //Parse the port
    pStrTwo = strchr(pStrOne, ':');
    if(pStrTwo == NULL)
        return -1;
    *pStrTwo = 0x00;
    pStrTwo += sizeof(char);

    //Get the parsed result
    sprintf(sMQTTSServer, "%s", pStrOne);
    hlog_info("Got MQTTS server: %s", sMQTTSServer);
    sprintf(sMQTTSPort, "%s", pStrTwo);
    *iMQTTSPort = atoi(sMQTTSPort);
    hlog_info("Got MQTTS port: %d", *iMQTTSPort);
    if(*iMQTTSPort == 0)
        return -1;
    return 0;
}
    static int
proc_find(const char* name, int *procId, int exclude_id)
{
    DIR             *dir;
    struct dirent   *ent;
    char            buf[512];
    long            pid;
    char            pname[100] = {0};
    char            state;
    FILE            *fp = NULL;

    if(!(dir = opendir("/proc")))
    {
        perror("can't open /proc");
        return 0;
    }

    while((ent = readdir(dir)) != NULL)
    {
        long lpid = atol(ent->d_name);
        if(lpid < 0)
            continue;
        if(lpid == exclude_id)
            continue;
        snprintf(buf, sizeof(buf), "/proc/%ld/stat", lpid);
        fp = fopen(buf, "r");
        if(fp)
        {
            if((fscanf(fp, "%ld (%[^)]) %c", &pid, pname, &state)) != 3)
            {
                printf("fscanf failed \n");
                fclose(fp);
                closedir(dir);
                return 0;
            }
            if(!strcmp(pname, name))
            {
                if(procId)
                    *procId = pid;

                fclose(fp);
                closedir(dir);
                return 1;
            }
            fclose(fp);
        }
    }
    closedir(dir);
    return 0;
}


// Need to confirm system year before starting up
static int mqtts_check_system_year()
{
    time_t t;
    struct tm *now;
    while(1)
    {
        // get current time now
        t = time(0);
        now = localtime(&t);
        if((now->tm_year + 1900) > 2016)
            break;
        else
        {
            hlog_debug("Current year %d", now->tm_year + 1900);
            sleep(3);
        }
    }
    return 0;
}
static int compareMD5Sum(char *filePath,char *md5SumStored, char *md5_name, char *value)
{
    char *temp_pointer = NULL;
    char calculatedMD5Sum[33] = {0};
    if(access(filePath,R_OK) != 0 )
    {
        hlog_error("Unable to read file '%s'",filePath);
        return -1;
    }
    // Strip MD5 sum and pass to value
    temp_pointer = strstr(md5SumStored,md5_name);
    if(temp_pointer == NULL)
    {
        hlog_error("Unable to find key: '%s'",md5_name);
        return -1;
    }
    hlog_debug("Temp ptr: '%s'",temp_pointer);
    strncpy(value,temp_pointer + strlen(md5_name),MD5_SUM_LENGTH);
    value[MD5_SUM_LENGTH] = '\0';
    hlog_debug("Got MD5Sum: '%s' from '%s'",value,md5_name);

    // Get MD5 sum of existing file
    MD5FileCheckSum(filePath, calculatedMD5Sum, MD5_SUM_LENGTH);
    hlog_debug("MD5 Sum calculated : '%s'",calculatedMD5Sum);

    // Compare to see if exisint file is valid
    if (strncmp(value,calculatedMD5Sum,MD5_SUM_LENGTH) == 0)
        hlog_info("CertFile's MD5Sum Matched\n");
    else
    {
        hlog_error("Error!!! CertFile's MD5Sum doesn't matched\n");
        return -1;
    }
    return 0;
}
static int check_existing_file_md5Sum(char *md5Text)
{
    int return_code = 0;
    char temp_md5Sum[33] = {0};
    // CA_CERT
    return_code = compareMD5Sum(STORED_CA_FILE, md5Text, CA_CERT_NAME, temp_md5Sum);
    if (return_code == -1)
    {
        hlog_error("The file at path '%s' isn't valid",CA_FILE);
        return return_code;
    }
    // CLIENT_CERT
    return_code = compareMD5Sum(STORED_CLIENT_CERT_FILE,md5Text,CLIENT_CERT_NAME,temp_md5Sum);
    if (return_code == -1)
    {
        hlog_error("The file at path '%s' isn't valid",CLIENT_CERT_FILE);
        return return_code;
    }
    // CLIENT_KEY
    return_code = compareMD5Sum(STORED_CLIENT_KEY_FILE,md5Text,CLIENT_KEY_NAME,temp_md5Sum);
    if (return_code == -1)
    {
        hlog_error("The file at path '%s' isn't valid",CLIENT_KEY_FILE);
        return return_code;
    }
    return return_code;
}
#define FAIL_CNT_BEFORE_GETTING_SERVER_LINK 10

/**
  @brief Write process id of mqtts process with whether status online
  */
static void write_pid_process()
{
    int status_MQTTs = 0;
    FILE *fMQTTPID = NULL;
    char cmd[64] = {0};

    if(MQTTSStatus == eMQTTSRunMQTTS)
    {
        status_MQTTs = 1;
    }

    fMQTTPID = fopen("/tmp/mqtts.pid", "w");
    if(fMQTTPID)
    {
        flock(fileno(fMQTTPID), LOCK_EX | LOCK_NB);
        sprintf(cmd, "%u %d", getpid(), status_MQTTs);
        fwrite(cmd, strlen(cmd), sizeof(char), fMQTTPID);
        fflush(fMQTTPID);
        flock(fileno(fMQTTPID), LOCK_UN);
        fclose(fMQTTPID);
    }
    else
    {
        sprintf(cmd, "echo '%u %d' > /tmp/mqtts.pid", getpid(), status_MQTTs);
        system(cmd);
    }
}

int main(int argc, char** argv)
{
#if 1 //def SUPPORT_MQTTS
    int ret =  -1;
    int iMQTTSPort = 0;
    int iMQTTInfoReady = 0;
    int takeMQTTserver_fail = 3;
    int iMQTTCertFail = 0;
    int number_token = 0;
    int rc = 0;
    int i32ConnectMQTTServerFailTime = 0;
    int getServerURI = 0;
    char sURL[256] = {0};
    char cmd[64] = {0};
    char client_id[32] = {0};
    char device_topic_pub[65] = {0};
    char device_topic_sub[65] = {0};
    char server_name[128]= {0};
    char sAuthToken[64] = {0};
    char response[1024*8] = {0};
    char sMQTTSServer[128] = {0};
    char * strSearch = "mqtt_uri";
    char *p_js_data;

    // Add variable to store MD5Sum load from file
    FILE *md5File = NULL;
    char certs_topic_md5Sum[512] = {0};
    int md5Sum_check;

    struct timeval stop, start, startProc, stopProc;
    jsmntok_t token[64];


    int procId = 0;
    int  cur_task_id = getpid();

    hlog_open("[MQTT]");
    //if(rc)
    //    printf("syslog init failed\n");
    hlog_info("%s %s start", CVISION_MQTTS_APP_NAME, MQTTS_VER_STRING);
    hlog_info("Current Task ID %d", cur_task_id);
    hlog_info("______________________________________MQTTs Started_____________________________________");
#ifndef PC_BUILT
    // Only run for Embedded
    do
    {
        procId = 0;
        proc_find(CVISION_MQTTS_APP_NAME, &procId, cur_task_id);
        if(procId > 0)
        {
            sprintf(cmd, "kill -9 %d", procId);
            hlog_info("Kill mqtts_client task_id %d return %d", procId, system(cmd));
        }
        usleep(100000);
    }while(procId != 0);
#endif

    write_pid_process();


    // VinhPQ: Delay startup mqtt until ntp had been received
    mqtts_check_system_year();

#ifdef _DEBUG_NOTICE
    init_header_analytics_log();
#endif


    //Read the master key
    while(nvram_param_read(NVCONF_MASTER_KEY, sAuthToken) < 0)
    {
        sleep(1);
    }

    //Start the relay thread
    //This thread will wait until the first command come from server
    pthread_create(&mqttsSetCmdHandler, NULL, &mqtts_handle_thread, NULL);
    pthread_create(&mqttsGetCmdHandler, NULL, &mqtts_handle_multi_cmd_thread, NULL);
    // Set remount command
    sprintf(remountReadWriteCmd,"mount -o remount, rw %s",STORED_CERTS_PATH);
    sprintf(remountReadOnlyCmd,"mount -o remount, ro %s",STORED_CERTS_PATH);
#if (CAMSDK_BUILT == 1 || SD_FLASH_SUPPORT == 1 || SPI_FLASH_SUPPORT == 1)
    // skip checking md5Sum for model has read only mechanism to protect certs files
    MQTTSStatus = eMQTTSTakeCert;
#endif
    while(1)
    {
        switch(MQTTSStatus)
        {
            case eMQTTSCheckCert:
                hlog_info("*****************************Start checking Certs**********************************\n");
                gettimeofday(&startProc, NULL);
                // Read stored MD5 Sum
                md5File = fopen(CERT_MD5SUM_FILE,"r");
                if(md5File == NULL)
                {
                    hlog_error("MD5Sum File couldn't be found, proceed to downloading Certs");
                    goto clear_certs;
                }
                fread(certs_topic_md5Sum,1,512,md5File);
                hlog_info("Read md5File successfully, start checking for MD5 Sum'%s'",certs_topic_md5Sum);
                fclose(md5File);

                // Check if existing file's MD5 Sum matches with MD5 Sum stored in file.
                hlog_info("Check if existing certs file is valid");
                md5Sum_check = check_existing_file_md5Sum(certs_topic_md5Sum);
                if(md5Sum_check != 0)
                {
                    goto clear_certs;
                }
                else
                {
                    hlog_info("Existing file is valid");
                    // Generating pub/sub topic here
                    MQTTSStatus = eMQTTSTakeCert;
                    break;
                }
clear_certs:
                hlog_error("Clearing all Certs, pub/sub topic and proceed to downloading Certs");
                //Clean all the old things

                unlink(STORED_CA_FILE);
                unlink(STORED_CLIENT_CERT_FILE);
                unlink(STORED_CLIENT_KEY_FILE);

                unlink(CA_FILE);
                unlink(CLIENT_CERT_FILE);
                unlink(CLIENT_KEY_FILE);
                unlink(CLIENT_SUB_TOPIC);
                unlink(CLIENT_PUB_TOPIC);

                sync();
                MQTTSStatus = eMQTTSTakeCert;
                break;

            case eMQTTSTakeCert:
                while(1)
                {
                    hlog_info("*********************************Start downloading Certs********************\n");
                    gettimeofday(&start, NULL);
                    /* take 3 certificates file, subscribe and publish topics */
                    ret = get_mqtts_certificate_new(sAuthToken);
                    if(ret < 0)
                    {
#ifdef _DEBUG_NOTICE
#endif
                        iMQTTCertFail++;
                        if(iMQTTCertFail > 3)
                        {
                            hlog_error("Download certificates failed more than 3 times. So, exit!");
                            return -1;
                        }

                        usleep(100000);
                        continue;
                    }
                    else
                    {
                        iMQTTCertFail = 0;
                    }
                    break;
                }

                MQTTSStatus = eMQTTSTakeLinkServer;
                gettimeofday(&stop, NULL);
                hlog_debug("_________________________Downloading Certs Process took %lu__________________________ ",
                        (stop.tv_sec - start.tv_sec)*1000000L+stop.tv_usec - start.tv_usec);
                break;

            case eMQTTSTakeLinkServer:
#if 0 // VinhPQ: Temporary closing all skiping for getting mqtt server until it is safe to do so
                if(iMQTTInfoReady > 0)
                {
                    MQTTSStatus = eMQTTSInitMQTTS;
                    break;
                }
#else
                i32ConnectMQTTServerFailTime = 0;
#endif
                hlog_info("*********************************Start getting MQTT Server's URL********************\n");\
                    while(1)
                    {
                        memset(response, 0, sizeof(response));
                        gettimeofday(&start,NULL);
                        if (getServerURI == 0)
                        {
                            // Read Server's URI from config
                            if(nvram_param_read(NVCONF_MQTT_SERVER_URI,response) == 0)
                            {
                                hlog_info("Got MQTT Server URL from NVCONFIG '%s'",response);
                                // Get MQTT server
                                if(parse_mqtt_server_url(response, sMQTTSServer, &iMQTTSPort) < 0)
                                {
                                    hlog_error("MQTT Server URI's format is incorrect. Re-download server URI");
                                    sleep(3);
                                    getServerURI = 1;
                                    continue;
                                }
                                MQTTSStatus = eMQTTSInitMQTTS;
                                break;
                            }
                        }
                        // Get MQTT Server URI from server
                        rc = nxcHubbleMQTTbroker(server_name, 443, sAuthToken, response, 1024);
                        if(rc != 200)
                        {
#ifdef _DEBUG_NOTICE
#endif
                            if(takeMQTTserver_fail > 0)
                            {
                                takeMQTTserver_fail = takeMQTTserver_fail - 1;
                                sleep(3);
                                continue;
                            }
                            else
                            {
                                takeMQTTserver_fail = 3;
                                sleep(60);
                                continue;
                            }
                        }
                        else
                        {
                            p_js_data = strchr(response, '{');
                            if(p_js_data == NULL)
                            {
                                sleep(3);
                                hlog_info("Response is wrong format\n");
                                continue;
                            }
                            number_token = parser_json_response(p_js_data, strlen(p_js_data), token, sizeof(token) / sizeof(token[0]));
                            if(number_token <= 0)
                            {
                                sleep(3);
                                hlog_info("Response is wrong format\n");
                                continue;
                            }

                            if(get_token_value(p_js_data, strlen(p_js_data), token, number_token, strSearch, sURL, sizeof(sURL)) > 0)
                            {
                                if(parse_mqtt_server_url(sURL, sMQTTSServer, &iMQTTSPort) < 0)
                                {
                                    hlog_info("Response is incorrect");
                                    sleep(3);
                                    continue;
                                }
                            }
                            else
                            {
                                hlog_info("Response doesn't contain mqtt_uri");
                                sleep(3);
                                continue;
                            }

                            iMQTTInfoReady = 1; // Only get one time after MQTTS start up

                            MQTTSStatus = eMQTTSInitMQTTS;
                            break;
                        }
                        // Write new MQTT Server URL to NVCONF
                        if(nvram_param_write1(NVCONF_MQTT_SERVER_URI,response) == 0)
                        {
                            hlog_info("Write new MQTT Server '%s' to NVCONF",response);
                            getServerURI = 0;
                        }
                        gettimeofday(&stop,NULL);
                        hlog_debug("_________________________Downloading Server's URL took %lu__________________________ ",
                                (stop.tv_sec - start.tv_sec)*1000000L+stop.tv_usec - start.tv_usec);
                    }
                break;

            case eMQTTSInitMQTTS :
                hlog_info("****************************Start Init MQTT Client*************************** \n");
                client_id_generator(client_id);
                if(device_topic_generator_pub(device_topic_pub) < 0)
                {
                    hlog_info("Cannot get public topic\n");
                    MQTTSStatus = eMQTTSTakeCert;
                    break;
                }

                if(device_topic_generator_sub(device_topic_sub) < 0)
                {
                    hlog_info("Cannot get subscribe topic\n");
                    MQTTSStatus = eMQTTSTakeCert;
                    break;
                }

                sprintf(topic_sub, "%s", device_topic_sub);
                sprintf(topic_pub, "%s", device_topic_pub);

                hlog_info("set all MQTTS items\n");
                hlog_info("topic_sub: %s", topic_sub);
                hlog_info("topic_pub: %s", topic_pub);

                mqtts_set_clientid(client_id);
                mqtts_set_callbackhandler(&mqtt_process_command);
                mqtts_set_malloc(&malloc);
                mqtts_set_free(&free);

                hlog_info("Start the MQTT thread\n");
                gettimeofday(&start,NULL);
                hlog_info("Init MQTT to server: %s:%d",sMQTTSServer,iMQTTSPort);
                ret = mqtts_init(sMQTTSServer, iMQTTSPort, client_id, sAuthToken);
                gettimeofday(&stop,NULL);
                hlog_debug("_________________________MQTTS Init took %lu__________________________ ",
                        (stop.tv_sec - start.tv_sec)*1000000L+stop.tv_usec - start.tv_usec);
                if(ret < 0)
                {
#ifdef _DEBUG_NOTICE
#endif
                    hlog_error("Init MQTTS failed \n");
                    i32ConnectMQTTServerFailTime++;
                    // Re-download server URI incase the URI has changed.
                    getServerURI = 1;
                    // Don't need to Re-download Certs In Case MQTTConnect() failed. Re-download Certs in others cases.
                    if (ret != SKIP_DOWNLOAD_CERT)
                    {
                        MQTTSStatus = eMQTTSTakeCert;
                    }
                    // Connect fail 10 times, re-getting server link (backup solution)
                    else if(i32ConnectMQTTServerFailTime >= FAIL_CNT_BEFORE_GETTING_SERVER_LINK)
                    {
                        MQTTSStatus = eMQTTSTakeLinkServer;
                        hlog_error("Failed connecting %d times to server %s, get new link", FAIL_CNT_BEFORE_GETTING_SERVER_LINK, sMQTTSServer);
                    }
                    else
                    {
                        usleep(100000);
                    }
                    break;
                }

                i32ConnectMQTTServerFailTime = 0;

                mqtts_start_state();
                mqtts_reset_topic_array();
                gettimeofday(&start,NULL);
                if(mqtts_subscribe(topic_sub) < 0)
                {
#ifdef _DEBUG_NOTICE
#endif
                    hlog_error("Subscribe failed");
                    MQTTSStatus = eMQTTSTakeCert;
                    break;
                }

                MQTTSStatus = eMQTTSRunMQTTS;
                gettimeofday(&stop,NULL);
                hlog_debug("_________________________MQTTs Subscribe took %lu__________________________ ",
                        (stop.tv_sec - start.tv_sec)*1000000L+stop.tv_usec - start.tv_usec);
                gettimeofday(&stopProc, NULL);
                hlog_debug("_________________________Whole process took %lu__________________________ ",
                        (stopProc.tv_sec - startProc.tv_sec)*1000000L+stopProc.tv_usec - startProc.tv_usec);
                break;
            case eMQTTSRunMQTTS:
                hlog_info("****************************MQTT Client Running*************************** \n");
                hlog_info("______________________________________Camera should be online from now____________________________");
                struct sysinfo time_up;
                sysinfo(&time_up);
                printf("+++++++++++++ Hublization Online %d +++++++++++++++++++++++++++++++\n", time_up.uptime);
                mqtts_control(MQTTS_CMD_START);
                mqtts_main();
                hlog_info("MQTTS Client stop running, back to get Server's URL\n");
                MQTTSStatus = eMQTTSTakeLinkServer;
                break;
            default:
                hlog_error("Something is wrong in MQTTS state machine");
                break;
        }
    }
#endif
    return 0;
}

int nxcHubbleMQTTbroker(char *server, int port, char *auth_token, char *response, int len)
{
    int ret = 0;
    char reqContent[512];
    char buffer[1024];
    char responseCode[16] = {0};
    char responseID[64] = {0};

    char cModel[8] = {0};
    char cFWVer[16] = {0};

    // Get model and firmware version, which are defined in config.ini file located in the same folder
    if(nxcHubbleGetServerName(server) < 0)
        return -1;

    if(nvram_param_read(NVCONF_MODEL, cModel) < 0)
        return -2;

    if(nvram_param_read(NVCONF_FW_VERSION, cFWVer) < 0)
        return -3;
    snprintf(reqContent, sizeof(reqContent) -1, "device_token=%s",auth_token);
    // Create request and send to server
    snprintf(buffer, sizeof(buffer) - 1, STD_GET_QUERY_MQTT STD_HEADER2, reqContent, server, 0, cModel, cFWVer);

    //Move to debug due to authen key info 
    hlog_debug("Request MQTTServer URL :%s \n",buffer);

    // Query for MQTT Server's info and store to buffer
    ret = https_client_request(server, port, buffer, strlen(buffer), response);
    //Zlog_Notice("Get_MQTT_Server_URI" , ret ,buffer ,response ,responseCode, responseID);
    hlog_info("%s: response (%s)", __FUNCTION__, response);
    if(ret != 200)
    {
        hlog_error("Failed to download MQTT's URL, return code %d: '%s'", ret, response );
        return ret;
    }
    else
    {
        hlog_info("MQTT's URL response :%s \n",response);
    }

    return ret;
}
int proceed_with_multi_curl(CURLM *curlMulti)
{
    int retries = 3;
    int transferLeft = NUMBER_OF_FILE;
    int downloadStatus = -1;
    int http_status_code;
    CURLMsg *msg=NULL;
    CURL *easyCurlHandle=NULL;
    int msgs_left=0;
    int stillRuning;
    CURLcode return_code=0;
    const char *szUrl;
    while(transferLeft > 0 && downloadStatus!= -2)
    {
        stillRuning = 0;
        // Downloading all Certs at once
        do {
            int numfds=0;
            curl_multi_perform(curlMulti, &stillRuning);
            // Wait for Certs downloading process
            int res = curl_multi_wait(curlMulti, NULL, 0, MAX_WAIT_MSECS, &numfds);
            if(res != CURLM_OK)
            {
                hlog_error("error: curl_multi_wait() returned %d . Removing all curl_easy", res);
                downloadStatus = -2;
                break;
            }
        } while(stillRuning);
        hlog_debug("CURL_MULTI: All transfer is done , Checking for success status");
        // Finish downloading with curl_multi, check for transfer status
        while ((msg = curl_multi_info_read(curlMulti, &msgs_left)))
        {
            easyCurlHandle = msg->easy_handle;
            if (downloadStatus == -2)
            {
                // If a file is failed to download with CURL, remove all others curl_easy_handle
                curl_multi_remove_handle(curlMulti, easyCurlHandle);
                curl_easy_cleanup(easyCurlHandle);
                continue;
            }
            // Check easy_curl_handle if the transfer was done or not
            if (msg->msg == CURLMSG_DONE)
            {
                return_code = msg->data.result;
                // Check if CURL download successfully of not
                if(return_code!=CURLE_OK)
                {
                    hlog_error("CURL error code: %d\n", msg->data.result);
                    hlog_error("File number %d downloaded failed",NUMBER_OF_FILE - transferLeft + 1);
                    hlog_error("CURL error msg: '%s'",certs_error_buffer[NUMBER_OF_FILE - transferLeft]);
                    downloadStatus = -2;
                    curl_multi_remove_handle(curlMulti, easyCurlHandle);
                    curl_easy_cleanup(easyCurlHandle);
                    continue;
                }
                else
                {
                    transferLeft--;
                    downloadStatus = 0;
                }

                // Get HTTP status code
                http_status_code=0;
                szUrl = NULL;
                curl_easy_getinfo(easyCurlHandle, CURLINFO_RESPONSE_CODE, &http_status_code);
                curl_easy_getinfo(easyCurlHandle, CURLINFO_PRIVATE, &szUrl);
                if(http_status_code==200)
                {
                    hlog_debug("Curl Download return HTTP Code 200 %s\n", szUrl);
                }
                else
                {
                    hlog_error("Cert Downloaded with http return code = %d \n", http_status_code);
                }
                curl_multi_remove_handle(curlMulti, easyCurlHandle);
                curl_easy_cleanup(easyCurlHandle);
            }
            else
            {
                // Retry downloading failed CURL_easy
                downloadStatus = -1;
                retries --;
                hlog_error("Curl_Multi Download Failed with CURLMsg=%d\n", msg->msg);
                if (retries == 0)
                {   // Remove Curl_easy handle if failed more than 3 times and restart Downloading Certs state
                    curl_multi_remove_handle(curlMulti, easyCurlHandle);
                    curl_easy_cleanup(easyCurlHandle);
                }
                hlog_error("Checking next curl_easy, Failed file will be re-download with retries = %d",retries);
            }
        }
        usleep(10000);
    }
    return downloadStatus;
}
int get_mqtts_certificate_new(char *sAuthToken)
{
    int i;
    char copyCmd[512] = {0};
    int number_token = 0;
    int ret_val = -1;
    char sModel[8] = {0};
    char sFWVer[16] = {0};
    char sServerName[128] = {0};
    CURLM *curlMulti=NULL;
    curl_global_init(CURL_GLOBAL_ALL);
    curlMulti = curl_multi_init();
    struct timeval startCert,stopCert;
    char reqData[1024];
    char response[4096];
    char cert_url[URL_BUFFER_SIZE];
    char *p_js_data = NULL;
    jsmntok_t token[MAX_TOKEN];

    nvram_param_read(NVCONF_MODEL, sModel);
    nvram_param_read(NVCONF_FW_VERSION, sFWVer);

    memset(reqData, 0x00, sizeof(reqData));
    memset(response, 0x00, sizeof(response));

    // Copy Certs from existing files
    if((access(STORED_CA_FILE,R_OK) == 0) && (access(STORED_CLIENT_CERT_FILE,R_OK) == 0) && (access(STORED_CLIENT_KEY_FILE,R_OK) == 0))
    {
        hlog_info("All Certs file is valid no need to download, Copying CA File");
        sprintf(copyCmd,"cp %s %s",STORED_CA_FILE,CA_FILE);
        RunSystemCmd(copyCmd);
        sprintf(copyCmd,"cp %s %s",STORED_CLIENT_CERT_FILE,CLIENT_CERT_FILE);
        RunSystemCmd(copyCmd);
        sprintf(copyCmd,"cp %s %s",STORED_CLIENT_KEY_FILE,CLIENT_KEY_FILE);
        RunSystemCmd(copyCmd);
        return 0;
    }
    // Clean all certs and redownload all certs
    hlog_error("All Certs file is invalid, Redownloading all certs");
    unlink(CA_FILE);
    unlink(CLIENT_CERT_FILE);
    unlink(CLIENT_KEY_FILE);

    /* Query to API server to get MQTT URL and certificate */
    // Prepare header
    hlog_info("Reading Master Key");
    while(1)
    {
        if(nvram_param_read(NVCONF_MASTER_KEY, sAuthToken) < 0)
        {
            sleep(1) ;
        }
        else
        {
            break;
        }
    }

    if(nxcHubbleGetServerName(sServerName) < 0)
        return -1;

    hlog_debug("%s: authentication token (%s) - API server (%s)", __FUNCTION__, sAuthToken, sServerName);

    /* Build the HTTP query */
    sprintf(reqData, GET_DC_REQUEST_QUERY, sAuthToken, sServerName, strlen(reqData), sModel, sFWVer);

    /* Query to API server and get certificates */
    hlog_debug("Downloading JSON data from server with request %s",reqData);
    gettimeofday(&startCert,NULL);
    hlog_info("Request for Certs's URL with server = '%s'",sServerName);
    hlog_info("Request for Certs's URL with req = '%s'\n",reqData);

    // TODO: Hnadle Downloading all 3 certs with new endpoint

    ret_val = https_client_request_with_res_len(sServerName, 443, reqData, strlen(reqData), response, sizeof(response));
    gettimeofday(&stopCert,NULL);
    hlog_debug("_________________________Downloading Certs's URL took %lu__________________________ ",
            (stopCert.tv_sec - startCert.tv_sec)*1000000L+stopCert.tv_usec - startCert.tv_usec);
    hlog_info("Response = '%s'",response);
    if(ret_val < 0)
    {
        hlog_error("Error downloading JSON data from server");
        ret_val = (-1);
        goto exit_error;
    }

    p_js_data = strchr(response, '{');
    if(p_js_data == NULL)
    {
        ret_val = (-2);
        goto exit_error;
    }

    //hlog_debug("JSON DATA:\r\n%s\n", p_js_data);

    // Parse response
    number_token = parser_json_response(p_js_data, strlen(p_js_data), token, sizeof(token) / sizeof(token[0]));
    hlog_debug("Total token: %d", number_token);
    if(number_token < 0)
    {
        hlog_error("\n Failed to parse token due to invalid JSON format, Retrying....\n");
        ret_val = (-3);
        goto exit_error;
    }

    // Multi Curl: Get path and url for downloading with curl_multi later.
    for(i = 0; i < NUMBER_OF_FILE; i++)
    {
        // Get URLs for downloading the certificates
        memset(cert_url, 0x00, sizeof(cert_url));
        memset(checksumSV, 0x00, sizeof(checksumSV));

        ret_val = get_token_value(p_js_data, strlen(p_js_data), token, number_token, cert_list[i], cert_url, sizeof(cert_url));
        hlog_debug("cert_url : %s\n", cert_url);
        if(ret_val <= 0)
        {
            ret_val = (-4);
            goto exit_error;
        }

        hlog_debug("Token value:\r\n%s\n", cert_url);
        // Add cert's URL to List of Cert's URL to use for CURL later
        strcpy(certURLList[i], cert_url);
        // Add cert's path to List of Cert's path to use for CURL later
        if(ID_list[i] == CA_FILE_ID)
        {
            strcpy(certPathList[i], CA_FILE);
        }
        else if(ID_list[i] == CLIENT_CERT_FILE_ID)
        {
            strcpy(certPathList[i], CLIENT_CERT_FILE);
        }
        else if(ID_list[i] == CLIENT_KEY_FILE_ID)
        {
            strcpy(certPathList[i], CLIENT_KEY_FILE);
        }
        else
        {
            ret_val = (-1);
            goto exit_error;
        }
        hlog_debug("Adding CURL_EASY to CURL_MULTI handle");
        add_to_curl_multi_handle(curlMulti,i);
    }
    gettimeofday(&startCert,NULL);
    hlog_info("Start downloading Certs with CURL_MULTI");
    ret_val = proceed_with_multi_curl(curlMulti);
    if(ret_val < 0)
    {
        hlog_error("Failed to download all 3 certs");
        ret_val = (-5);
        goto exit_error;
    }
    fflush(CACert);
    fclose(CACert);

    fflush(clientCert);
    fclose(clientCert);

    fflush(clientKey);
    fclose(clientKey);

    hlog_info("All Certs downloaded successfully");
    ret_val = checkSumMD5();
    if(ret_val < 0)
    {
        hlog_error("MD5 CheckSum doesn't match");
        ret_val = (-5);
        goto exit_error;
    }
    gettimeofday(&stopCert,NULL);
    hlog_debug("_________________________Downloading 3 Certs took %lu__________________________ ",
            (stopCert.tv_sec - startCert.tv_sec)*1000000L+stopCert.tv_usec - startCert.tv_usec);

    // Use download_url as buffer to get token val
    memset(sub_topic_url, 0x00, sizeof(sub_topic_url));
    ret_val = get_token_value(p_js_data, strlen(p_js_data), token, number_token, JSON_TOKEN_SUB_TOPIC, sub_topic_url, sizeof(sub_topic_url));
    if(ret_val < 0)
    {
        ret_val = (-6);
        goto exit_error;
    }

    if(ret_val == 0)
    {
        ret_val = (-6);
        goto exit_error;
    }
    hlog_info("sub topic: %s", sub_topic_url);
    ret_val = save_file(SUB_TOPIC_FILE_ID, sub_topic_url, strlen(sub_topic_url));
    if(ret_val < 0)
    {
        ret_val = (-6);
        goto exit_error;
    }

    //nvram_param_write1(NVCONF_MQTT_SUB_TOPIC, CLIENT_SUB_TOPIC);

    memset(pub_topic_url, 0x00, sizeof(pub_topic_url));
    ret_val = get_token_value(p_js_data, strlen(p_js_data), token, number_token, JSON_TOKEN_PUB_TOPIC, pub_topic_url, sizeof(pub_topic_url));
    if(ret_val < 0)
    {
        ret_val = (-7);
        goto exit_error;
    }

    if(ret_val == 0)
    {
        ret_val = (-7);
        goto exit_error;
    }
    hlog_info("pub topic: %s", pub_topic_url);
    ret_val = save_file(PUB_TOPIC_FILE_ID, pub_topic_url, strlen(pub_topic_url));
    if(ret_val < 0)
    {
        ret_val = (-7);
        goto exit_error;
    }
    //    nvram_param_write1(NVCONF_MQTT_PUB_TOPIC, CLIENT_PUB_TOPIC);
    // Cleanup Curl_multi if everything is ok
    curl_multi_cleanup(curlMulti);

    // Copy downloaded Certs file for backup
    RunSystemCmd(remountReadWriteCmd);
    hlog_info("Downloaded Certs successfully. Copy all certs for back up later");
    sprintf(copyCmd,"cp %s %s",CA_FILE,STORED_CA_FILE);
    RunSystemCmd(copyCmd);
    sprintf(copyCmd,"cp %s %s",CLIENT_CERT_FILE,STORED_CLIENT_CERT_FILE);
    RunSystemCmd(copyCmd);
    sprintf(copyCmd,"cp %s %s",CLIENT_KEY_FILE,STORED_CLIENT_KEY_FILE);
    RunSystemCmd(copyCmd);
    sync();
#if (CAMSDK_BUILT == 1 || SD_FLASH_SUPPORT == 1 || SPI_FLASH_SUPPORT == 1)
    RunSystemCmd(remountReadOnlyCmd);
#endif
    return ERROR_OK;

exit_error:
    //nvram_param_write1(NVCONF_MQTT_ROOTCA, "");
    //nvram_param_write1(NVCONF_MQTT_CLIENTCERT, "");
    //nvram_param_write1(NVCONF_MQTT_PRIVATEKEY, "");
    // Cleanup Curl_multi in case something wrong
    curl_multi_cleanup(curlMulti);
    hlog_error("Can't get certificate from API server (%d) - Use the default value!", ret_val);
    sleep(3);
    return ret_val;
}

/**
 * @name          save_file
 * @brief         save file to user configuration partition
 * @param[in]     fileIdx: file index
 * @param[in]     data: input data
 * @param[in]     len: length of inout data
 * @return < 0    ERROR
 *         = 0    SUCCESS
 */
int save_file(int fileIdx, char *data, int len)
{
    char path[256];
    FILE *pfile = NULL;

    hlog_info("Save certificate data (%d bytes) to file (%d)", len, fileIdx);

    memset(path, 0x00, sizeof(path));

    if(fileIdx == CA_FILE_ID)
    {
        strcpy(path, CA_FILE);
    }
    else if (fileIdx == CLIENT_CERT_FILE_ID)
    {
        strcpy(path, CLIENT_CERT_FILE);
    }
    else if (fileIdx == CLIENT_KEY_FILE_ID)
    {
        strcpy(path, CLIENT_KEY_FILE);
    }
    else if (fileIdx == SUB_TOPIC_FILE_ID)
    {
        strcpy(path, CLIENT_SUB_TOPIC);
    }
    else if (fileIdx == PUB_TOPIC_FILE_ID)
    {
        strcpy(path, CLIENT_PUB_TOPIC);
    }
    else
    {
        return (-1);
    }

    pfile = fopen(path, "wb");
    if(pfile == NULL)
    {
        return (-1);
    }

    fwrite(data, 1, len, pfile);
    fflush(pfile);
    fclose(pfile);

    return 0;
}

size_t write_func(void *ptr, size_t size, size_t nmemb, void *userdata)
{
    //    hlog_info("%s\n", ptr);
    if( (checksum = strstr((char*)ptr,"x-amz-meta-md5chksum")) != NULL)
    {
        hlog_info("Check Sum :%s\n",checksum+ sizeof("x-amz-meta-md5chksum") + 1);
        sprintf(checksumSV,"%s",checksum+ sizeof("x-amz-meta-md5chksum") + 1);
    }
    else if((checksum = strstr((char*)ptr,"-----BEGIN")) != NULL)
    {
        fwrite((char*)ptr , sizeof(char), strlen(checksum), fp);
    }
    return size * nmemb;
}

#define URLS_HEADER                 "https://"
#define URL_HEADER                  "http://"

static size_t download_certfile_write_data(void *ptr, size_t size, size_t nmemb, void *stream)
{
    if(stream == NULL)
    {
        return -1;
    }
    size_t written = fwrite(ptr, size, nmemb, (FILE *)stream);
    return written;
}

static size_t download_certfile_header_callback(char *buffer, size_t size,
        size_t nitems, void *userdata)
{
    char *header_md5sum = (char*)userdata;
    char *tmpstr = NULL;
    if (userdata == NULL)
    {
        hlog_error("pointer pointing to MD5Sum is NULL");
        return 0;
    }
    /* received header is nitems * size long in 'buffer' NOT ZERO TERMINATED */
    /* 'userdata' is set with CURLOPT_HEADERDATA */
    if (strstr(buffer,"x-amz-meta-md5chksum: ")  != NULL)
    {
        // Get the MD5 String
        // Skip ": " in the string.
        tmpstr = buffer + strlen("x-amz-meta-md5chksum: ");
        if (tmpstr != NULL)
        {
            strncpy(header_md5sum,tmpstr,MD5_SUM_LENGTH);
            //Add string null terminated character
            header_md5sum[MD5_SUM_LENGTH]='\0';
        }
    }
    return nitems * size;
}
int add_to_curl_multi_handle(CURLM *curlMulti,int index)
{
    // Add Cert's URL and path to array
    //hlog_info("Curl_Multi Check: path = '%s', url = '%s'",certPathList[index],certURLList[index]);
    FILE *fileCheck = NULL;
    CURL *curl = curl_easy_init();
    if (curl == NULL)
    {
        hlog_error("Cant Init CURL\n");
        return -1;
    }
#ifdef PC_BUILT
    struct stat st = {0};
    if (stat("./cache", &st) == -1)
    {
        // If the cache dir doesn't exist, create one.
        mkdir("./cache", 0700);
    }
#endif
    /* open the file */
    if (index == 0)
    {
        CACert = fopen(certPathList[index], "wb");
        fileCheck = CACert;
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, CACert);
    }
    else if(index == 1)
    {
        clientCert = fopen(certPathList[index], "wb");
        fileCheck = clientCert;
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, clientCert);
    }
    else if(index == 2)
    {
        clientKey = fopen(certPathList[index], "wb");
        fileCheck = clientKey;
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, clientKey);
    }
    if(!fileCheck)
    {
        hlog_error("Error Cant create Cert File");
        curl_easy_cleanup(curl);
        return -2;
    }
    curl_easy_setopt(curl, CURLOPT_URL, certURLList[index]);
    // NOTICE WE DONT VERIFY PEER FOR NOW
    curl_easy_setopt(curl, CURLOPT_TIMEOUT, 0);
    curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 0);
    curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);

    // use for debugging curl
    curl_easy_setopt(curl, CURLOPT_VERBOSE, 0L);
    curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, certs_error_buffer[index]);
    /* write the page body to this file handle */

    // Enable HTTPs
    curl_easy_setopt(curl, CURLOPT_USE_SSL, CURLUSESSL_CONTROL);
    curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 0L);
#if(DEF_SERVER_CERT_VERIFICATION)                                               
    if(access(CERTIFICATE_HUBBLE_PATH, F_OK))                               
    {                                                                       
        hlog_error("Can't using backup CAs certificate to verify peer. Abort uploading!!!");
        return -1;                                                      
    }                                                                       
    curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 1L);                      
    curl_easy_setopt(curl, CURLOPT_CAINFO, CERTIFICATE_HUBBLE_PATH);        
    hlog_error("Enable server's certificate verification");                 
#else                                                                           
    curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0L);                     
#endif     

    // Set Ciphersuites
    //curl_easy_setopt(curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
    curl_easy_setopt(curl, CURLOPT_SSL_CIPHER_LIST, "TLS-RSA-WITH-AES-128-CBC-SHA256");

    // Set Callback to download cert
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, download_certfile_write_data);
    // Set Callback to get MD5 Check sum
    curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION,download_certfile_header_callback);
    curl_easy_setopt(curl, CURLOPT_HEADERDATA, downloadcertfile_header_md5sum[index]);

    curl_multi_add_handle(curlMulti, curl);
    return 0; 
}
int checkSumMD5()
{
    int i;
    int ret = -3;
    int md5sumret = 0;
    char filemd5sum[64];
    FILE *md5File = NULL;
    char md5String[512] = {0};
    for(i=0;i<NUMBER_OF_FILE;i++)
    {
        md5sumret = MD5FileCheckSum(certPathList[i], filemd5sum, sizeof(filemd5sum)-1);
        hlog_debug("CertFile Download Header MD5sum '%s'\n",downloadcertfile_header_md5sum[i]);
        hlog_debug("CertFile Download Calculate MD5sum '%s'\n",filemd5sum);
        if (strncmp(downloadcertfile_header_md5sum[i],filemd5sum,MD5_SUM_LENGTH) == 0)
        {
            hlog_info("CertFile's MD5Sum Matched, Store MD5Sum to check later");
            if(i == 0)
                sprintf(md5String + strlen(md5String),"%s",CA_CERT_NAME);
            else if (i == 1)
                sprintf(md5String + strlen(md5String),"%s",CLIENT_CERT_NAME);
            else if (i == 2)
                sprintf(md5String + strlen(md5String),"%s",CLIENT_KEY_NAME);
            sprintf(md5String + strlen(md5String),"%s\n",filemd5sum);

        }
        else
        {
            hlog_error("CertFile's MD5Sum UNMatched\n");
            // remove Md5just download file
            unlink(certPathList[i]);
            ret = -3;
            return ret;
        }
    }
    // Save MD5 Sum for later use
    hlog_info("Writing md5Sum to file : '%s'",md5String);
    RunSystemCmd(remountReadWriteCmd);
    md5File = fopen(CERT_MD5SUM_FILE,"w+");
    if(md5File == NULL)
        hlog_error("Unable to write MD5 Sum to %s",md5File);
    else
    {
        fwrite(md5String,1,strlen(md5String),md5File);
        fclose(md5File);
        sync();
        // Only set read only following models
#if (CAMSDK_BUILT == 1 || SD_FLASH_SUPPORT == 1 || SPI_FLASH_SUPPORT == 1)
        RunSystemCmd(remountReadOnlyCmd);
#endif
    }
    ret = 0;
    return ret;
}






