show_usage()
{
    printf "./build_mqtt_app.sh <build platform sdk> \n"
    printf "example: ./build_mqtt_app.sh <pcbuild | hubblesdk | camsdk | nuvoton>\n"
}
if [ \( $# -eq 0 \) -o \( $# -gt 1 \) ] ; then
    show_usage
    printf "ERROR: incorrect number of parameters\n"
    exit 1
fi

BUILD_PLATFROM_SDK=$1
export BUILD_PLATFROM_SDK=$1

if [ "$1" == "pcbuild" ];then
    cp -rf ./platform/$1/Makefile ./
    CC=gcc 
	STRIP=strip
elif [ "$1" == "hubblesdk" ];then
    cp -rf ./platform/$1/Makefile ./
    CC=arm-linux-gcc 
	STRIP=arm-linux-strip
elif [ "$1" == "nuvoton" ];then
    cp -rf ./platform/$1/Makefile ./
    CC=arm-linux-gcc 
	STRIP=arm-linux-strip
else
	echo "Build CamSDK"
	exit 0
fi
make clean;
if [ "$?" != "0" ];then
    echo "Clean mqtt app failure!!!"
    exit 1
fi
make CC=$CC STRIP=$STRIP;
if [ "$?" != "0" ];then
    echo "Make mqtt app failure!!!"
    exit 1
fi
