# sh4 has issues with the 2.6 headers
#%define cross_archs mipsel mips i386 arm armeb powerpc
%define cross_archs mips mipsel

# uClibc snapshot
%define uclibc_version 20050428

# The 2.6.x kernel series headers are not suitable for direct inclusion
# by uClibc or general userspace apps.  Use the sanitized versions from
# http://ep09.pld-linux.org/~mmazur/linux-libc-headers/ instead, along
# with some additional cleanups.
%define linux_libc_headers_version 2.6.11.0
%define kernel_header_dir linux-libc-headers-%{linux_libc_headers_version}
%define kernel_top_dir %{kernel_header_dir}

# binutils
%define binutils_version 2.15.94.0.2.2

# gcc
%define gcc_version 3.4.2

# gdb
%define gdb_version 6.3

# Select the following if building soft-float 3.3.x toolchains.
#
#%define soft_float_config_option --without-float
#%define target_soft_float -msoft-float

#
# Select the following if building soft-float 3.4.x toolchains.
#
#%define soft_float_config_option --with-float=soft
#%define target_soft_float -msoft-float

#
# Select the following if building normal toolchains.
#
%define soft_float_config_option %{nil}
%define target_soft_float %{nil}

# Toolchain path.
%define tools_dir_prefix /opt/toolchains/uclibc-crosstools_gcc-%{gcc_version}_uclibc-%{uclibc_version}

%define __check_files %{nil}

######################################################################

Summary: uClibc cross compile toolchains for Linux MIPS Big/Little Endian
Name: uclibc-crosstools
Version: %{gcc_version}
Release: 10
Copyright: GPL
Group: Development/Tools
Packager: Ton Truong <ttruong@broadcom.com>
Vendor: Broadcom Corp

######################################################################
# Sources

Source0: uClibc-%{uclibc_version}.tar.bz2
Source1: linux-libc-headers-%{linux_libc_headers_version}.tar.bz2
Source2: binutils-%{binutils_version}.tar.bz2
Source3: gcc-%{gcc_version}.tar.bz2
Source4: gdb-%{gdb_version}.tar.bz2
Source5: sstrip.tar.bz2

# Warning! Modify specs to default to not linking C apps with libgcc_s.
Source10: specs.staticlibgcc.patch

#Source11: specs-mipsel-soft-float
#Source12: specs-mips-soft-float

######################################################################
# Patches
#
# Numbering convention used is (source number) * 100 + (subpatch number).
#

Patch009: uClibc-%{uclibc_version}-config.patch.bz2

Patch100: linux-libc-headers-%{linux_libc_headers_version}-cleanup.patch.bz2
Patch109: linux-libc-headers-%{linux_libc_headers_version}-REPLACE_ME.patch.bz2



Patch200: binutils-%{binutils_version}-100-uclibc-conf.patch.bz2
Patch201: binutils-%{binutils_version}-210-cflags.patch.bz2
Patch202: binutils-%{binutils_version}-301_ld_makefile_patch.patch.bz2
Patch203: binutils-%{binutils_version}-306_better_file_error.patch.bz2
Patch204: binutils-%{binutils_version}-312_check_ldrunpath_length.patch.bz2
Patch205: binutils-%{binutils_version}-320_mips_xgot_multigot_workaround.patch.bz2
# Warning! The following patch is appropriate for 4K PAGE_SIZE only!
Patch206: binutils-%{binutils_version}-400-mips-ELF_MAXPAGESIZE-4K.patch.bz2
Patch207: binutils-%{binutils_version}-702-binutils-skip-comments.patch.bz2
#Patch208: binutils-%{binutils_version}-802-brcmmips3300war.patch.bz2


# Note: For gcc 3.4.x, the 110, 120, and 500 patches are empty.
Patch310: gcc-%{gcc_version}-100-uclibc-conf.patch.bz2
#Patch311: gcc-%{gcc_version}-110-uclibc-conf.patch.bz2
#Patch312: gcc-%{gcc_version}-120-softfloat.patch.bz2
Patch320: gcc-%{gcc_version}-200-uclibc-locale.patch.bz2
Patch330: gcc-%{gcc_version}-300-libstdc++-pic.patch.bz2
Patch331: gcc-%{gcc_version}-300-pr15526.patch.bz2
Patch332: gcc-%{gcc_version}-300-pr17541.patch.bz2
Patch333: gcc-%{gcc_version}-300-pr17976.patch.bz2
Patch340: gcc-%{gcc_version}-400-mips-delay-slot.patch.bz2
Patch341: gcc-%{gcc_version}-401-ppc-eabi-typo.patch.bz2
Patch342: gcc-%{gcc_version}-402-mips-pr17770.patch.bz2
#Patch350: gcc-%{gcc_version}-500-loop.patch.bz2
Patch360: gcc-%{gcc_version}-600-gcc34-arm-ldm-peephole.patch.bz2
Patch361: gcc-%{gcc_version}-601-gcc34-arm-ldm.patch.bz2
Patch362: gcc-%{gcc_version}-602-sdk-libstdc++-includes.patch.bz2
Patch370: gcc-%{gcc_version}-700-pr15068-fix.patch.bz2
Patch380: gcc-%{gcc_version}-800-arm-bigendian.patch.bz2
Patch381: gcc-%{gcc_version}-810-arm-bigendian-uclibc.patch.bz2
Patch390: gcc-%{gcc_version}-900-install-info.patch.bz2

Patch400: gdb-%{gdb_version}-100-uclibc-conf.pat.bz2
Patch401: gdb-%{gdb_version}-200-uclibc-readline-conf.patch.bz2
Patch402: gdb-%{gdb_version}-400-mips-coredump.patch.bz2
Patch403: gdb-%{gdb_version}-500-thread-timeout.patch.bz2


######################################################################
# Sub packages

# common

%description
The cross compile toolchains for Linux/MIPS Big/Little Endian machines using
uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
versions of gdb (host) and gdbserver (target) are provided.  The source
versions for this toolchain are:

%package common
Summary: The cross compile toolchains for Linux/MIPS Little Endian machines
Group: Development/Tools

%description common
Common files for the uClibc Linux/MIPS Big/Little Endian cross compile
toolchains.  The source versions for this toolchain are:

   uClibc-%{uclibc_version}
   linux-libc-headers-%{linux_libc_headers_version}
   binutils-%{binutils_version}
   gcc-%{gcc_version}
   gdb-%{gdb_version}

# mipsel

%package mipsel
Summary: The cross compile toolchains for Linux/MIPS Little Endian machines
Group: Development/Tools
Requires: uclibc-crosstools-common = %{gcc_version}

%description mipsel
The cross compile toolchains for Linux/MIPS Little Endian machines using
uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
versions of gdb (host) and gdbserver (target) are provided.  The source
versions for this toolchain are:

   uClibc-%{uclibc_version}
   linux-libc-headers-%{linux_libc_headers_version}
   binutils-%{binutils_version}
   gcc-%{gcc_version}
   gdb-%{gdb_version}

# mips

%package mips
Summary: The cross compile toolchains for Linux/MIPS Big Endian machines
Group: Development/Tools
Requires: uclibc-crosstools-common = %{gcc_version}

%description mips
The cross compile toolchains for Linux/MIPS Big Endian machines using
uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
versions of gdb (host) and gdbserver (target) are provided.  The source
versions for this toolchain are:

   uClibc-%{uclibc_version}
   linux-libc-headers-%{linux_libc_headers_version}
   binutils-%{binutils_version}
   gcc-%{gcc_version}
   gdb-%{gdb_version}

## i386
#
#%package i386
#Summary: The cross compile toolchains for Linux/i386 machines
#Group: Development/Tools
#Requires: uclibc-crosstools-common = %{gcc_version}
#
#%description i386
#The cross compile toolchains for Linux/i386 machines using
#uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
#versions of gdb (host) and gdbserver (target) are provided.  The source
#versions for this toolchain are:
#
#   uClibc-%{uclibc_version}
#   linux-libc-headers-%{linux_libc_headers_version}
#   binutils-%{binutils_version}
#   gcc-%{gcc_version}
#   gdb-%{gdb_version}
#
## arm
#
#%package arm
#Summary: The cross compile toolchains for Linux/ARM Little Endian machines
#Group: Development/Tools
#Requires: uclibc-crosstools-common = %{gcc_version}
#
#%description arm
#The cross compile toolchains for Linux/ARM Little Endian machines using
#uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
#versions of gdb (host) and gdbserver (target) are provided.  The source
#versions for this toolchain are:
#
#   uClibc-%{uclibc_version}
#   linux-libc-headers-%{linux_libc_headers_version}
#   binutils-%{binutils_version}
#   gcc-%{gcc_version}
#   gdb-%{gdb_version}
#
## armeb
#
#%package armeb
#Summary: The cross compile toolchains for Linux/ARM Big Endian machines
#Group: Development/Tools
#Requires: uclibc-crosstools-common = %{gcc_version}
#
#%description armeb
#The cross compile toolchains for Linux/ARM Big Endian machines using
#uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
#versions of gdb (host) and gdbserver (target) are provided.  The source
#versions for this toolchain are:
#
#   uClibc-%{uclibc_version}
#   linux-libc-headers-%{linux_libc_headers_version}
#   binutils-%{binutils_version}
#   gcc-%{gcc_version}
#   gdb-%{gdb_version}
#
## powerpc
#
#%package powerpc
#Summary: The cross compile toolchains for Linux/powerpc machines
#Group: Development/Tools
#Requires: uclibc-crosstools-common = %{gcc_version}
#
#%description powerpc
#The cross compile toolchains for Linux/powerpc machines using
#uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
#versions of gdb (host) and gdbserver (target) are provided.  The source
#versions for this toolchain are:
#
#   uClibc-%{uclibc_version}
#   linux-libc-headers-%{linux_libc_headers_version}
#   binutils-%{binutils_version}
#   gcc-%{gcc_version}
#   gdb-%{gdb_version}

# sh4
#
#%package sh4
#Summary: The cross compile toolchains for Linux/SH4 Little Endian machines
#Group: Development/Tools
#Requires: uclibc-crosstools-common = %{gcc_version}
#
#%description sh4
#The cross compile toolchains for Linux/SH4 Little Endian machines using
#uClibc as the C runtime. These toolchains also support C++.  Also, uClibc
#versions of gdb (host) and gdbserver (target) are provided.  The source
#versions for this toolchain are:
#
#   uClibc-%{uclibc_version}
#   linux-libc-headers-%{linux_libc_headers_version}
#   binutils-%{binutils_version}
#   gcc-%{gcc_version}
#   gdb-%{gdb_version}

######################################################################

%prep
rm -rf ${RPM_BUILD_DIR}/%{kernel_top_dir}

%setup -T -b 0 -n uClibc-%{uclibc_version}
%patch009 -p1

%setup -T -b 1 -n linux-libc-headers-%{linux_libc_headers_version}
%patch100 -p1
%patch109 -p1

%setup -T -b 2 -n binutils-%{binutils_version}
%patch200 -p1
%patch201 -p1
%patch202 -p1
%patch203 -p1
%patch204 -p1
%patch205 -p1
# See note above regarding the following patch.
%patch206 -p1
%patch207 -p1
#%patch208 -p1

%setup -T -b 3 -n gcc-%{gcc_version}
%patch310 -p1
#%patch311 -p1
#%patch312 -p1
%patch320 -p1
%patch330 -p1
%patch331 -p1
%patch332 -p1
%patch333 -p1
%patch340 -p1
%patch341 -p1
%patch342 -p1
#%patch350 -p1
%patch360 -p1
%patch361 -p1
%patch362 -p1
%patch370 -p1
%patch380 -p1
%patch381 -p1
%patch390 -p1

%setup -T -b 4 -n gdb-%{gdb_version}
%patch400 -p1
%patch401 -p1
%patch402 -p1
%patch403 -p1

%setup -T -b 5 -n sstrip

######################################################################

%build
build_tool()
{
  arch=$1
  gnu_arch=$arch-linux-uclibc
  export PATH=%{tools_dir_prefix}/bin:$PATH

  pushd ${RPM_BUILD_DIR}

  #
  # Set the arch for the build/devel system, or let it be automaticly set.
  #

  #build_arch=i386-pc-linux-gnu
  #build_arch=`${RPM_BUILD_DIR}/gcc-%{gcc_version}/config.guess`
  build_arch=`${RPM_BUILD_DIR}/gcc-%{gcc_version}/config.guess | sed \
	-e 's/sparc.*/sparc/' -e 's/arm.*/arm/g' -e 's/m68k.*/m68k/' \
	-e 's/ppc/powerpc/g' -e 's/v850.*/v850/g' -e 's/sh[234]/sh/' \
	-e 's/mips-.*/mips/' -e 's/mipsel-.*/mipsel/' -e 's/cris.*/cris/' \
	-e 's/i[3-9]86/i386/'`

  # Configure uClibc and header files
  
  #
  # Build uClibc
  #
  pushd uClibc-%{uclibc_version}

  mkdir -p %{tools_dir_prefix}/$gnu_arch/include
  mkdir -p ${RPM_BUILD_DIR}/build_uClibc/usr/include
  mkdir -p ${RPM_BUILD_DIR}/build_uClibc/usr/lib
  mkdir -p ${RPM_BUILD_DIR}/build_uClibc/lib

  # Copy in the architecture config and fix it up
  cp extra/Configs/Config.rpm.$arch ./.config
  if [ -n "%{soft_float_config_option}" ]; then
    perl -i -p -e 's,.*HAS_FPU.*,HAS_FPU=n\nUCLIBC_HAS_FLOATS=y\nUCLIBC_HAS_SOFT_FLOAT=y,g' ./.config
  fi

  # New in uClibc-20050428 version
  echo "CROSS_COMPILER_PREFIX=\"$gnu_arch-\"" >> ./.config
  make oldconfig

  make  PREFIX=${RPM_BUILD_DIR}/build_uClibc/			\
	DEVEL_PREFIX=/usr/					\
	RUNTIME_PREFIX=${RPM_BUILD_DIR}/build_uClibc/		\
	HOSTCC=gcc						\
    	KERNEL_SOURCE=${RPM_BUILD_DIR}/%{kernel_top_dir}	\
	CROSS=$gnu_arch-					\
	pregen install_dev
  popd

  #
  # Configure, build and install binutils
  #
  rm -rf build-binutils-%{binutils_version}
  mkdir build-binutils-%{binutils_version}
  pushd build-binutils-%{binutils_version}
  ../binutils-%{binutils_version}/configure			\
    --prefix=%{tools_dir_prefix}				\
    --target=$gnu_arch						\
    --build=$build_arch 					\
    --host=$build_arch	 					\
    --disable-nls 						\
    --enable-multilib 						\
    %{soft_float_config_option}

  make -j3
  make info
  make install
  make install-info
  popd

  #
  # Build first stage C compiler
  #
  rm -rf build-gcc-%{gcc_version}-initial
  mkdir build-gcc-%{gcc_version}-initial
  pushd build-gcc-%{gcc_version}-initial

  # Currently the unwind stuff seems to work for staticly linked apps but
  # not dynamic.  So use setjmp/longjmp exceptions by default.
  #
  AR=$gnu_arch-ar AS=$gnu_arch-as RANLIB=$gnu_arch-ranlib	\
    ../gcc-%{gcc_version}/configure 				\
    --prefix=%{tools_dir_prefix}				\
    --target=$gnu_arch						\
    --build=$build_arch 					\
    --host=$build_arch 						\
    --disable-shared						\
    --with-sysroot=${RPM_BUILD_DIR}/build_uClibc/ 		\
    --enable-languages=c					\
    --enable-target-optspace 					\
    --disable-nls 						\
    --with-gnu-ld						\
    --disable-__cxa_atexit 					\
    --enable-multilib 						\
    --disable-threads						\
    --with-arch=mips32						\
    %{soft_float_config_option}

  make -j3 all-gcc
  make install-gcc

  popd

  #
  # Build uClibc (which was configured above).
  #
  pushd uClibc-%{uclibc_version}

  make KERNEL_SOURCE=${RPM_BUILD_DIR}/%{kernel_top_dir}		\
    PREFIX=							\
    DEVEL_PREFIX=						\
    RUNTIME_PREFIX=						\
    CROSS=$gnu_arch- all

   make KERNEL_SOURCE=${RPM_BUILD_DIR}/%{kernel_top_dir}		\
    PREFIX=							\
    DEVEL_PREFIX=						\
    RUNTIME_PREFIX=						\
    CROSS=$gnu_arch- shared

   make KERNEL_SOURCE=${RPM_BUILD_DIR}/%{kernel_top_dir} 		\
    PREFIX=%{tools_dir_prefix}/$gnu_arch/ 			\
    DEVEL_PREFIX=						\
    RUNTIME_PREFIX=						\
    CROSS=$gnu_arch-	 					\
    install_runtime install_dev

  make KERNEL_SOURCE=${RPM_BUILD_DIR}/%{kernel_top_dir} 	\
    PREFIX=%{tools_dir_prefix}/$gnu_arch/target-apps/ 		\
    DEVEL_PREFIX=						\
    RUNTIME_PREFIX=						\
    CROSS=$gnu_arch-	 					\
    utils install_utils

  make -C utils							\
    KERNEL_SOURCE=${RPM_BUILD_DIR}/%{kernel_top_dir} 		\
    PREFIX=%{tools_dir_prefix}/$gnu_arch/ 			\
    CROSS=$gnu_arch-	 					\
    clean

  ln -sf include %{tools_dir_prefix}/$gnu_arch/sys-include

  # We build uClibc in place, so clean it up for the next arch.
  make distclean

  popd

  #
  # Build final C compiler and C++ support, using the newly built uClibc.
  #
  rm -rf build-gcc-%{gcc_version}-final
  mkdir build-gcc-%{gcc_version}-final
  pushd build-gcc-%{gcc_version}-final

  #
  # WARNING!!!  Do not use --with-gxx-include-dir!!!  WARNING!!!
  #
  # mjn3: Incorrectly setting the g++ include dir has broken a number
  #       of uClibc toolchains in the past.  There is logic in some gcc
  #       versions that attempts to detect path aliases and which can
  #        break the include dir search order.  Best to just leave it be.
  #

  AR=$gnu_arch-ar RANLIB=$gnu_arch-ranlib			\
    ../gcc-%{gcc_version}/configure				\
    --prefix=%{tools_dir_prefix}/				\
    --target=$gnu_arch						\
    --build=$build_arch						\
    --host=$build_arch						\
    --enable-target-optspace					\
    --disable-nls						\
    --with-gnu-ld						\
    --enable-shared						\
    --enable-languages=c,c++					\
    --enable-threads						\
    --infodir=%{tools_dir_prefix}/info				\
    --mandir=%{tools_dir_prefix}/man				\
    --disable-__cxa_atexit 					\
    --enable-sjlj-exceptions					\
    --disable-checking						\
    --with-arch=mips32						\
    %{soft_float_config_option}

  make -j3 all
  make info
  make install
  make install-info

  popd

#mjn3 - keep?
  if [ -n "%{soft_float_config_option}" ]; then
    # Directory name changed in gcc 3.4.x from lib/gcc-libc/ to lib/gcc/.
    # But that is ok, as this is only used for the 3.3.x toolchain.
    if [ -d %{tools_dir_prefix}/lib/gcc-lib ] ; then 
      # Replace specs file with one that defaults to soft float mode.
      cp ${RPM_SOURCE_DIR}/specs-$arch-soft-float \
         %{tools_dir_prefix}/lib/gcc-lib/$gnu_arch/%{gcc_version}/specs
    fi
  fi


  # Change the default to not link C apps with libgcc_s.
  pushd %{tools_dir_prefix}/lib/gcc/$gnu_arch/%{gcc_version}
  patch -p0 specs < ${RPM_SOURCE_DIR}/specs.staticlibgcc.patch
  popd

  #
  # Build gdbserver for the target
  #
  rm -rf build-gdbserver%{gdb_version}
  mkdir build-gdbserver%{gdb_version}
  pushd build-gdbserver%{gdb_version}

  AR=$gnu_arch-ar						\
  AS=$gnu_arch-as						\
  LD=$gnu_arch-ld						\
  NM=$gnu_arch-nm						\
  CC=$gnu_arch-gcc						\
  GCC=$gnu_arch-gcc						\
  CXX=$gnu_arch-g++						\
  RANLIB=$gnu_arch-ranlib					\
  gdb_cv_func_sigsetjmp=yes					\
  ac_cv_type_uintptr_t=yes					\
  gt_cv_func_gettext_libintl=yes				\
  ac_cv_func_dcgettext=yes					\
  bash_cv_func_strcoll_broken=no				\
  bash_cv_must_reinstall_sighandlers=no				\
  bash_cv_func_sigsetjmp=present				\
  bash_cv_have_mbstate_t=yes					\
  ../gdb-%{gdb_version}/gdb/gdbserver/configure			\
    --prefix=%{tools_dir_prefix}/$gnu_arch/target-apps/usr	\
    --target=$gnu_arch						\
    --build=$build_arch						\
    --host=$gnu_arch						\
    --mandir=%{tools_dir_prefix}/man				\
    --infodir=%{tools_dir_prefix}/info				\
    --disable-nls						\
    --without-uiout --disable-gdbmi				\
    --disable-tui --disable-gdbtk --without-x			\
    --without-included-gettext

  make -j3 all
  make install
  popd

  #
  # Build gdb for the host
  #
  rm -rf build-gdb-%{gdb_version}
  mkdir build-gdb-%{gdb_version}
  pushd build-gdb-%{gdb_version}
  gdb_cv_func_sigsetjmp=yes					\
  ../gdb-%{gdb_version}/configure				\
    --prefix=%{tools_dir_prefix}				\
    --target=$gnu_arch						\
    --build=$build_arch						\
    --host=$build_arch						\
    --disable-nls						\
    --disable-gdbserver						\
    --without-included-gettext

  make -j3 all-gdb
  make info
  #make install-gdb
  make install
  make install-info
  #install gdb/gdb %{tools_dir_prefix}/bin/$gnu_arch-gdb
  #install gdb/gdb %{tools_dir_prefix}/$gnu_arch/bin

  popd

  #
  # Build sstrip for the host.
  #
  # Even though it is independent of the target arch, provide symlinks
  # so that it can be invoked like all other cross tools.
  #

  pushd sstrip

  make all

  install sstrip %{tools_dir_prefix}/bin

  ln -sf sstrip %{tools_dir_prefix}/bin/$gnu_arch-sstrip
  ln -sf ../../bin/sstrip %{tools_dir_prefix}/$gnu_arch/bin/sstrip

  popd

  #
  # Now strip all binaries.
  #

  # Remove the script to avoid strip failures.
  rm -f %{tools_dir_prefix}/bin/*-gccbug

  # Do some additional housekeeping.
  rm -f %{tools_dir_prefix}/lib/libiberty.a
  rm -f %{tools_dir_prefix}/gcc/libiberty.a
  rm -f %{tools_dir_prefix}/gcc/libmmalloc.a

  strip %{tools_dir_prefix}/bin/*
  strip %{tools_dir_prefix}/$gnu_arch/bin/*

  $gnu_arch-strip %{tools_dir_prefix}/$gnu_arch/target-apps/sbin/*
  $gnu_arch-strip %{tools_dir_prefix}/$gnu_arch/target-apps/usr/bin/*

  #
  # Create the backward compatibility symlinks.
  #

  pushd %{tools_dir_prefix}/bin
  for F in $gnu_arch-* ; do ln -s $F $arch${F##$arch-linux} ; done
  popd
  ln -sf $gnu_arch %{tools_dir_prefix}/$arch-linux

  # Directory name changed in gcc 3.4.x from lib/gcc-libc/ to lib/gcc/.
  if [ -d %{tools_dir_prefix}/lib/gcc-lib ] ; then 
    ln -sf $gnu_arch %{tools_dir_prefix}/lib/gcc-lib/$arch-linux
  fi
  if [ -d %{tools_dir_prefix}/lib/gcc ] ; then 
    ln -sf $gnu_arch %{tools_dir_prefix}/lib/gcc/$arch-linux
  fi
}

# Remove the old toolchain if it exists
rm -rf %{tools_dir_prefix}

# Build all of the targets
for t in %{cross_archs}; do
  build_tool $t
done

######################################################################

%install
rm -f %{tools_dir_prefix}/bin/*-gccbug
rm -f %{tools_dir_prefix}/bin/*-gcov
rm -f %{tools_dir_prefix}/bin/expect
rm -f %{tools_dir_prefix}/bin/runtest
rm -f %{tools_dir_prefix}/bin/tclsh*
rm -f %{tools_dir_prefix}/man/man1/expect.1
rm -f %{tools_dir_prefix}/man/man1/runtest.1
rm -f %{tools_dir_prefix}/man/man1/tclsh.1
gzip -9f %{tools_dir_prefix}/info/*.info*
gzip -9f %{tools_dir_prefix}/man/man1/*
gzip -9f %{tools_dir_prefix}/man/man7/*

######################################################################

%files common
%defattr(-,root,root)
# Want everything but the arch-specific dirs
%{tools_dir_prefix}/include/c++/%{gcc_version}/algorithm
%{tools_dir_prefix}/include/c++/%{gcc_version}/backward
%{tools_dir_prefix}/include/c++/%{gcc_version}/bits
%{tools_dir_prefix}/include/c++/%{gcc_version}/bitset
%{tools_dir_prefix}/include/c++/%{gcc_version}/cassert
%{tools_dir_prefix}/include/c++/%{gcc_version}/cctype
%{tools_dir_prefix}/include/c++/%{gcc_version}/cerrno
%{tools_dir_prefix}/include/c++/%{gcc_version}/cfloat
%{tools_dir_prefix}/include/c++/%{gcc_version}/ciso646
%{tools_dir_prefix}/include/c++/%{gcc_version}/climits
%{tools_dir_prefix}/include/c++/%{gcc_version}/clocale
%{tools_dir_prefix}/include/c++/%{gcc_version}/cmath
%{tools_dir_prefix}/include/c++/%{gcc_version}/complex
%{tools_dir_prefix}/include/c++/%{gcc_version}/csetjmp
%{tools_dir_prefix}/include/c++/%{gcc_version}/csignal
%{tools_dir_prefix}/include/c++/%{gcc_version}/cstdarg
%{tools_dir_prefix}/include/c++/%{gcc_version}/cstddef
%{tools_dir_prefix}/include/c++/%{gcc_version}/cstdio
%{tools_dir_prefix}/include/c++/%{gcc_version}/cstdlib
%{tools_dir_prefix}/include/c++/%{gcc_version}/cstring
%{tools_dir_prefix}/include/c++/%{gcc_version}/ctime
%{tools_dir_prefix}/include/c++/%{gcc_version}/cwchar
%{tools_dir_prefix}/include/c++/%{gcc_version}/cwctype
%{tools_dir_prefix}/include/c++/%{gcc_version}/cxxabi.h
%{tools_dir_prefix}/include/c++/%{gcc_version}/debug
%{tools_dir_prefix}/include/c++/%{gcc_version}/deque
%{tools_dir_prefix}/include/c++/%{gcc_version}/exception
%{tools_dir_prefix}/include/c++/%{gcc_version}/exception_defines.h
%{tools_dir_prefix}/include/c++/%{gcc_version}/ext
%{tools_dir_prefix}/include/c++/%{gcc_version}/fstream
%{tools_dir_prefix}/include/c++/%{gcc_version}/functional
%{tools_dir_prefix}/include/c++/%{gcc_version}/iomanip
%{tools_dir_prefix}/include/c++/%{gcc_version}/ios
%{tools_dir_prefix}/include/c++/%{gcc_version}/iosfwd
%{tools_dir_prefix}/include/c++/%{gcc_version}/iostream
%{tools_dir_prefix}/include/c++/%{gcc_version}/istream
%{tools_dir_prefix}/include/c++/%{gcc_version}/iterator
%{tools_dir_prefix}/include/c++/%{gcc_version}/limits
%{tools_dir_prefix}/include/c++/%{gcc_version}/list
%{tools_dir_prefix}/include/c++/%{gcc_version}/locale
%{tools_dir_prefix}/include/c++/%{gcc_version}/map
%{tools_dir_prefix}/include/c++/%{gcc_version}/memory
%{tools_dir_prefix}/include/c++/%{gcc_version}/new
%{tools_dir_prefix}/include/c++/%{gcc_version}/numeric
%{tools_dir_prefix}/include/c++/%{gcc_version}/ostream
%{tools_dir_prefix}/include/c++/%{gcc_version}/queue
%{tools_dir_prefix}/include/c++/%{gcc_version}/set
%{tools_dir_prefix}/include/c++/%{gcc_version}/sstream
%{tools_dir_prefix}/include/c++/%{gcc_version}/stack
%{tools_dir_prefix}/include/c++/%{gcc_version}/stdexcept
%{tools_dir_prefix}/include/c++/%{gcc_version}/streambuf
%{tools_dir_prefix}/include/c++/%{gcc_version}/string
%{tools_dir_prefix}/include/c++/%{gcc_version}/typeinfo
%{tools_dir_prefix}/include/c++/%{gcc_version}/utility
%{tools_dir_prefix}/include/c++/%{gcc_version}/valarray
%{tools_dir_prefix}/include/c++/%{gcc_version}/vector
# Now the rest of the common stuff
%docdir %{tools_dir_prefix}/info
%{tools_dir_prefix}/info/
%docdir %{tools_dir_prefix}/man
%{tools_dir_prefix}/man/man1/gdbserver.1.gz
%{tools_dir_prefix}/man/man7
%{tools_dir_prefix}/bin/sstrip

%files mipsel
%defattr(-,root,root)
%{tools_dir_prefix}/bin/mipsel-*
%{tools_dir_prefix}/include/c++/%{gcc_version}/mipsel-linux-uclibc/
%{tools_dir_prefix}/lib/gcc/mipsel-linux-uclibc/
%{tools_dir_prefix}/lib/gcc/mipsel-linux
%{tools_dir_prefix}/libexec/gcc/mipsel-linux-uclibc/
%{tools_dir_prefix}/mipsel-linux-uclibc/
%{tools_dir_prefix}/mipsel-linux
%docdir %{tools_dir_prefix}/man
%{tools_dir_prefix}/man/man1/mipsel-*

%files mips
%defattr(-,root,root)
%{tools_dir_prefix}/bin/mips-*
%{tools_dir_prefix}/include/c++/%{gcc_version}/mips-linux-uclibc/
%{tools_dir_prefix}/lib/gcc/mips-linux-uclibc/
%{tools_dir_prefix}/lib/gcc/mips-linux
%{tools_dir_prefix}/libexec/gcc/mips-linux-uclibc/
%{tools_dir_prefix}/mips-linux-uclibc/
%{tools_dir_prefix}/mips-linux
%docdir %{tools_dir_prefix}/man
%{tools_dir_prefix}/man/man1/mips-*

#%files i386
#%defattr(-,root,root)
#%{tools_dir_prefix}/bin/i386-*
#%{tools_dir_prefix}/include/c++/%{gcc_version}/i386-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/i386-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/i386-linux
#%{tools_dir_prefix}/libexec/gcc/i386-linux-uclibc/
#%{tools_dir_prefix}/i386-linux-uclibc/
#%{tools_dir_prefix}/i386-linux
#%docdir %{tools_dir_prefix}/man
#%{tools_dir_prefix}/man/man1/i386-*
#
#%files arm
#%defattr(-,root,root)
#%{tools_dir_prefix}/bin/arm-*
#%{tools_dir_prefix}/include/c++/%{gcc_version}/arm-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/arm-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/arm-linux
#%{tools_dir_prefix}/libexec/gcc/arm-linux-uclibc/
#%{tools_dir_prefix}/arm-linux-uclibc/
#%{tools_dir_prefix}/arm-linux
#%docdir %{tools_dir_prefix}/man
#%{tools_dir_prefix}/man/man1/arm-*
#
#%files armeb
#%defattr(-,root,root)
#%{tools_dir_prefix}/bin/armeb-*
#%{tools_dir_prefix}/include/c++/%{gcc_version}/armeb-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/armeb-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/armeb-linux
#%{tools_dir_prefix}/libexec/gcc/armeb-linux-uclibc/
#%{tools_dir_prefix}/armeb-linux-uclibc/
#%{tools_dir_prefix}/armeb-linux
#%docdir %{tools_dir_prefix}/man
#%{tools_dir_prefix}/man/man1/armeb-*
#
#%files powerpc
#%defattr(-,root,root)
#%{tools_dir_prefix}/bin/powerpc-*
#%{tools_dir_prefix}/include/c++/%{gcc_version}/powerpc-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/powerpc-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/powerpc-linux
#%{tools_dir_prefix}/libexec/gcc/powerpc-linux-uclibc/
#%{tools_dir_prefix}/powerpc-linux-uclibc/
#%{tools_dir_prefix}/powerpc-linux
#%docdir %{tools_dir_prefix}/man
#%{tools_dir_prefix}/man/man1/powerpc-*

#%files sh4
#%defattr(-,root,root)
#%{tools_dir_prefix}/bin/sh4-*
#%{tools_dir_prefix}/include/c++/%{gcc_version}/sh4-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/sh4-linux-uclibc/
#%{tools_dir_prefix}/lib/gcc/sh4-linux
#%{tools_dir_prefix}/libexec/gcc/sh4-linux-uclibc/
#%{tools_dir_prefix}/sh4-linux-uclibc/
#%{tools_dir_prefix}/sh4-linux
#%docdir %{tools_dir_prefix}/man
#%{tools_dir_prefix}/man/man1/sh4-*

######################################################################

%post common
rm -f /opt/toolchains/uclibc-crosstools
ln -fs /opt/toolchains/uclibc-crosstools_gcc-%{gcc_version}_uclibc-%{uclibc_version} /opt/toolchains/uclibc-crosstools

%postun common
rm -f /opt/toolchains/uclibc-crosstools
rm -rf %{tools_dir_prefix}

%clean
rm -rf %{tools_dir_prefix}

######################################################################

%changelog
* Thu Apr 28 2005 Ton Truong <ttruong@broadcom.com>
- Removed mips3300 patch.  
- Upgraded uClibc to 20050428 to pick up DNS lookup changes.
* Fri Mar 25 2005 Erik Andersen <andersen@codepoet.org>
- Corrected the gdb build for better uClibc compatibility
* Wed Mar 21 2005 Erik Andersen <andersen@codepoet.org>
- Minor corrections to the 2.6.11 kernel header files.
* Wed Mar 02 2005 Erik Andersen <andersen@codepoet.org>
- Update to binutils 2.15.94.0.2.2, gdb 6.3, and current uClibc snapshot.
  Add some patches from debian and upstream cvs for gcc and binutils.
* Sun Oct 31 2004 Manuel Novoa III <mjn3@codepoet.org>
- Update to binutils 2.15.92.0.2, gdb 6.2.1, and current uClibc snapshot.
  Add some patches from debian and upstream cvs for gcc and binutils.
* Sun Sep 12 2004 Manuel Novoa III <mjn3@codepoet.org>
- Update to gcc 3.4.2 and binutils 2.15.91.0.2.
  Add patches from crosstools (http://kegel.com/crosstool/).
  Add patches from openembedded (http://openembedded.org).
* Thu Aug 31 2004 Manuel Novoa III <mjn3@codepoet.org>
- Add the /opt/toolchains/uclibc-crosstools back.
* Thu Aug 30 2004 Manuel Novoa III <mjn3@codepoet.org>
- Add 32-bit mips-specific binutils patch to force use of 4K elf page size,
  thus reducing the size of the program header in binaries.  This reverts
  to the behavior in binutils 2.14.90.0.x.
* Thu Aug 29 2004 Manuel Novoa III <mjn3@codepoet.org>
- Initial release of a direct port of uClibc toolchain building as an rpm.
  I am sure someone more familiar with spec files could improve this.
