/************************************************************************
 **                                                                    **
 **                          THOMSON                                   **
 **                                                                    **
 ************************************************************************/
/************* COPYRIGHT AND CONFIDENTIALITY INFORMATION *****************
 **                                                                     **
 ** Copyright (c) 2006 Thomson                                          **
 ** All Rights Reserved                                                 **
 **                                                                     **
 ** This program contains proprietary information which is a trade      **
 ** secret of THOMSON and/or its affiliates and also is protected as    **
 ** an unpublished work under applicable Copyright laws. Recipient is   **
 ** to retain this program in confidence and is not permitted to use or **
 ** make copies thereof other than as permitted in a written agreement  **
 ** with THOMSON, UNLESS OTHERWISE EXPRESSLY ALLOWED BY APPLICABLE LAWS.**
 **                                                                     **
 **************************************************************************/


/*
 * ========================================================================
 * 
 *        Filename:  usbhost_atom_mbus_plugin.c
 * 
 *     Description:  Atomic implementation of mbus plug-in for usb host module 
 * 
 *         Version:  1.0
 *         Created:  17/10/2006
 *        Revision:  none
 *        Compiler:  gcc
 * 
 *          Author:  Ruan Youming
 *         Company:  Thomson Broadband
 * 
 * =========================================================================
 */
#ifndef VOIP_MBUS_EXCLUDED

#ifdef    __cplusplus
extern "C"{
#endif

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/poll.h>
#include	<fcntl.h>
#include	<ctype.h>
#include	<limits.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/wait.h>
#include	<a.out.h>

#define MBUS_GENERIC_PLUGIN_COMPAT_VERSION 1 
#include "ctype.h"
#include "stdlib.h"
#include "string.h"
#include "xapi.h"
#include "socket.h"
#include "mbus.h"
#include "mbus_util.h"
#include "usbmgr.h"
#include "stage.h"

static struct usbmgr_config_descriptor  usb_conf_descriptor;
static struct usbmgr_interface_descriptor usb_intf_descriptor;
static struct usbmgr_endpoint_descriptor usb_endp_descriptor;

static unsigned long usbmbus_thread_id = 0;
static char stage_flag = 0;

static unsigned long g_confindex = USB_MAXCONFIG;
static unsigned long g_intfindex = USB_MAXINTERFACES;
static struct node *g_curnode = NULL;


static unsigned long usb_atom_mbus_device_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key);

static void * usb_atom_mbus_device_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx );

static mbus_e_error usb_atom_mbus_host_handler(mbus_t_pcmd_ptr pcmd);

static mbus_e_error usb_atom_mbus_device_handler(mbus_t_pcmd_ptr pcmd);

static unsigned long usb_atom_mbus_host_acc_name(void* p_key, dynstr_t_ptr p_value, int is_set);

static unsigned long usb_atom_mbus_host_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key);

static void * usb_atom_mbus_host_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx );

static unsigned long usb_atom_mbus_dev_acc_number( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_dev_acc_version(void* p_key, dynstr_t_ptr p_value, int is_set);

static unsigned long usb_atom_mbus_dev_acc_devclass( void *p_key, unsigned long *p_value, int is_set );

static unsigned long usb_atom_mbus_dev_acc_devsubclass( void *p_key, unsigned long *p_value, int is_set );

static unsigned long usb_atom_mbus_dev_acc_productid(void* p_key, unsigned long * p_value, int is_set);

static unsigned long usb_atom_mbus_dev_acc_vendorid(void* p_key, unsigned long * p_value, int is_set);

static unsigned long usb_atom_mbus_dev_acc_manufacturer(void* p_key, dynstr_t_ptr p_value, int is_set);

static unsigned long usb_atom_mbus_dev_acc_product(void* p_key, dynstr_t_ptr p_value, int is_set);

static unsigned long usb_atom_mbus_dev_acc_serial(void* p_key, dynstr_t_ptr p_value, int is_set);

static unsigned long usb_atom_mbus_dev_acc_protocol(void* p_key, dynstr_t_ptr p_value, int is_set);

static unsigned long usb_atom_mbus_dev_acc_port (void *p_key, unsigned long *p_value, int p_set);

static unsigned long usb_atom_mbus_dev_acc_speed (void *p_key, unsigned long *p_value, int p_set);

static unsigned long usb_atom_mbus_dev_acc_maxpksize (void *p_key, unsigned long *p_value, int p_set);

static unsigned long usb_atom_mbus_dev_acc_parent(void *p_key, dynstr_t_ptr p_value, int p_set);

static mbus_e_error usb_atom_mbus_conf_handler(mbus_t_pcmd_ptr pcmd);

static unsigned long usb_atom_mbus_conf_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key);

static void * usb_atom_mbus_conf_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx );

static unsigned long usb_conf_atom_mbus_precmd( mbus_t_pcmd_ptr pcmd, void *p_key );

static unsigned long usb_atom_mbus_conf_acc_number( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_conf_acc_attr( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_conf_acc_maxpow (void *p_key, unsigned long *p_value, int p_set);

static mbus_e_error usb_atom_mbus_intf_handler(mbus_t_pcmd_ptr pcmd);

static unsigned long usb_atom_mbus_intf_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key);

static void * usb_atom_mbus_intf_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx );

static unsigned long usb_atom_mbus_intf_precmd( mbus_t_pcmd_ptr pcmd, void *p_key );

static unsigned long usb_atom_mbus_intf_acc_number( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_intf_acc_protocol( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_intf_acc_desc( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_intf_acc_class (void *p_key, unsigned long *p_value, int p_set);

static unsigned long usb_atom_mbus_intf_acc_subclass (void *p_key, unsigned long *p_value, int p_set);

static unsigned long usb_atom_mbus_intf_acc_alter (void *p_key, unsigned long *p_value, int p_set);

static mbus_e_error usb_atom_mbus_endp_handler(mbus_t_pcmd_ptr pcmd);

static unsigned long usb_atom_mbus_endp_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key);

static void * usb_atom_mbus_endp_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx );

static unsigned long usb_atom_mbus_endp_precmd( mbus_t_pcmd_ptr pcmd, void *p_key );

static unsigned long usb_atom_mbus_endp_acc_addr( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_endp_acc_attr( void *p_key, dynstr_t_ptr p_value, int is_set );

static unsigned long usb_atom_mbus_endp_acc_maxpksize (void *p_key, unsigned long *p_value, int p_set);

static unsigned long usb_atom_mbus_endp_acc_interval (void *p_key, unsigned long *p_value, int p_set);


static mbus_t_ctx_ptr usb_create_mbus_ctx( const char *name );

static unsigned long usb_atom_mbus_plugin_init( );

static unsigned long loc_new_thread(char *name,  unsigned long *id, void (*run)());

void usb_mbus_plugin_run(void);

unsigned long usb_mbus_init( void );

extern struct node *find_node_bydevno(struct node *, unsigned short  );
extern struct node *find_node_byuid(struct node *, unsigned short  );


extern unsigned long xt_init(void);

extern struct node *device_ring ;


#define USB_MBUS_PLUGIN_STR           "USB_MBUS"
#define USB_MBUS_TRC_STR                 "[USB_MBUS]"
#define USB_ROOT_OBJ_STR              "USB"
#define USB_HOST_OBJ_STR              "Host"
#define USB_DEVICE_OBJ_STR              "Device"
#define USB_CONF_OBJ_STR              "Configuration"
#define USB_INTF_OBJ_STR              "Interface"
#define USB_ENDP_OBJ_STR              "EndPoint"

#define CHECK_VALID  \
  if (NULL == p_value || MBUS_ENUM_ENDOFLIST == p_key ) return ERR_COM_INV_PARAM;

#define CHECK_VALID2 \
  if ( NULL == pcmd ){ \
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "input pcmd is NULL"); \
    return MBUS_ERR_INVPARAM; \
  }

mbus_t_ctx_ptr s_usb_plugin_ctx = NULL;

extern struct node *find_string_node(struct node *,char *);


static mbus_t_regobjtype s_usb_root_mbus_obj[] =
{
  {
  USB_ROOT_OBJ_STR,
  MBUS_POTF_NONE,
  NULL,
  }
};

mbus_t_regparamtype  s_atom_mbus_usb_host_params[] =
{
  { "Name",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET | MBUS_PPTF_KEY,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=(mbus_t_acc_string_cb)usb_atom_mbus_host_acc_name },
    {.stringtype={0, 64}},
  },             
};


static mbus_t_regobjtype s_usb_host_mbus_obj[] =
{
  {
    USB_HOST_OBJ_STR,
    MBUS_POTF_NONE | MBUS_POTF_MULTI_INSTANCE ,
    usb_atom_mbus_host_handler,
    s_atom_mbus_usb_host_params,
    sizeof(s_atom_mbus_usb_host_params)/sizeof(mbus_t_regparamtype),
    0,
    0,
    usb_atom_mbus_host_convert_key,
    usb_atom_mbus_host_enum_keys,
  }
};


static mbus_t_xrefitem s_usb_host_xref_list[] =
{
  { "USB.Host" }
};

mbus_t_regparamtype  usb_atom_mbus_device_params[] =
{
  { "DeviceNumber",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET | MBUS_PPTF_KEY | MBUS_PPTF_REQ,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_dev_acc_number },
    {.stringtype={0, 6}},
  },             
  { "USBVersion",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_dev_acc_version },
    {.stringtype={0, 6}},
  },  
  { "DeviceClass",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32 ,
    {.uint32_cb=usb_atom_mbus_dev_acc_devclass },
    {.uinttype={0, 255}},
  },         
  { "DeviceSubClass",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=usb_atom_mbus_dev_acc_devsubclass },
    {.uinttype={0, 255}},
  },          
  { "ProductID",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32 ,
    {.uint32_cb=usb_atom_mbus_dev_acc_productid },
    {.uinttype={0, 65535}},
  },         
  { "VendorID",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32 ,
    {.uint32_cb=usb_atom_mbus_dev_acc_vendorid },
    {.uinttype={0, 65535}},
  },             
  { "Manufacturer",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_dev_acc_manufacturer },
    {.stringtype={0, 64}},
  },
  { "Product",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_dev_acc_product},
    {.stringtype={0, 64}},
  },
  { "SerialNumber",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_dev_acc_serial},
    {.stringtype={0, 64}},
  },
  { "Port",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=usb_atom_mbus_dev_acc_port },
    {.uinttype={0, 255}},
  },  
  { "DeviceProtocol",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_dev_acc_protocol},
    {.stringtype={0, 6}},
  },
  { "Speed",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=usb_atom_mbus_dev_acc_speed },
  },             
  { "MaxPacketSize",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=usb_atom_mbus_dev_acc_maxpksize },
  },             
  { "Parent",
    MBUS_PPTF_READ,
    MBUS_PPT_TYPE_XREF,
    {.xref_cb = usb_atom_mbus_dev_acc_parent },
    {.xreftype = {s_usb_host_xref_list, sizeof(s_usb_host_xref_list)/sizeof(mbus_t_xrefitem)} }
  },
};


/*  MBUS_POTF_MULTI_INSTANCE flag: there can be multiple instances of the objecttype
    MBUS_POTF_DYNAMIC flag: all instances are dynamic (i.e. not saved)
    no need for add/delete/commit object callback
    no need for pre_cmd/post_cmd/is_dynamic callback  */  
mbus_t_regobjtype s_usb_device_mbus_obj[] =
{
  {
  USB_DEVICE_OBJ_STR,
  MBUS_POTF_MULTI_INSTANCE | MBUS_POTF_DYNAMIC,
  usb_atom_mbus_device_handler,
  usb_atom_mbus_device_params,
  sizeof(usb_atom_mbus_device_params)/sizeof(mbus_t_regparamtype),
  0,
  NULL,
  usb_atom_mbus_device_convert_key,
  usb_atom_mbus_device_enum_keys,
  }
};



mbus_t_regparamtype  usb_atom_mbus_conf_params[] =
{
  { "ConfigurationNumber",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET | MBUS_PPTF_KEY | MBUS_PPTF_REQ,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=(mbus_t_acc_string_cb)usb_atom_mbus_conf_acc_number },
    {.stringtype={0, 6}},
  },             
  { "Attributes",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=(mbus_t_acc_string_cb)usb_atom_mbus_conf_acc_attr },
    {.stringtype={0, 6}},
  },  
  { "MaxPower",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=(mbus_t_acc_string_cb)usb_atom_mbus_conf_acc_maxpow },
  },             
};


/*  MBUS_POTF_MULTI_INSTANCE flag: there can be multiple instances of the objecttype
    MBUS_POTF_DYNAMIC flag: all instances are dynamic (i.e. not saved)
    no need for add/delete/commit object callback
    no need for pre_cmd/post_cmd/is_dynamic callback  */  

static mbus_t_regobjtype s_usb_conf_mbus_obj[] =
{
  {
    USB_CONF_OBJ_STR,
    MBUS_POTF_MULTI_INSTANCE | MBUS_POTF_DYNAMIC,
    usb_atom_mbus_conf_handler,
    usb_atom_mbus_conf_params,
    sizeof(usb_atom_mbus_conf_params)/sizeof(mbus_t_regparamtype),
    0,
    NULL,
    usb_atom_mbus_conf_convert_key,
    usb_atom_mbus_conf_enum_keys,
    NULL,
    NULL,
    NULL,
    NULL,
    usb_conf_atom_mbus_precmd,
    NULL,
    NULL,
  }
};


mbus_t_regparamtype  usb_atom_mbus_intf_params[] =
{
  { "InterfaceNumber",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET | MBUS_PPTF_KEY | MBUS_PPTF_REQ,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_intf_acc_number },
    {.stringtype={0, 6}},
  },        
  { "InterfaceClass",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32 ,
    {.uint32_cb=usb_atom_mbus_intf_acc_class },
    {.uinttype={0, 255}},
  },         
  { "InterfaceSubClass",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32 ,
    {.uint32_cb=usb_atom_mbus_intf_acc_subclass },
    {.uinttype={0, 255}},
  },             
  { "AlternateSetting",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=usb_atom_mbus_intf_acc_alter },
  },             
  { "InterfaceProtocol",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_intf_acc_protocol },
    {.stringtype={0, 6}},
  },  
  { "DriverDescription",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_intf_acc_desc },
    {.stringtype={0, 64}},
  },  
};

static mbus_t_regobjtype s_usb_intf_mbus_obj[] =
{
  {
    USB_INTF_OBJ_STR,
    MBUS_POTF_MULTI_INSTANCE | MBUS_POTF_DYNAMIC,
    usb_atom_mbus_intf_handler,
    usb_atom_mbus_intf_params,
    sizeof(usb_atom_mbus_intf_params)/sizeof(mbus_t_regparamtype),
    0,
    NULL,
    usb_atom_mbus_intf_convert_key,
    usb_atom_mbus_intf_enum_keys,
    NULL,
    NULL,
    NULL,
    NULL,
    usb_atom_mbus_intf_precmd,
    NULL,
    NULL,
  }
};

mbus_t_regparamtype  usb_atom_mbus_endp_params[] =
{
  { "EndpointAddress",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET | MBUS_PPTF_KEY | MBUS_PPTF_REQ,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_endp_acc_addr },
    {.stringtype={0, 6}},
  },        
  { "Attributes",
    MBUS_PPTF_READ | MBUS_PPTF_MAXSET,
    MBUS_PPT_TYPE_STRING,
    {.string_cb=usb_atom_mbus_endp_acc_attr },
    {.stringtype={0, 6}},
  },  
  { "MaxPacketSize",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=usb_atom_mbus_endp_acc_maxpksize },
  },         
  { "IntervalTime",
    MBUS_PPTF_READ  ,
    MBUS_PPT_TYPE_UINT32,
    {.uint32_cb=usb_atom_mbus_endp_acc_interval },
  },             
};

static mbus_t_regobjtype s_usb_endp_mbus_obj[] =
{
  {
    USB_ENDP_OBJ_STR,
    MBUS_POTF_MULTI_INSTANCE | MBUS_POTF_DYNAMIC,
    usb_atom_mbus_endp_handler,
    usb_atom_mbus_endp_params,
    sizeof(usb_atom_mbus_endp_params)/sizeof(mbus_t_regparamtype),
    0,
    NULL,
    usb_atom_mbus_endp_convert_key,
    usb_atom_mbus_endp_enum_keys,
    NULL,
    NULL,
    NULL,
    NULL,
    usb_atom_mbus_endp_precmd,
    NULL,
    NULL,
  }
};



void usb_host_getname( unsigned long index, char *name  )
{
   if( NULL == name )
   	return;
   
   name[0] = '\0';
   strcpy( name, "usbhost_1" );
   return ;
}

static unsigned long loc_get_conf_index( struct node *cur_node, unsigned long conf_no )
{
    int i = 0;
    unsigned long conf_index = USB_MAXCONFIG;
	
   for( i = 0; i < USB_DEV_NUMCONF( NODE2DEV( cur_node ) ); i++ )
   {
       if( conf_no  == USB_CONF_CONFNO( NODE2DEV(cur_node), i ) )
       {
          conf_index = i;
   	   break;
       }
    }
    if( i ==  USB_DEV_NUMCONF( NODE2DEV( cur_node ) ) )
    {
       return USB_MAXCONFIG;
    }
    return conf_index;
   
}

static unsigned long loc_get_intf_index( struct node *cur_node, unsigned long conf_index, unsigned long intf_no )
{
   int i = 0;
   unsigned long intf_index = USB_MAXINTERFACES;

   for( i = 0; i < USB_CONF_NUMINTF( NODE2DEV( cur_node ), conf_index ); i++ )
   {
       if( intf_no  == USB_INTF_INTFNO( NODE2DEV(cur_node), conf_index, i ) )
       {
          intf_index = i;
   	   break;
       }
    }
    if( i ==  USB_CONF_NUMINTF( NODE2DEV( cur_node ), conf_index ) )
    {
       return USB_MAXINTERFACES;
    }
    return intf_index;
   
}

static unsigned long loc_get_endp_index( struct node *cur_node, unsigned long conf_index,  unsigned long intf_index , unsigned long endp_addr )
{
   int i = 0;
   unsigned long endp_index = USB_MAXENDPOINTS;

   for( i = 0; i < USB_INTF_NUMENDP( NODE2DEV( cur_node ), conf_index, intf_index ); i++ )
   {
       if( endp_addr  == USB_ENDP_ADDR( NODE2DEV(cur_node), conf_index, intf_index, i ) )
       {
          endp_index = i;
   	   break;
       }
    }
    if( i ==  USB_INTF_NUMENDP( NODE2DEV( cur_node ), conf_index, intf_index ) )
    {
       return USB_MAXINTERFACES;
    }
    return endp_index;
   
}

static unsigned long usb_atom_mbus_device_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key)
{
  unsigned long error = ERR_NO_ERROR;
  struct node *cur_node = NULL;

  if (keystr == NULL || key == NULL) return ERR_COM_INV_PARAM;

  if (dynstr_strlen(keystr) > 0 )
  {
    /*look on the node of the device link as the internal key */
    unsigned long devno = 0;  
    dynstr_getulong( keystr, &devno );
    cur_node = find_node_byuid( device_ring, (unsigned short) devno );
    if( NULL == cur_node )   /*if the node isn't existing*/
    {
      TR_MBUS_ERR(USB_MBUS_TRC_STR, "can't find the keystr: %d", devno );
      return ERR_COM_UNEXP_COND;
    }
    *((struct node **)key) = cur_node;
  }
  else
  {
    cur_node = find_node( device_ring, * ((struct node **)key) );
    if( NULL == cur_node )  /*if the node isn't existing*/
    {
       TR_MBUS_ERR(USB_MBUS_TRC_STR, "can't find the key: %d",  * ((struct node **)key)  );
       return ERR_COM_UNEXP_COND;
    }
    error = dynstr_setulong( keystr, (unsigned long)DEVICE_UID( NODE2DEV(cur_node) ) );
  }
  return error;
}

#if 0
static void * usb_atom_mbus_device_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx )
{
  struct node *np = NULL;

  if( ( NULL == p_ctx ) || ( NULL == device_ring ) || ( NULL ==  pcmd ) )
  {
    return MBUS_ENUM_ENDOFLIST;
  }

  if ( (*p_ctx) == MBUS_ENUM_UNINITIALIZED )
  {
     *((struct node **)p_ctx) = device_ring;
     return (void *)(*(struct node **)p_ctx);
    // if ( NODE_STATUS(device_ring) == USBMGR_ST_ACTIVE )
     {
       //return *((struct node **)p_ctx);
     }
  }

 for( np = (*((struct node **)p_ctx))->next; np != device_ring; np=np->next )
 {
    //if ( NODE_STATUS(np ) == USBMGR_ST_ACTIVE )
    {
       *(struct node **)p_ctx = np;
       return (void *)np;
    }
 }
 
  return MBUS_ENUM_ENDOFLIST;

}
#else   /*hide the root hub*/
static void * usb_atom_mbus_device_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx )
{
  struct node *np = NULL;

  if( ( NULL == p_ctx ) || ( NULL == device_ring ) || ( NULL ==  pcmd ) )
  {
    return MBUS_ENUM_ENDOFLIST;
  }
  if ( (*p_ctx) == MBUS_ENUM_UNINITIALIZED )
  {
     np = device_ring;
     *(struct node **)p_ctx = np;
     /*check if it is root hub*/
     if( 1 != USB_DEV_DEVNO( NODE2DEV(np) ) )
     {
       return (void *)np;
     }
  }

  for( np = (*((struct node **)p_ctx))->next; np != device_ring; np=np->next )
  {
     /*check if it is root hub*/
     if( 1 == USB_DEV_DEVNO( NODE2DEV(np) ) )
     {
        continue;
     }
      *(struct node **)p_ctx = np;
      return (void *)np;
  }
 
  return MBUS_ENUM_ENDOFLIST;

}
#endif


static mbus_e_error usb_atom_mbus_host_handler(mbus_t_pcmd_ptr pcmd)
{
  mbus_e_error      error = MBUS_ERR_NOERROR;

  CHECK_VALID2
  error = mbus_plugin_process_cmds(s_usb_plugin_ctx, pcmd, s_usb_host_mbus_obj);
  return error;
  
}


static mbus_e_error usb_atom_mbus_device_handler(mbus_t_pcmd_ptr pcmd)
{
  mbus_e_error      error = MBUS_ERR_NOERROR;
  unsigned long dev_no = 0xFFFF;

  CHECK_VALID2
  if( !((MBUS_PCMD_ADDOBJECT == pcmd ->type)  || ( MBUS_PCMD_GETINSTANCEKEYS == pcmd ->type )) )
  {
     strlist_getulong_at( pcmd->objectpath,&dev_no,  -1);
     /*get current device object node*/
     g_curnode = find_node_byuid( device_ring, (unsigned short) dev_no );
     if( NULL == g_curnode )
     {
       return MBUS_ERR_NOERROR;
     }
  }

  error = mbus_plugin_process_cmds(s_usb_plugin_ctx, pcmd, s_usb_device_mbus_obj);
  return error;
}

static unsigned long usb_atom_mbus_host_acc_name(void* p_key, dynstr_t_ptr p_value, int is_set)
{
  mbus_e_error rc = MBUS_ERR_NOERROR;
  char name[20];

  CHECK_VALID

  if( !is_set )
  {
    usb_host_getname( (unsigned long )p_key, name  );
    rc = dynstr_setstring( p_value, name );
  }
  
  return rc;
}

static unsigned long usb_atom_mbus_host_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key)
{
  unsigned long error = ERR_NO_ERROR;
  char name[20];
  
   /*convert key from keystr to key*/
  if ( dynstr_strlen( keystr ) > 0 )
  {
     *( ( int * )key ) = 0;
  }
  /*convert key from key to keystr*/
  else if ( *key != MBUS_ENUM_UNINITIALIZED )
  {
    usb_host_getname( (unsigned long )key, name  );
    error = dynstr_setstring( keystr, name );
  }

  return error;
}

/*at present , only one host is supported*/
static void * usb_atom_mbus_host_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx )
{
  if( ( NULL == p_ctx ) || ( NULL == pcmd ) )
  {
    return MBUS_ENUM_ENDOFLIST;
  }

  if ( (*p_ctx) == MBUS_ENUM_UNINITIALIZED )
  {
       *(int *)p_ctx = 0;
  }
  else
  {
    return MBUS_ENUM_ENDOFLIST;
  }
 
  return (void *)(*p_ctx);

}



static unsigned long usb_atom_mbus_dev_acc_number( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_sprintf( p_value, "%d", DEVICE_UID( NODE2DEV(( (struct node *)p_key) )));
   }
   return rc;
}

static unsigned long usb_atom_mbus_dev_acc_version(void* p_key, dynstr_t_ptr p_value, int is_set)
{
  mbus_e_error rc = MBUS_ERR_NOERROR;

  CHECK_VALID

  if( !is_set )
  {
    rc = dynstr_sprintf( p_value, "%.2f", USB_DEV_VERION( NODE2DEV(( (struct node *)p_key) )));
  }
  
  return rc;
}


static unsigned long usb_atom_mbus_dev_acc_devclass( void *p_key,  unsigned long *p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
     *( unsigned long * )p_value = USB_DEV_CLASS( NODE2DEV(( (struct node *)p_key)));
   }
   return rc;
}

static unsigned long usb_atom_mbus_dev_acc_devsubclass( void *p_key, unsigned long *p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
     *( unsigned long * )p_value = USB_DEV_SUBCLASS( NODE2DEV(( (struct node *)p_key)));
   }
   return rc;
}


#if 0
static unsigned long usb_atom_mbus_dev_acc_devversion(void* p_key, dynstr_t_ptr p_value, int is_set)
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
     rc = dynstr_setstring( p_value, "1.0" );
   }
   return MBUS_ERR_NOERROR;
}
#endif

static unsigned long usb_atom_mbus_dev_acc_productid(void* p_key, unsigned long * p_value, int is_set)
{
   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
     *( unsigned long * )p_value = USB_DEV_PRODID( NODE2DEV(( (struct node *)p_key)));
   }
   return MBUS_ERR_NOERROR;
}

static unsigned long usb_atom_mbus_dev_acc_vendorid(void* p_key, unsigned long * p_value, int is_set)
{
   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
     *( unsigned long * )p_value = USB_DEV_VENDOR( NODE2DEV(( (struct node *)p_key)));
   }
   return MBUS_ERR_NOERROR;
}

static unsigned long usb_atom_mbus_dev_acc_manufacturer(void* p_key, dynstr_t_ptr p_value, int is_set)
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_setstring( p_value, USB_DEV_MANUFACTURER( NODE2DEV(( (struct node *)p_key))));
   }
   return rc;
}

static unsigned long usb_atom_mbus_dev_acc_product(void* p_key, dynstr_t_ptr p_value, int is_set)
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_setstring( p_value, USB_DEV_PRODUCT( NODE2DEV(( (struct node *)p_key))));
   }
   return rc;
}


static unsigned long usb_atom_mbus_dev_acc_serial(void* p_key, dynstr_t_ptr p_value, int is_set)
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_setstring( p_value, USB_DEV_SERIALNO( NODE2DEV(( (struct node *)p_key))));
   }
   return rc;
}
static unsigned long usb_atom_mbus_dev_acc_protocol(void* p_key, dynstr_t_ptr p_value, int is_set)
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_sprintf( p_value, "0x%x", USB_DEV_PROTOCOL( NODE2DEV(( (struct node *)p_key))));
   }
   return rc;
}


static unsigned long usb_atom_mbus_dev_acc_port (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = USB_DEV_PORT( NODE2DEV(( (struct node *)p_key)));
  }
  
  return MBUS_ERR_NOERROR;
}

static unsigned long usb_atom_mbus_dev_acc_speed (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = USB_DEV_SPEED( NODE2DEV(( (struct node *)p_key)));
  }
  
  return MBUS_ERR_NOERROR;
}


static unsigned long usb_atom_mbus_dev_acc_maxpksize (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = USB_DEV_MAXPKSIZE( NODE2DEV(( (struct node *)p_key)));
  }
  
  return MBUS_ERR_NOERROR;
}


static unsigned long usb_atom_mbus_dev_acc_parent(void *p_key, dynstr_t_ptr p_value, int p_set)
{
  unsigned long error = ERR_NO_ERROR;
  char name[20];
  char value[30];
 
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
    usb_host_getname( 0, name );
    value[0] = '\0';
    sprintf( value, "%s.%s", (&s_usb_host_xref_list[0])->objtypepath, name );
    error = dynstr_setstring( p_value, value);
  }
  return error;
}


static mbus_e_error usb_atom_mbus_conf_handler(mbus_t_pcmd_ptr pcmd)
{
  mbus_e_error      error = MBUS_ERR_NOERROR;
  unsigned long dev_no = 0xFFFF;

  CHECK_VALID2

  if( (MBUS_PCMD_ADDOBJECT == pcmd ->type)  || ( MBUS_PCMD_GETINSTANCEKEYS == pcmd ->type ) )
  { /*if cmdtype is add-object, the object path equals to objtype path*/
    strlist_getulong_at( pcmd->objectpath, &dev_no,  -2);
  }
  else
  { 
    strlist_getulong_at( pcmd->objectpath,&dev_no,  -3);
  }
  /*get current device object node*/
  g_curnode = find_node_byuid( device_ring, (unsigned short) dev_no );
  if( NULL == g_curnode )
  {
    return MBUS_ERR_NOERROR;
  }
  error = mbus_plugin_process_cmds(s_usb_plugin_ctx, pcmd, s_usb_conf_mbus_obj);
  return error;
}


static unsigned long usb_atom_mbus_conf_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key)
{
  unsigned long rc = ERR_NO_ERROR;
  unsigned long conf_no = 0xFFFF;

  if (keystr == NULL || key == NULL) return ERR_COM_INV_PARAM;

  if (dynstr_strlen(keystr) > 0 )
  {
     rc = dynstr_getulong( keystr,  &conf_no );
     *((unsigned long*)key) = loc_get_conf_index( g_curnode,  conf_no );
  }
  else
  {
     conf_no = USB_CONF_CONFNO( NODE2DEV( g_curnode ), *((unsigned long*)key));
     rc = dynstr_setulong( keystr,  conf_no );
  }
  return rc;
}

static void * usb_atom_mbus_conf_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx )
{
  if( ( NULL == p_ctx ) || ( NULL == pcmd ) )
  {
     return MBUS_ENUM_ENDOFLIST;
  }
  if ( (*p_ctx) != MBUS_ENUM_UNINITIALIZED )
  {
     *(int *)p_ctx = *(int *)p_ctx + 1;
   }
  else
  {
     *(int *)p_ctx = 0;
  }
  
  if( *(int *)p_ctx < USB_DEV_NUMCONF( NODE2DEV( g_curnode )))
  {
     return (void *)(*p_ctx);
  }
  else
  {
     return MBUS_ENUM_ENDOFLIST;
  }
  return MBUS_ENUM_ENDOFLIST;
}




/*This function is responsilbe for get data from daemon before any plugin command is executed*/
/*and then the data is saved locally in plugin*/
static unsigned long usb_conf_atom_mbus_precmd( mbus_t_pcmd_ptr pcmd, void *p_key )
{
   
 #ifndef NDEBUG
   if (p_key == MBUS_ENUM_UNINITIALIZED || pcmd == NULL)
   {
          return MBUS_ERR_INVPARAM;
   }
 #endif  

   memcpy( &usb_conf_descriptor, &(USB_CONF_DESCRIPTOR( NODE2DEV(g_curnode),( unsigned long )p_key )),sizeof( struct usbmgr_config_descriptor ) ) ;
 
   return ERR_NO_ERROR;
}



static unsigned long usb_atom_mbus_conf_acc_number( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_setulong(p_value, usb_conf_descriptor.iConfiguration );
   }
   return rc;
}

static unsigned long usb_atom_mbus_conf_acc_attr( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_sprintf( p_value, "0x%x", usb_conf_descriptor.bmAttributes );
   }
   return rc;
}


static unsigned long usb_atom_mbus_conf_acc_maxpow (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = usb_conf_descriptor.MaxPower;
  }
  
  return MBUS_ERR_NOERROR;
}

static mbus_e_error usb_atom_mbus_intf_handler(mbus_t_pcmd_ptr pcmd)
{
  mbus_e_error      error = MBUS_ERR_NOERROR;
  unsigned long dev_no = 0xFFFF;
  unsigned long conf_no = 0xFFFF;

  CHECK_VALID2

  if( (MBUS_PCMD_ADDOBJECT == pcmd ->type)  || ( MBUS_PCMD_GETINSTANCEKEYS == pcmd ->type ) )
  { /*if cmdtype is add-object, the object path equals to objtype path*/
    strlist_getulong_at( pcmd->objectpath, &dev_no,  -4);
    strlist_getulong_at( pcmd->objectpath, &conf_no,  -2);
  }
  else
  { 
    strlist_getulong_at( pcmd->objectpath,&dev_no,  -5);
    strlist_getulong_at( pcmd->objectpath,&conf_no,  -3);
  }
  /*get current device object node*/
  g_curnode = find_node_byuid( device_ring, (unsigned short) dev_no );
  if( NULL == g_curnode )
  {
   return MBUS_ERR_NOERROR;
  }
  
  /*get current configuration object index*/
  g_confindex = loc_get_conf_index( g_curnode, conf_no );
  if( USB_MAXCONFIG == g_confindex )
  {
    return MBUS_ERR_ACTIONFAILED;
  }
 
  error = mbus_plugin_process_cmds(s_usb_plugin_ctx, pcmd, s_usb_intf_mbus_obj);
  return error;
}

static unsigned long usb_atom_mbus_intf_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key)
{
  unsigned long rc = ERR_NO_ERROR;
  unsigned long intf_no = 0xFFFF;

  if (keystr == NULL || key == NULL) return ERR_COM_INV_PARAM;

  if (dynstr_strlen(keystr) > 0 )
  {
     rc = dynstr_getulong( keystr,  &intf_no );
     *((unsigned long*)key) = loc_get_intf_index( g_curnode, g_confindex, intf_no );
  }
  else
  {
     intf_no = ( unsigned long )USB_INTF_INTFNO( NODE2DEV( g_curnode ), g_confindex,*((unsigned long*)key));
     rc = dynstr_setulong( keystr,  intf_no );
  }
  return rc;
}


static void * usb_atom_mbus_intf_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx )
{

  if( ( NULL == p_ctx ) || ( NULL == pcmd ) )
  {
    return MBUS_ENUM_ENDOFLIST;
  }
  
  if ( (*p_ctx) != MBUS_ENUM_UNINITIALIZED )
  {
     *(int *)p_ctx = *(int *)p_ctx + 1;
   }
  else
  {
     *(int *)p_ctx = 0;
  }
  
  if( *(int *)p_ctx < USB_CONF_NUMINTF( NODE2DEV( g_curnode ), g_confindex ) )
  {
     return ( void * )(*p_ctx);
  }
  else
  {
     return MBUS_ENUM_ENDOFLIST;
  }
  return MBUS_ENUM_ENDOFLIST;
}


/*This function is responsilbe for get data from daemon before any plugin command is executed*/
/*and then the data is saved locally in plugin*/
static unsigned long usb_atom_mbus_intf_precmd( mbus_t_pcmd_ptr pcmd, void *p_key )
{
   unsigned long rc = ERR_NO_ERROR;

 #ifndef NDEBUG
   if (p_key == MBUS_ENUM_UNINITIALIZED || pcmd == NULL)
   {
          return MBUS_ERR_INVPARAM;
   }
 #endif  

 memcpy( &usb_intf_descriptor, &(USB_INTF_DESCRIPTOR( NODE2DEV((struct node *)g_curnode),g_confindex, ( unsigned long )p_key )),sizeof( struct usbmgr_interface_descriptor ) ) ;
 
  return rc;
}


static unsigned long usb_atom_mbus_intf_acc_number( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_setulong(p_value, usb_intf_descriptor.iInterface );
   }
   return rc;
}


static unsigned long usb_atom_mbus_intf_acc_protocol( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_sprintf( p_value, "0x%x", usb_intf_descriptor.bInterfaceProtocol );
   }
   return rc;
}

static unsigned long usb_atom_mbus_intf_acc_desc( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_sprintf( p_value, "%s", usb_intf_descriptor.cDriverDesc );
   }
   return rc;
}

static unsigned long usb_atom_mbus_intf_acc_class (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = usb_intf_descriptor.bInterfaceClass ;
  }
  
  return MBUS_ERR_NOERROR;
}

static unsigned long usb_atom_mbus_intf_acc_subclass (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = usb_intf_descriptor.bInterfaceSubClass ;
  }
  
  return MBUS_ERR_NOERROR;
}

static unsigned long usb_atom_mbus_intf_acc_alter (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = usb_intf_descriptor.bAlternateSetting ;
  }
  
  return MBUS_ERR_NOERROR;
}

static mbus_e_error usb_atom_mbus_endp_handler(mbus_t_pcmd_ptr pcmd)
{
  mbus_e_error      error = MBUS_ERR_NOERROR;
  unsigned long dev_no = 0xFFFF;
  unsigned long conf_no = 0xFFFF;
  unsigned long intf_no = 0xFFFF;

  CHECK_VALID2

  if( (MBUS_PCMD_ADDOBJECT == pcmd ->type)  || ( MBUS_PCMD_GETINSTANCEKEYS == pcmd ->type ) )
  { /*if cmdtype is add-object, the object path equals to objtype path*/
    strlist_getulong_at( pcmd->objectpath, &dev_no,  -6);
    strlist_getulong_at( pcmd->objectpath, &conf_no,  -4);
    strlist_getulong_at( pcmd->objectpath, &intf_no,  -2);
  }
  else
  { 
    strlist_getulong_at( pcmd->objectpath,&dev_no,  -7);
    strlist_getulong_at( pcmd->objectpath,&conf_no,  -5);
    strlist_getulong_at( pcmd->objectpath, &intf_no,  -3);
  }

  /*get current device object node*/
  g_curnode = find_node_byuid( device_ring, (unsigned short) dev_no );
  if( NULL == g_curnode )
  {
    return MBUS_ERR_NOERROR;
  }
  
  /*get current configuration object index*/
  g_confindex = loc_get_conf_index( g_curnode, conf_no );
  if( USB_MAXCONFIG == g_confindex )
  {
    return MBUS_ERR_ACTIONFAILED;
  }
  
  /*get current interface object index*/
  g_intfindex = loc_get_intf_index( g_curnode, g_confindex, intf_no );
  if( USB_MAXINTERFACES == g_intfindex )
  {
    return MBUS_ERR_ACTIONFAILED;
  }

  error = mbus_plugin_process_cmds(s_usb_plugin_ctx, pcmd, s_usb_endp_mbus_obj);
  return error;
}

static unsigned long usb_atom_mbus_endp_convert_key(mbus_t_pcmd_ptr pcmd, dynstr_t_ptr keystr, void **key)
{
  unsigned long rc = ERR_NO_ERROR;
  unsigned long endp_no = 0xFFFF;

  if (dynstr_strlen(keystr) > 0 )
  {
     rc = dynstr_getulong( keystr,  &endp_no );
     *((unsigned long*)key) = loc_get_endp_index( g_curnode, g_confindex, g_intfindex,endp_no );
  }
  else
  {
     endp_no = USB_ENDP_ADDR( NODE2DEV( g_curnode ), g_confindex, g_intfindex, *((unsigned long*)key));
     rc = dynstr_setulong( keystr,  endp_no );
  }
  
  return rc;
}


static void * usb_atom_mbus_endp_enum_keys(mbus_t_pcmd_ptr pcmd, void** p_ctx )
{

  if( ( NULL == p_ctx ) || ( NULL == pcmd ) )
  {
    return MBUS_ENUM_ENDOFLIST;
  }
  
  if ( (*p_ctx) != MBUS_ENUM_UNINITIALIZED )
  {
     *(int *)p_ctx = *(int *)p_ctx + 1;
   }
  else
  {
     *(int *)p_ctx = 0;
  }
  
  if( *(int *)p_ctx < USB_INTF_NUMENDP( NODE2DEV( g_curnode ), g_confindex, g_intfindex ) ) 
  {
     return (void *)(*p_ctx);
  }
  else
  {
     return MBUS_ENUM_ENDOFLIST;
  }

  return MBUS_ENUM_ENDOFLIST;
}

static unsigned long usb_atom_mbus_endp_precmd( mbus_t_pcmd_ptr pcmd, void *p_key )
{
   unsigned long rc = ERR_NO_ERROR;

 #ifndef NDEBUG
   if (p_key == MBUS_ENUM_UNINITIALIZED || pcmd == NULL)
   {
          return MBUS_ERR_INVPARAM;
   }
 #endif  
  memcpy( &usb_endp_descriptor, &(USB_ENDP_DESCRIPTOR( NODE2DEV((struct node *)g_curnode),g_confindex, g_intfindex, ( unsigned long )p_key  )),sizeof( usb_endp_descriptor) ) ;
 
  return rc;
}

static unsigned long usb_atom_mbus_endp_acc_addr( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_sprintf( p_value, "0x%x", usb_endp_descriptor.bEndpointAddress );
   }
   return rc;
}

static unsigned long usb_atom_mbus_endp_acc_attr( void *p_key, dynstr_t_ptr p_value, int is_set )
{
   mbus_e_error rc = MBUS_ERR_NOERROR;

   CHECK_VALID

   if ( is_set ) 
   {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
   } 
   else 
   {
      rc = dynstr_sprintf( p_value, "0x%x", usb_endp_descriptor.bmAttributes );
   }
   return rc;
}


static unsigned long usb_atom_mbus_endp_acc_maxpksize (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = usb_endp_descriptor.wMaxPacketSize ;
  }
  
  return MBUS_ERR_NOERROR;
}


static unsigned long usb_atom_mbus_endp_acc_interval (void *p_key, unsigned long *p_value, int p_set)
{
  CHECK_VALID
  if(p_set)
  {
      /*illegal operation, this is a readonly parameter*/
      return MBUS_ERR_INVCMD;   
  }
  else
  {
     *( unsigned long * )p_value = usb_endp_descriptor.bInterval ;
  }
  
  return MBUS_ERR_NOERROR;
}




static mbus_t_ctx_ptr usb_create_mbus_ctx( const char *name )
{
  mbus_t_ctx_ptr ctx;
  unsigned long rc;

  ctx = mbus_ctx_create(name);
  if (ctx == NULL) 
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "mbus context creation failed (%s)", name);
    return NULL;
  }
  mbus_ctx_setdatamodel(ctx, MBUS_DM_ATOMIC);
  
  rc = mbus_ctx_init_sk_local( ctx, name, 1 );
  if (rc != MBUS_ERR_NOERROR) 
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "mbus socket creation failed (%s)", name);
    return NULL;
  }
  rc = mbus_invoke_register(ctx);
  if (rc != MBUS_ERR_NOERROR) 
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "mbus context registration failed (%s)", name);
    return NULL;
  }
  TR_MBUS_INFO(USB_MBUS_TRC_STR, "mbus context successfully registered (%s)", name);

  return ctx;
}


/******************************************************
* usb host mbus plugin initialization                     *
*******************************************************/
static unsigned long usb_atom_mbus_plugin_init( )
{
  mbus_e_error rc = MBUS_ERR_NOERROR;
  mbus_t_ppath usb_path = {USB_ROOT_OBJ_STR, NULL};
  mbus_t_ppath usb_host_path = {USB_HOST_OBJ_STR, &usb_path};
  mbus_t_ppath usb_dev_path = {USB_DEVICE_OBJ_STR, &usb_host_path};
  mbus_t_ppath usb_conf_path = {USB_CONF_OBJ_STR, &usb_dev_path};
  mbus_t_ppath usb_intf_path = {USB_INTF_OBJ_STR, &usb_conf_path};


  //register USB object
  rc = mbus_invoke_regobjtypes(s_usb_plugin_ctx, NULL, s_usb_root_mbus_obj, 
                                   sizeof(s_usb_root_mbus_obj)/sizeof(mbus_t_regobjtype)) ;
  if( rc != MBUS_ERR_NOERROR )
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "%s registration failed (%d).", USB_ROOT_OBJ_STR, rc );
    return rc;
  }

  //register USB.Host object
  rc = mbus_invoke_regobjtypes(s_usb_plugin_ctx, &usb_path, s_usb_host_mbus_obj, 
                                   sizeof(s_usb_host_mbus_obj)/sizeof(mbus_t_regobjtype));
  if( rc != MBUS_ERR_NOERROR )
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "%s registration failed (%d).", USB_HOST_OBJ_STR, rc );
    return rc;
  }

  //register USB.Host.Device object
  rc = mbus_invoke_regobjtypes(s_usb_plugin_ctx, &usb_host_path, s_usb_device_mbus_obj, 
                                   sizeof(s_usb_device_mbus_obj)/sizeof(mbus_t_regobjtype));
  if( rc != MBUS_ERR_NOERROR )
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "%s registration failed (%d).", USB_DEVICE_OBJ_STR, rc );
    return rc;
  }
  //register USB.Host.Device.Configuration object
  rc = mbus_invoke_regobjtypes(s_usb_plugin_ctx, &usb_dev_path, s_usb_conf_mbus_obj, 
                                   sizeof(s_usb_conf_mbus_obj)/sizeof(mbus_t_regobjtype)) ;
  if( rc != MBUS_ERR_NOERROR )
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "%s registration failed ( %d ).", USB_CONF_OBJ_STR, rc );
    return rc;
  }
  //register USB.Host.Device.Configuration.Interface object
  rc  = mbus_invoke_regobjtypes(s_usb_plugin_ctx, &usb_conf_path, s_usb_intf_mbus_obj, 
                                   sizeof(s_usb_intf_mbus_obj)/sizeof(mbus_t_regobjtype));
  if( rc != MBUS_ERR_NOERROR )
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "%s registration failed (%d).", USB_INTF_OBJ_STR, rc );
    return rc;
  }
  //register USB.Host.Device.Configuration.Interface.EndPoint object
  rc  = mbus_invoke_regobjtypes(s_usb_plugin_ctx, &usb_intf_path, s_usb_endp_mbus_obj, 
                                   sizeof(s_usb_endp_mbus_obj)/sizeof(mbus_t_regobjtype));
  if( rc != MBUS_ERR_NOERROR )
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "%s registration failed (%d).", USB_ENDP_OBJ_STR, rc );
    return rc;
  }
 TR_MBUS_WARN(USB_MBUS_TRC_STR, "Plugin '%s' successfully registered!", USB_MBUS_PLUGIN_STR);

  memset( &usb_conf_descriptor, 0 , sizeof( usb_conf_descriptor ) );
  memset( &usb_intf_descriptor, 0 , sizeof( usb_intf_descriptor ) );
  memset( &usb_endp_descriptor, 0 , sizeof( usb_endp_descriptor ) );

  return ERR_NO_ERROR;
  
}

static int print_std_out(char *ch, int req_len)
{
  return write(STDOUT_FILENO, ch, req_len);
}


static unsigned long loc_new_thread(char *name,  unsigned long *id, void (*run)())
{
  unsigned long rc;

  rc = xt_create(name, 0, 0, 0, 0, id);
  if (rc != ERR_NO_ERROR) 
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "Thread '%s' creation failed.", name);
    return rc;
  }
  rc = xt_start(*id, 0, run, NULL);
  if (rc != ERR_NO_ERROR)
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "Thread '%s' start failed.", name);
    return rc;
  }
  TR_MBUS_WARN(USB_MBUS_TRC_STR, "succeed to create listening thread");
  return ERR_NO_ERROR;
}

unsigned long usb_mbus_init( void )
{
   unsigned long rc = ERR_NO_ERROR;

  /* Thread/task init */
  rc = xt_init();
  if (rc != ERR_NO_ERROR) {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "usb_mbus_init: xt_init failed");
    return 1;
  }
  
  dbg_init(0, print_std_out);

   /* Memory manager init */
   rc = memm_init( 15  /* max memmanager pools */,
                   5    /* max dynstring pools */);
   if (rc != ERR_NO_ERROR) 
   {
     TR_MBUS_ERR(USB_MBUS_TRC_STR, "application_init: memm_init failed" );
     return 1;
   }
   
   /* Initialize mbus library */
   rc = mbus_init(MBUS_VERSION,   2 /* max_contexts */,
                               100      /* max_dynstrings */, 
                               8192    /* max_dynstr buffer */,
                               100     /* max_llist_items */, 
                                50     /* max cmddata objects */, 
                                30      /* max filters */,
                                30      /* max objtype_cb objects */,
                                 5      /* max subscriptioncb objects */);
   
   if (rc != MBUS_ERR_NOERROR) 
   {
     TR_MBUS_ERR(USB_MBUS_TRC_STR, "application_init: mbus_init failed" );
     return 1;
   }
   
   /*create mbus client*/
   s_usb_plugin_ctx = usb_create_mbus_ctx( USB_MBUS_PLUGIN_STR );
   if ( NULL == s_usb_plugin_ctx ) 
   {
     return ERR_COM_UNEXP_COND;
   }

   rc = usb_atom_mbus_plugin_init();
   if( MBUS_ERR_NOERROR != rc )
   {
      return rc;
   }
  //wait_until_stage(69);

   /* create and start MBus client thread */
   rc = loc_new_thread("usbmbus", &usbmbus_thread_id, usb_mbus_plugin_run );
   
   return rc;
   
}

unsigned long usb_device_sndevent_add_del( unsigned long host_key, unsigned long key, int del )
{
  unsigned long flags=0;
  dynstr_t_ptr dyn_path = NULL;
  dynstr_t_ptr dyn_keystr = NULL;
  char name[20];

  /*hide the root hub*/
  #if  1  
  /*check if it is root hub*/
  if( 1 == key )
  {
    return ERR_NO_ERROR;
  }
  #endif

  /*the flag assure that the stage judgement is just done during booting*/
  if( 0 == stage_flag )
  {
     if( staging_is_active() )
     {
        return ERR_NO_ERROR;
     }
     else
     {
        stage_flag = 1;
     }
  }

  usb_host_getname( host_key,  name);

  dyn_path = memm_calloc(mbus_dynstr_poolid());
  dyn_keystr = dynstr_fromulong(mbus_dynstr_poolid(), key );
  if( (NULL == dyn_path) || (NULL == dyn_keystr) )
  {
    TR_MBUS_ERR( USB_MBUS_TRC_STR, " Failed to alloc the memory , poolid = %d \r\n", mbus_dynstr_poolid() );
     return ERR_COM_NO_RESOURCES;
  }
  dynstr_sprintf( dyn_path, "USB.Host.%s.Device" , name  );
  
  flags |= MBUS_PEV_NONE;
  if ( mbus_invoke_event_object_add_del( s_usb_plugin_ctx, dyn_path, dyn_keystr, del, flags ) != MBUS_ERR_NOERROR )
  {
    TR_MBUS_ERR( USB_MBUS_TRC_STR, " Failed to send one %s event on 'USB.Host.%s.Device' to mbusd \r\n", del ? "delete" : "add" , name);
    return ERR_COM_UNEXP_COND;
  }

  TR_MBUS_WARN( USB_MBUS_TRC_STR, " Success to send one %s event on 'USB.Host.%s.Device' to mbusd\r\n", del ? "delete" : "add" , name);
  return ERR_NO_ERROR;

}



void usb_mbus_plugin_run(void)
{
  int plugin_listen_sock = -1, max_fd;
  fd_set read_set;
  int rc;

  plugin_listen_sock = mbus_createlistensocket_local(s_usb_plugin_ctx);
  if (plugin_listen_sock == -1) 
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "Failed to create listening socket");
    return;
  }

  while ( 1 ) 
  {
    FD_ZERO(&read_set); 
    FD_SET(plugin_listen_sock, &read_set);
    max_fd = plugin_listen_sock;
    rc = select(max_fd+1, &read_set, NULL, NULL, NULL);

    if (rc < 0) 
    {
      TR_MBUS_ERR(USB_MBUS_TRC_STR, "plug-in select returned %lx", rc);
      continue;                 /* error */
    }
    if (rc == 0) {
      continue;                 /* timed out */
    }
    if (FD_ISSET(plugin_listen_sock, &read_set)) 
    {
      mbus_e_error mb;

      //dd_lock("MBus plugin process request");
      mb = mbus_msg_parse(plugin_listen_sock, s_usb_plugin_ctx);
      if (mb != MBUS_ERR_NOERROR) 
      {
        TR_MBUS_ERR(USB_MBUS_TRC_STR, "failed mbusd plugin request (%s)", mbus_errorstring(mb));
      }
      //dd_unlock();
      rc--;
    }
    if (rc) 
    {
      TR_MBUS_INFO(USB_MBUS_TRC_STR, "%ld unprocessed socket events", rc);
    }
  }
  if (mbus_invoke_unregister(s_usb_plugin_ctx) != MBUS_ERR_NOERROR) 
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "mbus plug-in context unregistration failed");
  }
  if( MBUS_ERR_NOERROR != mbus_ctx_free(s_usb_plugin_ctx))
  {
    TR_MBUS_ERR(USB_MBUS_TRC_STR, "mbus plug-in context free failed");
  }
  s_usb_plugin_ctx = NULL;
  if (plugin_listen_sock != -1) 
  {
    close(plugin_listen_sock);
  }
  return;
}





#ifdef    __cplusplus
}
#endif    

#endif /* VOIP_MBUS_EXCLUDED */

