/*
 *  
 *  Copyright (c) by Shuu Yamaguchi <shuu@wondernetworkresources.com>
 *
 *  $Id: usbmgr.h,v 1.1 2004/08/23 14:53:41 tgu Exp $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	__USBMGR_H
#define	__USBMGR_H

#include	<sys/types.h>
#include	<syslog.h>

#include	"node.h"
#include	"common.h"

#define	GOOD	0
#define	INVALID	-1

#ifdef  DEBUG
#define DPRINTF( args... )  syslog(args)
#else
#define DPRINTF( args... )
#endif

typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned int __u32;

/*2006-11-32 Youming Ruan added*/


/* Endpoint descriptor */
#define USB_MAXENDPOINTS	32
struct usbmgr_endpoint_descriptor {
	u_int8_t  bDescriptorType;
	u_int8_t  bEndpointAddress;
	u_int8_t  bmAttributes;
	u_int8_t  bInterval;
	u_int8_t  bRefresh;
	u_int8_t  bSynchAddress;
        u_int16_t wMaxPacketSize;
};

/* Interface descriptor */
#define USB_MAXINTERFACES	32
struct usbmgr_interface_descriptor {
	u_int8_t  bLength;
	u_int8_t  bDescriptorType;
	u_int8_t  bInterfaceNumber;
	u_int8_t  bAlternateSetting;
	u_int8_t  bNumEndpoints;
	u_int8_t  bInterfaceClass;
	u_int8_t  bInterfaceSubClass;
	u_int8_t  bInterfaceProtocol;
	u_int8_t  iInterface;
	char cDriverDesc[31];

	struct usbmgr_endpoint_descriptor endp[USB_MAXENDPOINTS];
};


/* Configuration descriptor information.. */
#define USB_MAXCONFIG		8
struct usbmgr_config_descriptor {
	u_int8_t  bDescriptorType;
	u_int8_t  bNumInterfaces;
	u_int8_t  bConfigurationValue;  /*what's the meaning of this param?*/
	u_int8_t  iConfiguration;
	u_int8_t  bmAttributes;
	u_int8_t  MaxPower;
        u_int16_t reserved;
	struct usbmgr_interface_descriptor  interface[USB_MAXINTERFACES];

};

#if 0

struct usbmgr_device_descriptor {
	u_int8_t  bLength;
	u_int8_t  bDescriptorType;
	u_int16_t bcdUSB;
	u_int8_t  bPort;
	u_int16_t  iSpeed;
	u_int8_t  bDeviceClass;
	u_int8_t  bDeviceSubClass;
	u_int8_t  bDeviceProtocol;
	u_int8_t  bMaxPacketSize0;
	u_int16_t idVendor;
	u_int16_t idProduct;
	u_int16_t bcdDevice;
	char  cManufacturer[64];
	char  cProduct[64];
	char  cSerialNumber[64];
	u_int8_t  bNumConfigurations;
	struct usbmgr_config_descriptor configuration[USB_MAXCONFIG];
};
#endif

struct usbmgr_device_descriptor {
	double    bcdUSB;
	u_int8_t  bLength;
	u_int8_t  bDescriptorType;
	u_int8_t  bNumConfigurations;
        u_int8_t  bDeviceClass;
	u_int8_t  bDeviceSubClass;
	u_int8_t  bDeviceProtocol;
	u_int8_t  bMaxPacketSize0;
        u_int8_t  bPort;
	u_int16_t idVendor;
	u_int16_t idProduct;
	u_int16_t bcdDevice;
	u_int16_t  iSpeed;
 	char  cManufacturer[64];
	char  cProduct[64];
	char  cSerialNumber[64];
	struct usbmgr_config_descriptor configuration[USB_MAXCONFIG];
};



struct usbmgr_device {
	__u16 idVendor;
        __u16 idProduct;
        __u8  bDeviceClass;
	__u8  bDeviceSubClass;
	__u8  bDeviceProtocol;
	__u8 type;		/* added */
	__u8 status;	/* added */
	__u8 bus;	/* added */
	__u8 devno;	/* added */
	__u16 uid; 				//bugfix GFR: devno is not a unique number. Example a usb 2.0 HD and a usb 1.1 printer can have the same device number
										//solution: use the bus field and the devno as a unique value
										//UID(32bits): ms 8 bits specifies the bus and the ls 8 bits specifies the devno
										//This uid will be raported to mbus
  __u8 reserved;     
	struct usbmgr_device_descriptor device_descriptor;
};


#define USB_DEVICE_DESCRIPTOR( dev )  ((dev)->device_descriptor)
#define USB_CONF_DESCRIPTOR( dev, conf_no )  ((dev)->device_descriptor.configuration[conf_no] )
#define USB_INTF_DESCRIPTOR( dev, conf_no, intf_no )  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no] )
#define USB_ENDP_DESCRIPTOR( dev, conf_no, intf_no, endp_no )  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].endp[endp_no] )


#define	USB_DEV_VERION(dev)	((dev)->device_descriptor.bcdUSB)
#define	USB_DEV_CLASS(dev)	((dev)->device_descriptor.bDeviceClass)
#define	USB_DEV_SUBCLASS(dev)	  ((dev)->device_descriptor.bDeviceSubClass)
#define	USB_DEV_PROTOCOL(dev)	  ((dev)->device_descriptor.bDeviceProtocol)
#define	USB_DEV_MAXPKSIZE(dev)	  ((dev)->device_descriptor.bMaxPacketSize0)
#define	USB_DEV_VENDOR(dev)	  ((dev)->device_descriptor.idVendor)
#define	USB_DEV_PRODID(dev)	  ((dev)->device_descriptor.idProduct)
#define	USB_DEV_DEVNO(dev)	  ((dev)->device_descriptor.bcdDevice)
#define	USB_DEV_MANUFACTURER(dev)	  ((dev)->device_descriptor.cManufacturer)
#define	USB_DEV_PRODUCT(dev)	  ((dev)->device_descriptor.cProduct)
#define	USB_DEV_SERIALNO(dev)	  ((dev)->device_descriptor.cSerialNumber)
#define	USB_DEV_NUMCONF(dev)	  ((dev)->device_descriptor.bNumConfigurations)
#define	USB_DEV_PORT(dev)	  ((dev)->device_descriptor.bPort)
#define	USB_DEV_SPEED(dev)	  ((dev)->device_descriptor.iSpeed)


#define	USB_CONF_NUMINTF(dev, conf_no)	  ((dev)->device_descriptor.configuration[conf_no].bNumInterfaces)
#define	USB_CONF_ATTR(dev, conf_no)	  ((dev)->device_descriptor.configuration[conf_no].bmAttributes)
#define	USB_CONF_MAXPOW(dev, conf_no)	  ((dev)->device_descriptor.configuration[conf_no].MaxPower)
#define	USB_CONF_CONFNO(dev, conf_no)	  ((dev)->device_descriptor.configuration[conf_no].iConfiguration)

#define	USB_INTF_NUMENDP(dev, conf_no, intf_no )	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].bNumEndpoints)
#define	USB_INTF_INTFNO(dev, conf_no,intf_no)	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].iInterface)
#define	USB_INTF_ALT(dev, conf_no, intf_no)	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].bAlternateSetting)
#define	USB_INTF_CLASS(dev, conf_no, intf_no)	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].bInterfaceClass)
#define	USB_INTF_SUBCLASS(dev, conf_no, intf_no)	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].bInterfaceSubClass)
#define	USB_INTF_PROTOCOL(dev, conf_no, intf_no)	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].bInterfaceProtocol)
#define	USB_INTF_DRIVER(dev, conf_no, intf_no)	    ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].cDriverDesc)


#define	USB_ENDP_ADDR(dev, conf_no, intf_no, endp_no )	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].endp[endp_no].bEndpointAddress)
#define	USB_ENDP_ATTR(dev, conf_no, intf_no, endp_no )	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].endp[endp_no].bmAttributes)
#define	USB_ENDP_MAXPKSIZE(dev, conf_no, intf_no, endp_no )	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].endp[endp_no].wMaxPacketSize)
#define	USB_ENDP_INTERVAL(dev, conf_no, intf_no, endp_no )	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].endp[endp_no].bInterval)
#define	USB_ENDP_REFRESH(dev, conf_no, intf_no, endp_no )	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].endp[endp_no].bRefresh)
#define	USB_ENDP_SYNCHADDR(dev, conf_no, intf_no, endp_no )	  ((dev)->device_descriptor.configuration[conf_no].interface[intf_no].endp[endp_no].bSynchAddress)




#ifndef	USB_PROCDIR
#define	USB_PROCDIR		"/proc/bus/usb"
#endif
#define	USB_FILE_PID		"usbmgr.pid"
#define	USB_DIR_PID		"/var/run"
#define	USB_NOMODULE		"none"
#define	USB_DEVICE_MAX		127

#define	MODULE_LOAD			1
#define	MODULE_UNLOAD		(1<<1)
#define	SCRIPT_START		(1<<2)
#define	SCRIPT_STOP			(1<<3)
#define	MODULE_PRELOAD		(1<<4)  /* can add to MODULE_[UN]LOAD */

#define	USB_MOUNT		1
#define	USB_UNMOUNT		2

#define	USBMGR_DO_AUTO		0
#define	USBMGR_DO_FORCE		1

/* For device */
#define	NODE2DEV(node)		((struct usbmgr_device *)(node->data))
#define	DEVICE_STATUS(dev)	((dev)->status)
#define	DEVICE_TYPE(dev)	((dev)->type)
#define	DEVICE_VENDOR(dev)	((dev)->idVendor)
#define	DEVICE_PRODUCT(dev)	((dev)->idProduct)
#define	DEVICE_CLASS(dev)	((dev)->bDeviceClass)
#define	DEVICE_SUBCLASS(dev)	((dev)->bDeviceSubClass)
#define	DEVICE_PROTOCOL(dev)	((dev)->bDeviceProtocol)
#define	DEVICE_BUS(dev)		((dev)->bus)
#define	DEVICE_DEVNO(dev)	((dev)->devno)
#define	DEVICE_UID(dev)	((dev)->uid)

#define	NODE_STATUS(node)	DEVICE_STATUS(NODE2DEV(node))
#define	NODE_TYPE(node)		DEVICE_TYPE(NODE2DEV(node))
#define	NODE_VENDOR(node)	DEVICE_VENDOR(NODE2DEV(node))
#define	NODE_PRODUCT(node)	DEVICE_PRODUCT(NODE2DEV(node))
#define	NODE_CLASS(node)	DEVICE_CLASS(NODE2DEV(node))
#define	NODE_SUBCLASS(node)	DEVICE_SUBCLASS(NODE2DEV(node))
#define	NODE_PROTOCOL(node)	DEVICE_PROTOCOL(NODE2DEV(node))
#define	NODE_BUS(node)		DEVICE_BUS(NODE2DEV(node))
#define	NODE_DEVNO(node)	DEVICE_DEVNO(NODE2DEV(node))
#define	NODE_UID(node)	DEVICE_UID(NODE2DEV(node))
/* class */
#define	CLASS_NONE		0
/* vendor */
#define	VENDOR_NONE		0
/* status */
#define	USBMGR_ST_UNKNOWN	0
#define	USBMGR_ST_ACTIVE	1
/* type */
#define	USBMGR_TYPE_NONE	0
#define	USBMGR_TYPE_SCRIPT	0x1
#define USBMGR_TYPE_VENDOR	0x2
#define USBMGR_TYPE_CLASS	0x4

/* for build_path() */
#define	BUILD_DIR		0x1
#define	BUILD_MODULE	0x2
#define	BUILD_SCRIPT	0x4
#define	BUILD_VENDOR	0x8
#define	BUILD_CLASS		0x10

/* message */
#define	MSG_START	0
#define	MSG_CANT_CD	1
#define	MSG_CANT_PID	2
#define	MSG_FORK_ERR	3
#define	MSG_EXEC_ERR	4
#define	MSG_NOT_LOAD	5
#define	MSG_CANT_GET_LD	6
#define	MSG_DID		7
#define	MSG_TOO_LONG	8
#define	MSG_TRY_LD	9
#define	MSG_STOP	10
#define	MSG_NOCHANGE	11
#define	MSG_NEWDEVICE	12
#define	MSG_NOT_MATCH	13
#define	MSG_MATCH	14
#define	MSG_OPEN_ERR	15
#define	MSG_ALLOC_ERR	16
#define	MSG_READ_ERR	17
#define	MSG_BYE			18
#define	MSG_VENDOR_S	19
#define	MSG_CLASS_S		20
#define	MSG_2STRING		21

extern char *conf_dir;
extern char *vendor_dir;
extern char *class_dir;
extern char *host_module;
extern int debug;
extern int sleep_time;
extern int make_beep;
extern char *mesg[];
extern struct node * netdev_ring;
extern struct node * netdev_ring2;

extern struct node * create_device(struct usbmgr_device *);
extern void observ_devices(char *,ssize_t);
extern void delete_device(int);
extern struct node * find_device(struct usbmgr_device *);
extern void print_device(struct node *);
extern void do_mount(int );
extern int search_class_file(struct node * ,char *,int );
extern int load_from_file(struct node *,char *,int );
extern void observe(void);
extern int check_vendor_file(struct node * ,char *,int );
extern void validate_desc(struct node *);
extern int get_netdev(struct node ** );
#ifdef USBMGR_LIVEBOX
extern unsigned long  usb_device_sndevent_add_del( unsigned long, unsigned long, int );
extern unsigned long usb_mbus_init( void );
extern void usb_host_getname( unsigned long , char * );
#endif

#ifndef	NOT_EXPAND_MACRO
#define	find_string_netdev(ring,name)	find_string_node((ring),(name))
#endif	/* NOT_EXPAND_MACRO */

#endif	/* __USBMGR_H */
