/* Inventel 2006 */
/* Guillaume Faussard */

/* Prod perso for Silicon Labs cp210x */



#ifndef __CP2101_IOCTL_H__
#define __CP2101_IOCTL_H__

#define WCHAR u_int16_t

/*	S means "Set" through a ptr
	T means "Tell" directly with the argument value
	G means "Get" through a ptr
	Q means "Query": response is on the return value
*/
#define CP2101_IOC_MAGIC	0xB9
#define CP2101_IOCS_SERIAL 				_IOW(CP2101_IOC_MAGIC, 1, int)
#define CP2101_IOCS_PRODUCT_STR 			_IOW(CP2101_IOC_MAGIC, 2, int)
#define CP2101_IOCG_PART_NUMBER			_IOR(CP2101_IOC_MAGIC, 3, int)
#define CP2101_IOCT_VID 					_IOW(CP2101_IOC_MAGIC, 4, int)
#define CP2101_IOCT_PID 					_IOW(CP2101_IOC_MAGIC, 5, int)
#define CP2101_IOCT_VERSION				_IOW(CP2101_IOC_MAGIC, 6, int)	// device version
#define CP2101_IOCT_ATTRIBUTES			_IOW(CP2101_IOC_MAGIC, 7, int)	// self power
#define CP2101_IOCT_MAXPOWER				_IOW(CP2101_IOC_MAGIC, 8, int)	// max power
#define CP2101_IOCG_PORTCONFIG			_IOW(CP2101_IOC_MAGIC, 9, int)	// ports configuration during reset, suspend, ...
#define CP2101_IOCS_PORTCONFIG			_IOW(CP2101_IOC_MAGIC, 10, int)	// ports configuration during reset, suspend, ...
#define CP2101_IOCG_DEVICE_CONFIG		_IOR(CP2101_IOC_MAGIC, 11, int)	// dump current device config.
#define CP2101_IOCQ_DEVICE_RESET			_IOW(CP2101_IOC_MAGIC, 12, int)		// reset the device


#define DEVICE_CONFIG_SERIAL_NUMBER_MAXCHAR 126		// 126 caracters max
#define DEVICE_CONFIG_PRODUCT_STRING_MAXCHAR 63

typedef struct {
	unsigned short mode;		// Push pull = 1, Open drain = 0
	unsigned short	reset_latch;
	unsigned short suspend_latch;
	unsigned enhanced_fxn;
} cp2101_portconfig;

typedef struct {
	WCHAR manufacturer[128];
	WCHAR product[DEVICE_CONFIG_PRODUCT_STRING_MAXCHAR+1];
	WCHAR serial_number[DEVICE_CONFIG_SERIAL_NUMBER_MAXCHAR+1];
	unsigned char part_number;
	unsigned short version;
	unsigned char bm_attributes;		// self-powered
	unsigned char b_maxpower;
	unsigned short vid;
	unsigned short pid;
	unsigned char lock;
} cp2101_device_config;

// Define bit locations for Mode/Latch for Reset and Suspend structures
#define PORT_RI_ON				0x0001
#define PORT_DCD_ON				0x0002
#define PORT_DTR_ON				0x0004
#define PORT_DSR_ON				0x0008
#define PORT_TXD_ON				0x0010
#define PORT_RXD_ON				0x0020
#define PORT_RTS_ON				0x0040
#define PORT_CTS_ON				0x0080

#define PORT_GPIO_0_ON			0x0100
#define PORT_GPIO_1_ON			0x0200
#define PORT_GPIO_2_ON			0x0400
#define PORT_GPIO_3_ON			0x0800
#define PORT_RESERVED_0			0x1000
#define PORT_RESERVED_1			0x2000
#define PORT_SUSPEND_ON			0x4000	//  Can't configure latch value
#define PORT_SUSPEND_BAR_ON	0x8000	//  Can't configure latch value

// Define bit locations for EnhancedFxn
#define EF_GPIO_0_TXLED				0x01	//  Under device control
#define EF_GPIO_1_RXLED				0x02	//  Under device control
#define EF_GPIO_2_RS485				0x04	//  Under device control
#define EF_RESERVED_0				0x08	//	Reserved, leave bit 3 cleared
#define EF_WEAKPULLUP				0x10	//  Weak Pull-up on
#define EF_RESERVED_1				0x20	//	Reserved, leave bit 5 cleared
#define EF_SERIAL_DYNAMIC_SUSPEND	0x40	//  For 8 UART/Modem signals
#define EF_GPIO_DYNAMIC_SUSPEND		0x80	//  For 4 GPIO signals



#endif
