/*
 *  
 *  Copyright (c) by Shuu Yamaguchi <shuu@wondernetworkresources.com>
 *
 *  $Id: loader.c,v 1.2 2005/09/28 10:18:20 tgu Exp $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<fcntl.h>
#include	<limits.h>
#include	<string.h>
#include	<sys/wait.h>
#include	<sys/stat.h>
#include	<errno.h>

#include	"usbmgr.h"

#define	MODPROBLE_FILE "/proc/sys/kernel/modprobe"
#define	START_ARGV	2

static char *module_loader = NULL;

static int
get_loader(void)
{
	int fd;
	char ld[PATH_MAX+1];
	ssize_t len;

	if ((fd = open(MODPROBLE_FILE,O_RDONLY)) == -1)
		return -1;
	if ((len = read(fd,ld,PATH_MAX)) <= 0)
		return -1;
	close(fd);
	if (ld[len-1] == '\n')
		ld[len-1] = '\0';
	else
		ld[len] = '\0';
	if((module_loader = strdup(ld)) == NULL)
		return -1;

	return 0;
}

	
static int
load(char *loader,int argc,char **argv,int action)
{
	pid_t pid;
	int status;

	pid = fork();
	switch(pid) {
	case -1:
		syslog(LOG_ERR,mesg[MSG_FORK_ERR]);
		break;
	case 0:	/* child */
		argv[0] = loader;
		if (action & MODULE_LOAD)
			argv[1] = "-as";
		else
			argv[1] = "-asr";

		execv(loader,argv);
		syslog(LOG_ERR,mesg[MSG_EXEC_ERR],loader);
		exit(1);
		break;
	default:	/* parent */
		wait(&status);
		break;
	}
	if (WIFEXITED(status))	/* normal exit */
		return WEXITSTATUS(status);
	return 1;
}

/*
 * load module
 * USB_NOMODULE is not load
 */
static int 
module_load(int argc,char **name,int action)
{
	int count;

	/* name[0]:loader, name[1]:loader option */
	if (!strcmp(name[START_ARGV],USB_NOMODULE)) {
		syslog(LOG_INFO,mesg[MSG_NOT_LOAD],name[START_ARGV]);
		return GOOD;
	}
	if (module_loader == NULL) {
		if (get_loader() == -1)	{
			syslog(LOG_ERR,mesg[MSG_CANT_GET_LD]);
			return INVALID;
		}
	}
	load(module_loader,argc,name,action);
	for(count = START_ARGV;count < argc;count++) {
		syslog(LOG_INFO,mesg[MSG_DID],
			name[count],(action & MODULE_LOAD) ? "loaded" : "unloaded");
	}

	return GOOD;
}

/*
 * execute script in struct config
 */
static int
execute_script(struct node *np,char **cmd,int action)
{
	char path[PATH_MAX+1];		/* for full path of command */
	char buf[256],*bufp;
	char *envp[3];
	int status,i = 0;
	int ret = 0;
	//int j;

	bufp = buf;
	envp[i++] = bufp;
	bufp += sprintf(bufp,"DEVICE=/proc/bus/usb/%03d/%03d",
		NODE_BUS(np),NODE_DEVNO(np)) + 1;
	envp[i++] = bufp;

	if (action == SCRIPT_START) {
		bufp += sprintf(bufp,"ACTION=add") + 1;
	} else {
		bufp += sprintf(bufp,"ACTION=remove") + 1;
	}
	envp[i] = NULL;

	//sleep(5);
	//printf("Execute script (tgu)\n");

	DPRINTF(LOG_DEBUG,"execute_script:used buf length %d\n",bufp - buf);
	for(i = START_ARGV;cmd[i] != NULL;i++) {
		//printf("Cmd : %d *** %s\n", i, cmd[i]);
		switch(fork()) {
		case -1:
			syslog(LOG_ERR,mesg[MSG_FORK_ERR]);
			return INVALID;
		case 0:	/* child */
			if (strlen(cmd[i]) + sizeof(CONF_DIR) + 1 > PATH_MAX) {
				syslog(LOG_ERR,mesg[MSG_TOO_LONG]);
				return INVALID;
			}
			sprintf(path,"%s/%s",conf_dir,cmd[i]);
			if (debug) {
				syslog(LOG_DEBUG,"execle \"%s\":cmd[%d] \"%s\"\n",
					path,i,cmd[i]);
			}

			printf("Path: %s\n", path);
			printf("Cmd%d : %s\n", i, cmd[i]);
			//tgu
			syslog(LOG_DEBUG, "Path: %s\n", path);
			//execle(path, cmd[i], NULL, envp);
			execle(path, cmd[i], 0, envp);
			//execle("/bin/touch", "touch", "/var/tmp/tgu_test", 0, envp);
			syslog(LOG_ERR,mesg[MSG_EXEC_ERR],path);
			exit(1);
		default:	/* parent */
			wait(&status);printf("envp%d addr 0x%08x\n", i, (unsigned int)(envp[i]));
			break;
		}
		if (WIFEXITED(status))	/* normal exit */
			ret |= WEXITSTATUS(status);
	}
	return ret;
}


int
load_from_file(struct node *np,char *fname,int action)
{
	char *name[USB_DEVICE_MAX+3];	/* 3:modprobe,option,NULL */
	int count = START_ARGV;	/* 0:loader 1:loader option */
	int len;
	struct stat st;
	char *mod_string,*sep,*prev;
	int fd;
	int ret = GOOD;
	int preload_count = 0;

	printf("Load_from_file: %s\n", fname);
	if (stat(fname,&st) != 0) {
		syslog(LOG_ERR,mesg[MSG_OPEN_ERR],fname);
		return INVALID;
	}
	len = st.st_size;
	if (len == 0)	/* do nothing */
		return GOOD;
	if ((fd = open(fname,O_RDONLY)) == -1) {
		syslog(LOG_ERR,mesg[MSG_OPEN_ERR],fname);
		ret = INVALID;
		goto err_close;
	}
	if ((mod_string = malloc(len + 1)) == NULL)	{
		syslog(LOG_ERR,mesg[MSG_ALLOC_ERR]);
		ret = INVALID;
		goto err_free;
	}
	if (read(fd,mod_string,len) != len) {
		syslog(LOG_ERR,mesg[MSG_OPEN_ERR],fname);
		ret = INVALID;
		goto err_free;
	}
	printf("Start to load\n");
	for (prev = mod_string;sep = strchr(prev,'\n');) {
	//for (prev = mod_string;sep = gets(prev);) {
		//printf("Tgu start loop \n");
		*sep = '\0';
		/* if MODULE_PRELOAD and MODULE_LOAD is ON,
		 * 		register module name to list
		 * else module name is found in list,
		 *		it is removed from name array
		 */
		if (action == (MODULE_LOAD|MODULE_PRELOAD)) {
			DPRINTF(LOG_DEBUG,"load_from_file:append %s preload list",prev);
			create_module(prev);
			if (debug) {
				printf("Tgu aa\n");
				syslog(LOG_DEBUG,mesg[MSG_TRY_LD],
					(action & MODULE_LOAD) ? "load" : "unload",prev);
			}
		} else {
			//printf("Tgu bb\n");
			if (action & (MODULE_LOAD|MODULE_UNLOAD)) {
				if (find_string_module(prev) != NULL) {
					preload_count++;
					DPRINTF(LOG_DEBUG,"load_from_file:%s is in preload list",prev);
					continue;
				}
				if (debug) {
					syslog(LOG_DEBUG,mesg[MSG_TRY_LD],
						(action & MODULE_LOAD) ? "load" : "unload",prev);
				}
			} else {	/* SCRIPT_START or SCRIPT_STOP */
				if (debug) {
					syslog(LOG_DEBUG,mesg[MSG_TRY_LD],prev,
						(action & SCRIPT_START) ? "start" : "stop");
				}
			}
		}
		//printf("Tgu name count:%d, prev: %s\n", count, prev);
		name[count++] = prev;
		printf("end of loop\n");
		prev= sep+1;
		printf("really the end %d (len %d)\n", (int)(prev-mod_string), strlen(mod_string));
		if ( (int)(prev-mod_string) > strlen(mod_string))
		{
			printf("end of file 2\n");
			break;
		}
		/*if (prev >= (mod_string+strlen(mod_string)))
		{
			printf("end of file\n");
			break;
		}*/
	}
	name[count] = NULL;

	if (action & (MODULE_LOAD|MODULE_UNLOAD)) {
		if (count == START_ARGV) {
			if (preload_count) {	/* make a beep even if no module */
				DPRINTF(LOG_DEBUG,"load device(nothing) -> beep good");
				beep(GOOD);
			}
			DPRINTF(LOG_DEBUG,"There are nothing to load");
			goto err_free;
		}
		printf("Module_load name: %s\n", name);
		if (module_load(count,name,action) == GOOD) {
			beep(GOOD);
			DPRINTF(LOG_DEBUG,"load device -> beep good");
		} else {
			beep(INVALID);
			DPRINTF(LOG_DEBUG,"load device -> beep fail");
		}
	} else {	/* SCRIPT_START or SCRIPT_STOP */
		if (count == 0) {
			DPRINTF(LOG_DEBUG,"There are nothing to execute");
			goto err_free;
		}
		if (execute_script(np,name,action) == GOOD) {
			beep(GOOD);
			DPRINTF(LOG_DEBUG,"execute script -> beep good");
		} else {
			beep(INVALID);
			DPRINTF(LOG_DEBUG,"execute script -> beep fail");
		}
	}

err_free:
	free(mod_string);
err_close:
	close(fd);

	return ret;
}



