#define MAX_ENDPOINTS				32
#define MAX_INTERFACES				32
#define MAX_CONFIGS				32
#define MAX_CHILDREN				32

#define DEVICE_VERSION_SIZE			6
#define DEVICE_CLASS_SIZE			10
#define DEVICE_SUBCLASS_SIZE			3
#define DEVICE_PROTOCOL_SIZE			3
#define DEVICE_VENDOR_ID_SIZE			5
#define DEVICE_PRODUCT_ID_SIZE			5
#define DEVICE_REVISION_NUMBER_SIZE		6

#define CONFIG_ATTRIBUTES_SIZE			3
#define CONFIG_MAXPOWER_SIZE			10

#define INTERFACE_CLASS_SIZE			10

#define ENDPOINT_TYPE_SIZE			5
#define ENDPOINT_MAXPACKETSIZE_SIZE		5
#define ENDPOINT_INTERVAL_SIZE			10


#define TOPOLOGY_BUS_STRING			"Bus="
#define TOPOLOGY_LEVEL_STRING			"Lev="
#define TOPOLOGY_PARENT_STRING			"Prnt="
#define TOPOLOGY_PORT_STRING			"Port="
#define TOPOLOGY_COUNT_STRING			"Cnt="
#define TOPOLOGY_DEVICENUMBER_STRING		"Dev#="
#define TOPOLOGY_SPEED_STRING			"Spd="
#define TOPOLOGY_MAXCHILDREN_STRING		"MxCh="

#define BANDWIDTH_ALOCATED			"Alloc="
#define BANDWIDTH_TOTAL				"/"
#define BANDWIDTH_PERCENT			"us ("
#define BANDWIDTH_INTERRUPT_TOTAL		"#Int="
#define BANDWIDTH_ISOC_TOTAL			"#Iso="

#define DEVICE_VERSION_STRING			"Ver="
#define DEVICE_CLASS_STRING			"Cls="
#define DEVICE_SUBCLASS_STRING			"Sub="
#define DEVICE_PROTOCOL_STRING			"Prot="
#define DEVICE_MAXPACKETSIZE_STRING		"MxPS="
#define DEVICE_NUMCONFIGS_STRING		"#Cfgs="
#define DEVICE_VENDOR_STRING			"Vendor="
#define DEVICE_PRODUCTID_STRING			"ProdID="
#define DEVICE_REVISION_STRING			"Rev="
#define DEVICE_MANUFACTURER_STRING		"Manufacturer="
#define DEVICE_PRODUCT_STRING			"Product="
#define DEVICE_SERIALNUMBER_STRING		"SerialNumber="
#define DEVICE_STRING_MAXSIZE			255

#define CONFIG_NUMINTERFACES_STRING		"#Ifs="
#define CONFIG_CONFIGNUMBER_STRING		"Cfg#="
#define CONFIG_ATTRIBUTES_STRING		"Atr="
#define CONFIG_MAXPOWER_STRING			"MxPwr="

#define INTERFACE_NUMBER_STRING			"If#="
#define INTERFACE_ALTERNATESETTING_STRING	"Alt="
#define INTERFACE_NUMENDPOINTS_STRING		"#EPs="
#define INTERFACE_CLASS_STRING			"Cls="
#define INTERFACE_SUBCLASS_STRING		"Sub="
#define INTERFACE_PROTOCOL_STRING		"Prot="
#define INTERFACE_DRIVERNAME_STRING		"Driver="
#define INTERFACE_DRIVERNAME_NODRIVER_STRING	"(none)"
#define INTERFACE_DRIVERNAME_STRING_MAXLENGTH	50

typedef struct DeviceInterface {
	char		*name;
	int		interfaceNumber;
	int		alternateNumber;
	int		numEndpoints;
	int		subClass;
	int		protocol;
	char		*class;
	int		driverAttached;		/* TRUE if driver is attached to this interface currently */
} DeviceInterface;

typedef struct DeviceConfig {
	int		configNumber;
	int		numInterfaces;
	int		attributes;
	char		*maxPower;
	DeviceInterface	*interface[MAX_INTERFACES];
} DeviceConfig;

typedef struct Device {
	char		*name;
	int		busNumber;
	int		level;
	int		parentNumber;
	int		portNumber;
	//int		connectorNumber;
	int		count;
	int		deviceNumber;
	int		speed;
	int		maxChildren;
	char		*version;
	char		*class;
	char		*subClass;
	char		*protocol;
	int		vendorId;
	int		productId;
	char		*revisionNumber;
	char		*manufacturer;
	char		*product;
	char		*serialNumber;
	struct Device	*parent;
	struct Device	*child[MAX_CHILDREN];
	DeviceConfig	*config[MAX_CONFIGS];
} Device;
