// Inventel

// based on Usbview


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "usb_parse.h"

#define FALSE 1
#define TRUE 0


#if 1
#define debug_fprintf(...)
#else
#define debug_fprintf fprintf
#endif

typedef enum {
	TYPE_HTML,
	TYPE_XML,
	TYPE_RAW,
	TYPE_BIN,
	TYPE_HTML_JAVA_SCRIPT
} display_type_page_t;

Device          	*rootDevice = NULL;
Device                  *currentDevice = NULL;
int nb_device=0;

Device* init_device();

static signed int GetInt (char *string, char *pattern, int base)
{
	char    *pointer;
	
//	printf("get int start\n");
	pointer = strstr (string, pattern);
	if (pointer == NULL)
		return(0);

	pointer += strlen(pattern);
	return((int)(strtol (pointer, NULL, base)));
}

/*  uncomment this if we ever need to read a float
static double GetFloat (char *string, char *pattern)
{
	char	*pointer;

	pointer = strstr (string, pattern);
	if (pointer == NULL)
		return (0.0);

	pointer += strlen(pattern);
	return (strtod (pointer, NULL));
}
*/


static void GetString (char *dest, char *source, char *pattern, int maxSize)
{
	char    *pointer;
	int i;
	
	//maxSize+1: on veut remettre le dernier caractre aussi  0
	for(i=0; i< (maxSize+1); i++)
		dest[i]=0x00;
	
//	fprintf(stderr, "maxSize: %d\n", maxSize);
	pointer = strstr (source, pattern);
	if (pointer == NULL)
		return;

	pointer += strlen(pattern);
	strncpy (dest, pointer, maxSize);
	return;
}

int free_string(char* text)
{
	debug_fprintf(stderr, "\tfree_string: %s\n", text);
	if (text != NULL) free(text);
	text=NULL;
	return 0;
						
}

static void DestroyInterface (DeviceInterface *interface)
{

	if (interface == NULL)
		return;
	interface->interfaceNumber=0;
	interface->alternateNumber=0;
	interface->numEndpoints=0;
	interface->subClass=0;
	interface->protocol=0;
	interface->driverAttached=FALSE;
		
	free_string (interface->name);
	free_string (interface->class);
	free(interface);
	interface=NULL;
	
	return;
}


static void DestroyConfig (DeviceConfig *config)
{
	int     i;

	if (config == NULL)
		return;

	for (i = 0; i < MAX_INTERFACES; ++i)
		DestroyInterface (config->interface[i]);

	free_string (config->maxPower);
	config->configNumber=0;
	config->numInterfaces=0;
	config->attributes=0;
	free(config);
	config=NULL;
	
// 	return;
}

static void DestroyDevice (Device *device)
{
	int     i;
	
	if (device == NULL)
		return;
	
	if (device->name == NULL)
		debug_fprintf(stderr, "destroy null name device\n");
	else
		debug_fprintf(stderr, "Destroy device %s\n", device->name);	
	
	for (i = 0; i < MAX_CHILDREN; ++i)
		DestroyDevice (device->child[i]);
	for (i = 0; i < MAX_CONFIGS; ++i)
		DestroyConfig (device->config[i]);
	
//	fprintf(stderr, " End Destroy device %s\n", device->name);
	free_string (device->name);
	free_string (device->version);
	free_string (device->class);
	free_string (device->subClass);
	free_string (device->protocol);
	free_string (device->revisionNumber);
	free_string (device->manufacturer);
	free_string (device->product);
	free_string (device->serialNumber);
	
	debug_fprintf(stderr, " deleting device\n");
	free (device);
	device=NULL;
//	fprintf(stderr, "final\n");
	return;
}
////////////////////////
static Device *FindDeviceNode (Device *device, int deviceNumber, int busNumber)
{
	int     i;
	Device  *result;

	if (device == NULL)
		return(NULL);

	if ((device->deviceNumber == deviceNumber) &&
	    (device->busNumber == busNumber))
		return(device);

	for (i = 0; i < MAX_CHILDREN; ++i) {
		result = FindDeviceNode (device->child[i], deviceNumber, busNumber);
		if (result != NULL)
			return(result);
	}

	return(NULL);
}


Device *usb_find_device (int deviceNumber, int busNumber)
{
	int     i;
	Device  *result;

	/* search through the tree to try to find a device */
	for (i = 0; i < MAX_CHILDREN; ++i) {
		result = FindDeviceNode (rootDevice->child[i], deviceNumber, busNumber);
		if (result != NULL)
			return(result);
	}
	return(NULL);
}

Device *AddDevice (char *line)
{
	int i;
	Device* device;
	
	device= init_device();
	
//	fprintf(stderr, "Filling info\n");
	/* parse the line */
	device->busNumber       = GetInt (line, TOPOLOGY_BUS_STRING, 10);
	device->level           = GetInt (line, TOPOLOGY_LEVEL_STRING, 10);
	device->parentNumber    = GetInt (line, TOPOLOGY_PARENT_STRING, 10);
	device->portNumber      = GetInt (line, TOPOLOGY_PORT_STRING, 10);
	device->count           = GetInt (line, TOPOLOGY_COUNT_STRING, 10);
	device->deviceNumber    = GetInt (line, TOPOLOGY_DEVICENUMBER_STRING, 10);
	device->speed           = GetInt (line, TOPOLOGY_SPEED_STRING, 10);
	device->maxChildren     = GetInt (line, TOPOLOGY_MAXCHILDREN_STRING, 10);

	if (device->deviceNumber == -1)
		device->deviceNumber = 0;
//	fprintf(stderr, "Set up parent, level %d\n", device->level);
	
	/* Set up the parent / child relationship */
	if (device->level == 0) {
		/* this is the root, don't go looking for a parent */
		device->parent = rootDevice;
		++rootDevice->maxChildren;
		rootDevice->child[rootDevice->maxChildren-1] = device;
	} else {
		/* need to find this device's parent */
		device->parent = usb_find_device (device->parentNumber, device->busNumber);
		if (device->parent == NULL) {
			printf ("can't find parent...not good.\n");
		}
		device->parent->child[device->portNumber] = device;
	}
        
        device->name = NULL;
        
	//fprintf(stderr, "Exiting device\n");
	return(device);
}

void display_device(FILE* fo, Device* dev)
{
	if (dev == NULL)
	{
		//fprintf(fo, "device is null\n");
		return;
	}
	fprintf(fo, "Name : %s\n", dev->name);
	fprintf(fo, "Bus: %d, level / %d\n",	dev->busNumber, dev->level);

	}
static void GetDeviceInformation (Device *device, char *data)
{
	if (device == NULL)
		return;

	//fprintf(stderr, "getdevice information\n");
	free_string (device->version);
	//fprintf(stderr, ".");
	free_string (device->class);
	//fprintf(stderr, ".");
	free_string (device->subClass);
	//fprintf(stderr, ".");
	free_string (device->protocol);

	//fprintf(stderr, "alloc for getdevice information\n");
	device->version         = (char *)malloc ((DEVICE_VERSION_SIZE) * sizeof(char));
	device->class           = (char *)malloc ((DEVICE_CLASS_SIZE) * sizeof(char));
	device->subClass        = (char *)malloc ((DEVICE_SUBCLASS_SIZE) * sizeof(char));
	device->protocol        = (char *)malloc ((DEVICE_PROTOCOL_SIZE) * sizeof(char));

	if (!(device->version && device->class && device->subClass && device->protocol))
		fprintf(stderr, "*********error in malloc device ******\n");
		
	//fprintf(stderr, "set up the data\n");
	GetString (device->version, data, DEVICE_VERSION_STRING, DEVICE_VERSION_SIZE-1);
//	fprintf(stderr, "device->version %s\n", device->version);
	
	GetString (device->class, data, DEVICE_CLASS_STRING, DEVICE_CLASS_SIZE-1);
//	fprintf(stderr, "device->class %s\n", device->class);	
	
	GetString (device->subClass, data, DEVICE_SUBCLASS_STRING, DEVICE_SUBCLASS_SIZE-1);
//	fprintf(stderr, "device->subClass %s\n", device->subClass);
	
	GetString (device->protocol, data, DEVICE_PROTOCOL_STRING, DEVICE_PROTOCOL_SIZE-1);
//	fprintf(stderr, "device->protocol %s\n", device->protocol);

	//fprintf(stderr, "leaving\n");
	return;
}



static void GetMoreDeviceInformation (Device *device, char *data)
{
	if (device == NULL)
		return;

	free (device->revisionNumber);

	device->vendorId        = GetInt (data, DEVICE_VENDOR_STRING, 16);
	device->productId       = GetInt (data, DEVICE_PRODUCTID_STRING, 16);

	device->revisionNumber  = (char *)malloc ((DEVICE_REVISION_NUMBER_SIZE) * sizeof(char));
	GetString (device->revisionNumber, data, DEVICE_REVISION_STRING, DEVICE_REVISION_NUMBER_SIZE);

	return;
}


static void GetDeviceString (Device *device, char *data)
{
	if (device == NULL)
		return;

	if (strstr (data, DEVICE_MANUFACTURER_STRING) != NULL) {
		//free_string (device->manufacturer);
		device->manufacturer = (char *)malloc (DEVICE_STRING_MAXSIZE);
		GetString (device->manufacturer, data, DEVICE_MANUFACTURER_STRING, DEVICE_STRING_MAXSIZE-1);
		//fprintf(stderr, "device->manufacturer: %s\n", device->manufacturer);
		return;
	}

	if (strstr (data, DEVICE_PRODUCT_STRING) != NULL) {
		//free_string (device->product);
		device->product = (char *)malloc (DEVICE_STRING_MAXSIZE);
		GetString (device->product, data, DEVICE_PRODUCT_STRING, DEVICE_STRING_MAXSIZE-1);
		//fprintf(stderr, "device->product %s\n", device->product);
		return;
	}

	if (strstr (data, DEVICE_SERIALNUMBER_STRING) != NULL) {
		//free_string (device->serialNumber);
		device->serialNumber = (char *)malloc (DEVICE_STRING_MAXSIZE);
		GetString (device->serialNumber, data, DEVICE_SERIALNUMBER_STRING, DEVICE_STRING_MAXSIZE-1);
		//fprintf(stderr, "device->serialNumber %s\n", device->serialNumber);
		return;
	}
	return;
}

static void AddConfig (Device *device, char *data)
{
	DeviceConfig    *config;
	int             i;

	if (device == NULL)
		return;

	debug_fprintf(stderr, "Add config\n");
	
	/* Find the next available config in this device */
	for (i = 0; i < MAX_CONFIGS; ++i) {
		if (device->config[i] == NULL) {
			break;
		}
	}
	if (i >= MAX_CONFIGS) {
		/* ran out of room to hold this config */
		printf("Too many configs for this device.\n");
		return;
	}

	config = (DeviceConfig *)malloc (sizeof(DeviceConfig));
	config->maxPower        = (char *)malloc((CONFIG_MAXPOWER_SIZE) * sizeof(char));

	config->numInterfaces   = GetInt (data, CONFIG_NUMINTERFACES_STRING, 10);
	config->configNumber    = GetInt (data, CONFIG_CONFIGNUMBER_STRING, 10);
	config->attributes      = GetInt (data, CONFIG_ATTRIBUTES_STRING, 16);

	GetString (config->maxPower, data, CONFIG_MAXPOWER_STRING, CONFIG_MAXPOWER_SIZE);

	/* have the device now point to this config */
	device->config[i] = config;

	return;
}

static void AddInterface (Device *device, char *data)
{
	DeviceConfig    *config;
	DeviceInterface *interface;
	int             i;
	int             configNum;

	if (device == NULL)
		return;

	//fprintf(stderr, "Adding interface\n");
	/* find the LAST config in the device */
	configNum = -1;
	for (i = 0; i < MAX_CONFIGS; ++i)
		if (device->config[i])
			configNum = i;
	//fprintf(stderr, "configNum %d\n", configNum);
	if (configNum == -1) {
		/* no config to put this interface at, not good */
		 printf("No config to put an interface at for this device.\n");
		return;
	}
	//fprintf(stderr, "config found\n");
	config = device->config[configNum];

	//fprintf(stderr, "66\n");
	/* now find a place in this config to place the interface */
	for (i = 0; i < MAX_INTERFACES; ++i)
		if (config->interface[i] == NULL)
			break;
	if (i >= MAX_INTERFACES) {
		/* ran out of room to hold this interface */
		printf ("Too many interfaces for this device.\n");
		return;
	}

	//fprintf(stderr, "Allocating interface\n");
	interface = (DeviceInterface *)malloc (sizeof(DeviceInterface));
	if (interface == NULL) fprintf(stderr, "No mem for interface\n");
	
	interface->class        = (char *)malloc ((INTERFACE_CLASS_SIZE) * sizeof(char));
	if (interface->class == NULL) fprintf(stderr, "Warning interface class is null\n");
	interface->name         = (char *)malloc ((INTERFACE_DRIVERNAME_STRING_MAXLENGTH) * sizeof(char));
	if (interface->name == NULL) fprintf(stderr, "Warning interface name is null\n");
	
	interface->interfaceNumber      = GetInt (data, INTERFACE_NUMBER_STRING, 10);
	interface->alternateNumber      = GetInt (data, INTERFACE_ALTERNATESETTING_STRING, 10);
	interface->numEndpoints         = GetInt (data, INTERFACE_NUMENDPOINTS_STRING, 10);
	interface->subClass             = GetInt (data, INTERFACE_SUBCLASS_STRING, 10);
	interface->protocol             = GetInt (data, INTERFACE_PROTOCOL_STRING, 10);

	GetString (interface->class, data, INTERFACE_CLASS_STRING, INTERFACE_CLASS_SIZE);
	GetString (interface->name, data, INTERFACE_DRIVERNAME_STRING, INTERFACE_DRIVERNAME_STRING_MAXLENGTH);

	/* if this interface does not have a driver attached to it, save that info for later */
	if (strncmp(interface->name, INTERFACE_DRIVERNAME_NODRIVER_STRING, INTERFACE_DRIVERNAME_STRING_MAXLENGTH) == 0) {
		interface->driverAttached = FALSE;
	} else {
		interface->driverAttached = TRUE;
	}

	/* now point the config to this interface */
	config->interface[i] = interface;


	return;
}



/* Build thename for all the devices */
static void NameDevice (Device *device, int* maxlevel)
{
	int     configNum;
	int     interfaceNum;
	int     i;

	if (device == NULL)
		return;

	if (device->level > *maxlevel)
		*maxlevel=device->level;
	
	debug_fprintf(stderr, "name it now\n");
	/* build the name for this device */
	if (device != rootDevice) {
		if (device->name)
			free_string (device->name);
		device->name = (char *)malloc (DEVICE_STRING_MAXSIZE*sizeof (char));
		strcpy(device->name, "");
                if (device->name == NULL)
                {
                   fprintf(stderr, "Device name is null !");              
                }
                strcpy(device->name, "");
                
		/* see if this device has a product name */
		if (device->product != NULL) {
			strcpy (device->name, device->product);
			goto create_children_names;
		}

		/* see if this device is a root hub */
		if (device->level == 0) {
			strcpy (device->name, "root hub");
			goto create_children_names;
		}

		fprintf(stderr, "look in interfaces\n");
		/* look through all of the interfaces of this device, adding them all up to form a name */
		for (configNum = 0; configNum < MAX_CONFIGS; ++configNum) {
			fprintf(stderr, "Confignum %d\n", configNum);
			if (device->config[configNum]) {
				DeviceConfig    *config = device->config[configNum];
				for (interfaceNum = 0; interfaceNum < MAX_INTERFACES; ++interfaceNum) {
					debug_fprintf(stderr, "Interfacenum %d\n", interfaceNum);
					if (config->interface[interfaceNum]) {
						DeviceInterface *interface = config->interface[interfaceNum];
						debug_fprintf(stderr, "Checking interface\n");
						if (interface->name != NULL) {
							debug_fprintf(stderr, "Interface name: \n");
							debug_fprintf(stderr, "%s\n", interface->name);
							if (strstr (interface->name, "none") == NULL) {
								if (strcmp (interface->name, "hid") == 0) {
									if (interface->subClass == 1) {
										debug_fprintf(stderr, "Interface protocol %d\n", interface->protocol);
										switch (interface->protocol) {
										
											case 1 :
												strcat (device->name, "keyboard");
												continue;
											case 2 :
												strcat (device->name, "mouse");
												continue;
										}
									}
								}
								debug_fprintf(stderr, "looking for interface->name in device->name %s (%s)\n", device->name, interface->name);
								if (strstr (device->name, interface->name) == NULL) {
									if (strlen (device->name) > 0) {
										strcat (device->name, " / ");
									}
									strcat (device->name, interface->name);
								}
							}
							debug_fprintf(stderr, "close interface\n");
						}
						else
							debug_fprintf(stderr, "Interface name is null\n");
					}
				}
			}
		}
		debug_fprintf(stderr, "Check if device has a name\n");
		if (strlen (device->name) == 0) {
			strcpy (device->name, "????");
		}

	}
	
	create_children_names:

	debug_fprintf(stderr, "Device name %s\n", device->name);
	/* create all of the children's names */
	for (i = 0; i < MAX_CHILDREN; ++i) {
		NameDevice (device->child[i], maxlevel);
	}

	return;
}

Device* init_device()
{
	Device* mydev;
	int i;
	
	mydev = (Device *)malloc (sizeof(Device));
	if (mydev ==NULL)
	{
	 	printf("Can't init new device\n");
		return NULL;
	}
	
	for (i = 0; i < MAX_CHILDREN; ++i)
		mydev->child[i]=NULL;
	for (i = 0; i < MAX_CONFIGS; ++i)
		mydev->config[i]=NULL;
		
	mydev->name=NULL;
	mydev->version=NULL;
	mydev->class=NULL;
	mydev->subClass=NULL;
	mydev->protocol=NULL;
	mydev->revisionNumber=NULL;
	mydev->manufacturer=NULL;
	mydev->product=NULL;
	mydev->serialNumber=NULL;
	
	mydev->vendorId	       = 0;
	mydev->productId       = 0;
	
	mydev->busNumber       = 0;
	mydev->level           = 0;
	mydev->parentNumber    = 0;
	mydev->portNumber      = 0;
	mydev->count           = 0;
	mydev->deviceNumber    = 0;
	mydev->speed           = 0;
	mydev->maxChildren     = 0;
	
	return mydev;
}

void usb_initialize_list (void)
{
	debug_fprintf(stderr, "usb_initialize_list\n");
	if (rootDevice != NULL) {
		fprintf(stderr, "root device not null\n");
		DestroyDevice (rootDevice);
		rootDevice = NULL;
	}

	debug_fprintf(stderr, "Allocating root device\n");
	
	rootDevice=init_device();
	if (rootDevice == NULL)
		fprintf(stderr, "Warinig root device is null\n");
	currentDevice = NULL;
	
	return;
}



int parse_usb_file()
{

	FILE * f;
	char buffer[513];
	
	f = fopen( "/proc/bus/usb/devices", "rt");
	if (f == NULL)
		return 1;
	usb_initialize_list();
	debug_fprintf(stderr, "Now check the devices file\n");
	while ( fgets( buffer, 512, f))
	{
		/* chop off the trailing \n */
		 buffer[strlen(buffer)-1] = 0x00;
	
		switch (buffer[0]) {
			case 'T': /* topology */
				debug_fprintf(stderr, "T\n");
				currentDevice = AddDevice (buffer);
				break;
			case 'D': /* device information */
				debug_fprintf(stderr, "D\n");
				GetDeviceInformation (currentDevice, buffer);
				break;
	
			case 'P': /* more device information */
				debug_fprintf(stderr, "P\n");
				GetMoreDeviceInformation (currentDevice, buffer);
				break;
	
			case 'S': /* device string information */
				debug_fprintf(stderr, "S\n");
				GetDeviceString (currentDevice, buffer);
				break;
	
			case 'C': /* config descriptor info */
				debug_fprintf(stderr, "C\n");
				AddConfig (currentDevice, buffer);
				break;
	
			case 'I': /* interface descriptor info */
				debug_fprintf(stderr, "I\n");
				AddInterface (currentDevice, buffer);
				break;
			default:
				debug_fprintf(stderr, "default\n");
				break;
		
		}
	}
	fclose(f);
	return 0;
}

//renvoie les classes de toutes les interfaces d'un device
int MatchInterfaceClass(Device *device, int filter)
{
	int i,j;
	char classStr[INTERFACE_CLASS_SIZE];
	int classInt=0;
	int tmp;
	
	//fprintf(stderr, "Class of device: %s\n", device->class);
	for (i = 0; i < MAX_CONFIGS; ++i) {
		
		if (device->config[i] == NULL) 
			break;
		//fprintf(stderr, "\tConfig %d\n", i);
		for(j=0;j<MAX_INTERFACES;j++) {
			if (device->config[i]->interface[j]==NULL) break;
			debug_fprintf(stderr, "\t\tInterface %d, class %s\n", i, device->config[i]->interface[j]->class);
			strcpy(classStr, device->config[i]->interface[j]->class);
			sscanf(classStr, "%x", &tmp);
			if (tmp > 0xf0 ) 
			{
				if ((filter & tmp) != 0) return 1; 
				continue;
			}
			if ((filter & (1 << tmp)) !=0 ) return 1;
		}
		
	}
	return 0;	
}


// on affiche rcursivement l'arbre USB
static void display_device_tree (FILE* fo, Device *device, int maxlevel, display_type_page_t display, int filter, int display_name)
{
	int i;
	char buffer[255];
        char *crlf;
	
	if (device == NULL)
		return;
        
	if (display == TYPE_HTML_JAVA_SCRIPT)
	{
	  crlf = ""; 
	}
	else
	{
	  crlf = "\n"; 
	}

	debug_fprintf(stderr, "DEvice name : %s\n", device->name);
	if ((device->level > 0) && (MatchInterfaceClass(device,filter) !=0 )) {
		if (device->manufacturer == NULL)
			sprintf(buffer, "%s", device->name);
		else
			sprintf(buffer, "%s (%s)", device->name, device->manufacturer);
		if (display == TYPE_RAW) {
			
			fprintf(fo, "USB_DEV%d=%s", nb_device, buffer);
			if (device->serialNumber != NULL)
				fprintf(fo, "_%s\n", device->serialNumber);
			else
				fprintf(fo, "\n");
		} 
		else if (display == TYPE_BIN) {
			if (display_name == 1) {
			  fprintf(fo, "%s ", buffer);
			}
		}
		else //default is TYPE_HTML
		{
			fprintf(fo, "<b>%s</b><br>%s", buffer, crlf);
			if (display_name == 0) {
				if ((device->vendorId != 0) &&  (device->productId != 0))
				{
					fprintf(fo, "Vid: %d<br>%s", device->vendorId, crlf);
					fprintf(fo, "Pid: %d<br>%s",  device->productId, crlf);
				}
				fprintf(fo, "<%%ejGetStr(USB_VERSION)%%>: %s<br>%s", device->version, crlf);
				
				if (strcmp(device->revisionNumber, " 0.00") != 0)
					fprintf(fo, "<%%ejGetStr(USB_DEV_REVISION)%%>: %s<br>%s", device->revisionNumber, crlf);
				if (device->serialNumber != NULL)
					fprintf(fo, "<%%ejGetStr(USB_SERIAL_NB)%%>: %s<br>%s", device->serialNumber, crlf);
				fprintf(fo, "<br><ul>%s", crlf);
			}
		}
		nb_device++;
        }
	/* display all children_names */
	for (i = 0; i < MAX_CHILDREN; ++i) {
		display_device_tree (fo, device->child[i], maxlevel, display, filter, display_name);
	}
        
	if ((device->level > 0) && (display != TYPE_RAW) && (display != TYPE_BIN) && !display_name)
           fprintf(fo, "</ul>%s", crlf);

	return;
}
	

void check_storage()
{
	FILE* fo;
	int res;
	int maxlevel=0;
	int nb=0;
	
	while(1)
	{
		fprintf(stderr, "Checking usb storage devices: %d\n", nb);
		
		fo=fopen("usb_storage", "wt");
		if (fo ==NULL)
		{ 
			fprintf(stderr, "fo null\n");
			return;
		}
		fprintf(stderr, "//////////// parse usb file now\n");
		res = parse_usb_file();
		fprintf(stderr, "naming device\n");
		//NameDevice(rootDevice, &maxlevel);
		fprintf(stderr, "//////////// backup to see changes\n");
		//display_device_tree (fo, rootDevice, maxlevel, TYPE_HTML, 1 << 8 , 0);
		fclose(fo);
		usleep(50000);
		fprintf(stderr,"***************************************************************************\n");
		nb++;
	}			
	
}

int main( int argc, char* argv[])
{
	int res;
	int maxlevel=0;
	int i;
	int class_filter=~0x0;  //filtre sur les classes  afficher (par dfaut toutes les classes de device usb)
	int display_name=0;  //on affiche juste les noms des devices
	display_type_page_t display=TYPE_HTML; //HTML, XML ou RAW pour l'instant
	
	
	for (i = 1; i < argc; i++)
	{
		/* -display output type */
		if (!strncasecmp(argv[i], "-display", 8) && (++i < argc))
		{
			sscanf(argv[i], "%d", &display);
			continue;
		}
		/* -filter */
		if (!strncasecmp(argv[i], "-filter", 7) && (++i < argc))
		{
			sscanf(argv[i], "0x%x", &class_filter);
			continue;
		}
		//-name : on affiche juste les noms
		if (!strncasecmp(argv[i], "-name", 5))
		{
			display_name= 1;
			continue;
		}
		//-storage : on relance usb-storage pour chaque nouveau device de stockage
		if (!strncasecmp(argv[i], "-storage", 8))
		{
			check_storage();
			return 1;
		}
		
	}
	
	
	fprintf(stderr, "Display type is %d\n", display);
	fprintf(stderr, "Class filter 0x%x\n", class_filter);
	fprintf(stderr, "Display names only %s\n", display_name ? "yes" : "no");
	res = parse_usb_file();

	NameDevice(rootDevice, &maxlevel);
	display_device_tree (stdout, rootDevice, maxlevel, display, class_filter, display_name);
	return 0;
}
