/**
 * @file   get_msg.c
 * @author Arnaud Mouiche <arnaud.mouiche@inventel.fr>
 * @date   
 * 
 * @brief  utilitaire pour le support du multi-langues
 * Copyrigth  2004  INVENTEL -- Paris
 * 
 * 
 */

#include <stdio.h>
#include "lang_msg.h"
#include "messages_macros.h"


int main(int argc,char **argv)
{
  int language ;
  int str_id ;
  int error ;
  char buf[255];
  
  printf("starting get_msg\n");
  if(argc < 3)
  {
    printf("Error : specify language and string id\n") ;
    return -1 ;
  }
  if (sscanf(argv[1], "%d", &language) != 1) {
    printf("Error : specify language and string id\n") ;
    return -1;
  }

  if (error = init_lang_msg(language, MESSAGES_FILE))
  {
    printf("[Error in language %d]",language);
    fprintf(stderr,"Error %d happened when opening language\n", error) ;
    fprintf(stderr,"Tried to open language : %d in file %s \n",language,MESSAGES_FILE);
    return -1 ;
  }

  if (sscanf(argv[2], "%d", &str_id) == 1 ) {
    // on a dtect un numro
/*     printf ("Numro\n"); */
    print_msg(str_id) ; 
  } else { 
/*     printf("Chaine\n"); */
    str_sprint_msg(buf,argv[2]);
    printf("%s",buf);
  } 
  close_lang_msg() ;
  return 0 ;
}
