/*
 * Written by J.T. Conklin <jtc@netbsd.org>.
 * Change for long double by Ulrich Drepper <drepper@cygnus.com>.
 * Intel i387 specific version.
 * Public domain.
 */

#if 0 /* vstr */
#if defined(LIBM_SCCS) && !defined(lint)
static char rcsid[] = "$NetBSD: $";
#endif

/*
 * isinfl(x) returns 1 if x is inf, -1 if x is -inf, else 0;
 * no branching!
 */

#include "math.h"
#include "math_private.h"

#endif /* vstr */
static
#ifdef __STDC__
	int __isinfl(long double x)
#else
	int __isinfl(x)
	long double x;
#endif
{
	int32_t se,hx,lx;
	GET_LDOUBLE_WORDS(se,hx,lx,x);
	/* This additional ^ 0x80000000 is necessary because in Intel's
	   internal representation of the implicit one is explicit.  */
	lx |= (hx ^ 0x80000000) | ((se & 0x7fff) ^ 0x7fff);
	lx |= -lx;
	se &= 0x8000;
	return ~(lx >> 31) & (1 - (se >> 14));
}
#if 0 /* vstr */
INTDEF(__isinfl)
weak_alias (__isinfl, isinfl)
#endif /* vstr */
