/*
<:copyright-gpl 
 Copyright 2013 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <linux/version.h>
#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter_bridge/ebtables.h>
#include <linux/netdevice.h>
#include "ebt_imq.h"

static unsigned int
ebt_imq_tg(struct sk_buff *skb, const struct xt_target_param *par)
{
	const struct ebt_imq_info *info = par->targinfo;

	if (!skb_make_writable(skb, 0))
		return EBT_DROP;

	skb->imq_flags = (info->todev & IMQ_F_IFMASK) | IMQ_F_ENQUEUE;

	return EBT_CONTINUE;
}

static bool ebt_imq_tg_check(const struct xt_tgchk_param *par)
{
	const struct ebt_imq_info *info = par->targinfo;

	if (info->todev > IMQ_MAX_DEVS - 1) {
		printk(KERN_WARNING
		       "IMQ: invalid device specified, highest is %u\n",
		       IMQ_MAX_DEVS - 1);
		return 0;
	}

	return 1;
}

static struct xt_target ebt_imq_target __read_mostly = {
  .name		= EBT_IMQ_TARGET,
  .revision	= 0,
  .family       = NFPROTO_BRIDGE,
  .target	= ebt_imq_tg,
  .checkentry	= ebt_imq_tg_check,
  .targetsize	= XT_ALIGN(sizeof(struct ebt_imq_info)),
  .me		= THIS_MODULE,
};

static int __init ebt_imq_init(void)
{
  return xt_register_target(&ebt_imq_target);
}

static void __init ebt_imq_fini(void)
{
  xt_unregister_target(&ebt_imq_target);
}

module_init(ebt_imq_init);
module_exit(ebt_imq_fini);
MODULE_LICENSE("GPL");
