/*
<:copyright-gpl 
 Copyright 2010 Arcadyan Technology 
 All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/
#ifndef __BR_FP_HOOKS_H__
#define __BR_FP_HOOKS_H__

#include <linux/device.h>
#include "br_private.h"

#undef BR_FP_DEBUG_SET
#ifdef BR_FP_DEBUG_SET
#define BR_FP_DEBUG_LEVEL 4
#define BR_FP_START_DEBUG(n) do { if (n<BR_FP_DEBUG_LEVEL)
#define BR_FP_END_DEBUG      } while (0)
#define BR_FP_DEBUG(n, args...)			\
	BR_FP_START_DEBUG(n)			\
		printk(KERN_INFO args);		\
	BR_FP_END_DEBUG
#else
#define BR_FP_DEBUG(n, args...)
#endif

/* FP_BR_HOOK parameters */
#define BR_FP_FDB_ADD              1
#define BR_FP_FDB_REMOVE           2
#define BR_FP_FDB_MODIFY           3
#define BR_FP_FDB_CHECK_AGE        4
#ifdef ARCADYAN
#define BR_FP_IPTV_ADD             5
#define BR_FP_IPTV_REMOVE          6
#define BR_FP_IPTV_MODIFY          7
#endif /* ARCADYAN */

struct net_bridge;
struct br_fp_data; 
struct net_device;
/* Hooks introduced to legacy bridge code */ 

static inline void BR_FP_HOOK_FDB (struct net_bridge_port * port, unsigned char * mac_addr, int action)
{ 
   struct net_bridge *br = port->br;
#if defined(ARCADYAN)
   struct br_fp_data *fp=br->fp_hooks;
#else
   struct br_fp_data *fp=&(br->fp_hooks);
#endif
   int res;

   BR_FP_DEBUG(2, "%s %d %p %d\n", __FUNCTION__, __LINE__,fp, action); 
   switch (action) {
      case BR_FP_FDB_ADD: 
         if (fp && fp->fdb_add)  
            res = fp->fdb_add(port->dev, mac_addr);  
         break;
      case BR_FP_FDB_REMOVE: 
         if (fp && fp->fdb_remove) 
            res = fp->fdb_remove(port->dev, mac_addr); 
         break;
      case BR_FP_FDB_MODIFY: 
         if (fp && fp->fdb_modify) 
            res = fp->fdb_modify(port->dev, mac_addr);  
         break;
      default:
         return;
   }
}

static inline void BR_FP_HOOK_TIMERS(struct net_bridge_port * port, unsigned char * mac_addr, unsigned char * flag, int action) 
{ 
   struct net_bridge *br = port->br;
#if defined(ARCADYAN)
   struct br_fp_data *fp=br->fp_hooks;
#else
   struct br_fp_data *fp=&(br->fp_hooks);
#endif

   BR_FP_DEBUG(2, "%s %d %p %d\n", __FUNCTION__, __LINE__, fp, action);
   switch (action) {  
      case BR_FP_FDB_CHECK_AGE:
         if (fp && fp->fdb_check_age)
            *flag = fp->fdb_check_age(port->dev, mac_addr);
         break;
      default:
         return;
   }
}

static inline void BR_FP_HOOK_IPTV (struct net_bridge_port * port, unsigned long dip, int action)
{
   struct net_bridge *br = port->br;
#if defined(ARCADYAN)
   struct br_fp_data *fp=br->fp_hooks;
#else
   struct br_fp_data *fp=&(br->fp_hooks);
#endif
   int res;

   BR_FP_DEBUG(2, "%s %d %p %d\n", __FUNCTION__, __LINE__,fp, action); 
   switch (action) { 
      case BR_FP_IPTV_ADD:
         if (fp && fp->iptv_add)  
            res = fp->iptv_add(port->dev, dip);  
         break;
      case BR_FP_IPTV_REMOVE: 
         if (fp && fp->iptv_remove) 
            res = fp->iptv_remove(port->dev, dip); 
         break; 
      case BR_FP_IPTV_MODIFY: 
         if (fp && fp->iptv_modify) 
            res = fp->iptv_modify(port->dev, dip);  
         break;
      default:
         return;
   }
}

#endif /* __BR_FP_HOOKS_H__ */

